/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_20_R1;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.ama.api.IArena;
import su.nightexpress.ama.api.type.MobFaction;
import su.nightexpress.ama.nms.v1_20_R1.mob.AllayMob;
import su.nightexpress.ama.nms.v1_20_R1.mob.FrogMob;
import su.nightexpress.ama.nms.v1_20_R1.mob.GoatMob;
import su.nightexpress.ama.nms.v1_20_R1.mob.HoglinMob;
import su.nightexpress.ama.nms.v1_20_R1.mob.PiglinBruteMob;
import su.nightexpress.ama.nms.v1_20_R1.mob.PiglinMob;
import su.nightexpress.ama.nms.v1_20_R1.mob.ZoglinMob;

public class EntityInjector {
    public static final Map<EntityType, EntityTypes<? extends EntityInsentient>> BASIC = new HashMap<EntityType, EntityTypes<? extends EntityInsentient>>();
    public static final Map<EntityType, Class<? extends EntityInsentient>> BRAINED = new HashMap<EntityType, Class<? extends EntityInsentient>>();

    public static void setup() {
        BRAINED.put(EntityType.PIGLIN, PiglinMob.class);
        BRAINED.put(EntityType.PIGLIN_BRUTE, PiglinBruteMob.class);
        BRAINED.put(EntityType.HOGLIN, HoglinMob.class);
        BRAINED.put(EntityType.ZOGLIN, ZoglinMob.class);
        BRAINED.put(EntityType.GOAT, GoatMob.class);
        BRAINED.put(EntityType.FROG, FrogMob.class);
        BRAINED.put(EntityType.ALLAY, AllayMob.class);
        BASIC.put(EntityType.BEE, (EntityTypes<? extends EntityInsentient>)EntityTypes.h);
        BASIC.put(EntityType.BLAZE, (EntityTypes<? extends EntityInsentient>)EntityTypes.i);
        BASIC.put(EntityType.CAT, (EntityTypes<? extends EntityInsentient>)EntityTypes.m);
        BASIC.put(EntityType.CAVE_SPIDER, (EntityTypes<? extends EntityInsentient>)EntityTypes.n);
        BASIC.put(EntityType.COW, (EntityTypes<? extends EntityInsentient>)EntityTypes.t);
        BASIC.put(EntityType.CHICKEN, (EntityTypes<? extends EntityInsentient>)EntityTypes.q);
        BASIC.put(EntityType.CREEPER, (EntityTypes<? extends EntityInsentient>)EntityTypes.u);
        BASIC.put(EntityType.DONKEY, (EntityTypes<? extends EntityInsentient>)EntityTypes.w);
        BASIC.put(EntityType.DROWNED, (EntityTypes<? extends EntityInsentient>)EntityTypes.y);
        BASIC.put(EntityType.ELDER_GUARDIAN, (EntityTypes<? extends EntityInsentient>)EntityTypes.A);
        BASIC.put(EntityType.ENDERMAN, (EntityTypes<? extends EntityInsentient>)EntityTypes.E);
        BASIC.put(EntityType.ENDERMITE, (EntityTypes<? extends EntityInsentient>)EntityTypes.F);
        BASIC.put(EntityType.EVOKER, (EntityTypes<? extends EntityInsentient>)EntityTypes.G);
        BASIC.put(EntityType.FOX, (EntityTypes<? extends EntityInsentient>)EntityTypes.N);
        BASIC.put(EntityType.GHAST, (EntityTypes<? extends EntityInsentient>)EntityTypes.Q);
        BASIC.put(EntityType.GIANT, (EntityTypes<? extends EntityInsentient>)EntityTypes.R);
        BASIC.put(EntityType.GUARDIAN, (EntityTypes<? extends EntityInsentient>)EntityTypes.V);
        BASIC.put(EntityType.HORSE, (EntityTypes<? extends EntityInsentient>)EntityTypes.Y);
        BASIC.put(EntityType.HUSK, (EntityTypes<? extends EntityInsentient>)EntityTypes.Z);
        BASIC.put(EntityType.ILLUSIONER, (EntityTypes<? extends EntityInsentient>)EntityTypes.aa);
        BASIC.put(EntityType.IRON_GOLEM, (EntityTypes<? extends EntityInsentient>)EntityTypes.ac);
        BASIC.put(EntityType.LLAMA, (EntityTypes<? extends EntityInsentient>)EntityTypes.aj);
        BASIC.put(EntityType.MAGMA_CUBE, (EntityTypes<? extends EntityInsentient>)EntityTypes.al);
        BASIC.put(EntityType.MULE, (EntityTypes<? extends EntityInsentient>)EntityTypes.ap);
        BASIC.put(EntityType.MUSHROOM_COW, (EntityTypes<? extends EntityInsentient>)EntityTypes.ao);
        BASIC.put(EntityType.OCELOT, (EntityTypes<? extends EntityInsentient>)EntityTypes.aq);
        BASIC.put(EntityType.PANDA, (EntityTypes<? extends EntityInsentient>)EntityTypes.as);
        BASIC.put(EntityType.PIG, (EntityTypes<? extends EntityInsentient>)EntityTypes.av);
        BASIC.put(EntityType.PILLAGER, (EntityTypes<? extends EntityInsentient>)EntityTypes.ay);
        BASIC.put(EntityType.PHANTOM, (EntityTypes<? extends EntityInsentient>)EntityTypes.au);
        BASIC.put(EntityType.POLAR_BEAR, (EntityTypes<? extends EntityInsentient>)EntityTypes.az);
        BASIC.put(EntityType.RABBIT, (EntityTypes<? extends EntityInsentient>)EntityTypes.aC);
        BASIC.put(EntityType.RAVAGER, (EntityTypes<? extends EntityInsentient>)EntityTypes.aD);
        BASIC.put(EntityType.SHEEP, (EntityTypes<? extends EntityInsentient>)EntityTypes.aF);
        BASIC.put(EntityType.SHULKER, (EntityTypes<? extends EntityInsentient>)EntityTypes.aG);
        BASIC.put(EntityType.SILVERFISH, (EntityTypes<? extends EntityInsentient>)EntityTypes.aI);
        BASIC.put(EntityType.SLIME, (EntityTypes<? extends EntityInsentient>)EntityTypes.aL);
        BASIC.put(EntityType.STRAY, (EntityTypes<? extends EntityInsentient>)EntityTypes.aU);
        BASIC.put(EntityType.SKELETON, (EntityTypes<? extends EntityInsentient>)EntityTypes.aJ);
        BASIC.put(EntityType.SKELETON_HORSE, (EntityTypes<? extends EntityInsentient>)EntityTypes.aK);
        BASIC.put(EntityType.SPIDER, (EntityTypes<? extends EntityInsentient>)EntityTypes.aS);
        BASIC.put(EntityType.SNOWMAN, (EntityTypes<? extends EntityInsentient>)EntityTypes.aO);
        BASIC.put(EntityType.TURTLE, (EntityTypes<? extends EntityInsentient>)EntityTypes.bd);
        BASIC.put(EntityType.TRADER_LLAMA, (EntityTypes<? extends EntityInsentient>)EntityTypes.ba);
        BASIC.put(EntityType.VEX, (EntityTypes<? extends EntityInsentient>)EntityTypes.be);
        BASIC.put(EntityType.VILLAGER, (EntityTypes<? extends EntityInsentient>)EntityTypes.bf);
        BASIC.put(EntityType.VINDICATOR, (EntityTypes<? extends EntityInsentient>)EntityTypes.bg);
        BASIC.put(EntityType.WANDERING_TRADER, (EntityTypes<? extends EntityInsentient>)EntityTypes.bh);
        BASIC.put(EntityType.WITCH, (EntityTypes<? extends EntityInsentient>)EntityTypes.bj);
        BASIC.put(EntityType.WITHER_SKELETON, (EntityTypes<? extends EntityInsentient>)EntityTypes.bl);
        BASIC.put(EntityType.WITHER, (EntityTypes<? extends EntityInsentient>)EntityTypes.bk);
        BASIC.put(EntityType.WOLF, (EntityTypes<? extends EntityInsentient>)EntityTypes.bn);
        BASIC.put(EntityType.ZOMBIE, (EntityTypes<? extends EntityInsentient>)EntityTypes.bp);
        BASIC.put(EntityType.ZOMBIE_HORSE, (EntityTypes<? extends EntityInsentient>)EntityTypes.bq);
        BASIC.put(EntityType.ZOMBIE_VILLAGER, (EntityTypes<? extends EntityInsentient>)EntityTypes.br);
        BASIC.put(EntityType.ZOMBIFIED_PIGLIN, (EntityTypes<? extends EntityInsentient>)EntityTypes.bs);
    }

    @Nullable
    public static EntityInsentient spawnEntity(@NotNull IArena iArena, @NotNull MobFaction mobFaction, @NotNull EntityType entityType, @NotNull Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        return EntityInjector.createBrained(iArena, mobFaction, entityType, worldServer, location);
    }

    @Nullable
    private static EntityInsentient createBrained(@NotNull IArena iArena, @NotNull MobFaction mobFaction, @NotNull EntityType entityType, @NotNull WorldServer worldServer, @NotNull Location location) {
        Class<? extends EntityInsentient> clazz = BRAINED.get(entityType);
        if (clazz == null) {
            return EntityInjector.createBasic(iArena, entityType, worldServer, location);
        }
        try {
            EntityInsentient entityInsentient = clazz.getConstructor(WorldServer.class, IArena.class, MobFaction.class).newInstance(new Object[]{worldServer, iArena, mobFaction});
            worldServer.addFreshEntity((Entity)entityInsentient, null);
            return entityInsentient;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static EntityInsentient createBasic(@NotNull IArena iArena, @NotNull EntityType entityType, @NotNull WorldServer worldServer, @NotNull Location location) {
        EnumMobSpawn enumMobSpawn;
        EntityTypes<? extends EntityInsentient> entityTypes = BASIC.get(entityType);
        if (entityTypes == null) {
            return null;
        }
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        EntityInsentient entityInsentient = (EntityInsentient)entityTypes.b(worldServer, null, null, blockPosition, enumMobSpawn = EnumMobSpawn.n, false, false);
        if (entityInsentient != null) {
            worldServer.addFreshEntity((Entity)entityInsentient, null);
        }
        return entityInsentient;
    }
}

