/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_20_R1.brain.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorForgetAnger;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.api.IArena;
import su.nightexpress.ama.api.type.MobFaction;
import su.nightexpress.ama.nms.ArenaMob;
import su.nightexpress.ama.nms.v1_20_R1.brain.MobAI;

public class MobFightBehaviors {
    private static final PathfinderTargetCondition HURT_BY_TARGETING = PathfinderTargetCondition.a().d().e();

    @NotNull
    public static BehaviorControl<EntityInsentient> autoTargetAndAttack() {
        return BehaviorBuilder.a(b2 -> b2.group((App)b2.c(MemoryModuleType.o), (App)b2.a(MemoryModuleType.E)).apply((Applicative)b2, (memoryAccessor, memoryAccessor2) -> (worldServer, entityInsentient, l) -> {
            IArena iArena;
            if (!(entityInsentient instanceof ArenaMob)) {
                return false;
            }
            ArenaMob arenaMob = (ArenaMob)entityInsentient;
            EntityLiving entityLiving = MobAI.getAngerTarget(entityInsentient).orElse(null);
            if (entityLiving == null) {
                iArena = arenaMob.getArena();
                MobFaction mobFaction = arenaMob.getFaction();
                HashSet hashSet = new HashSet();
                if (mobFaction == MobFaction.ENEMY) {
                    hashSet.addAll(iArena.getAliveGamePlayers().stream().map(player -> ((CraftPlayer)player).getHandle()).collect(Collectors.toSet()));
                    hashSet.addAll(iArena.getMobs().getAllies().stream().map(livingEntity -> ((CraftLivingEntity)livingEntity).getHandle()).collect(Collectors.toSet()));
                } else if (mobFaction == MobFaction.ALLY) {
                    hashSet.addAll(iArena.getMobs().getEnemies().stream().map(livingEntity -> ((CraftLivingEntity)livingEntity).getHandle()).collect(Collectors.toSet()));
                }
                if (!hashSet.isEmpty()) {
                    entityLiving = (EntityLiving)Rnd.get(hashSet);
                }
            }
            if (entityLiving == null) {
                return false;
            }
            if (!entityInsentient.c(entityLiving)) {
                return false;
            }
            iArena = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)entityInsentient, (EntityLiving)entityLiving, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.CLOSEST_PLAYER);
            if (iArena.isCancelled()) {
                return false;
            }
            if (iArena.getTarget() == null) {
                memoryAccessor.b();
                return true;
            }
            entityLiving = ((CraftLivingEntity)iArena.getTarget()).getHandle();
            return MobAI.setAngerTarget(entityInsentient, entityLiving, true);
        }));
    }

    @NotNull
    public static OneShot<EntityInsentient> meleeAttack(int n) {
        return BehaviorBuilder.a(b2 -> b2.group((App)b2.a(MemoryModuleType.n), (App)b2.b(MemoryModuleType.o), (App)b2.c(MemoryModuleType.p)).apply((Applicative)b2, (memoryAccessor, memoryAccessor2, memoryAccessor3) -> (worldServer, entityInsentient, l) -> {
            EntityLiving entityLiving = (EntityLiving)b2.b(memoryAccessor2);
            if (MobFightBehaviors.isHoldingUsableProjectileWeapon(entityInsentient)) {
                return false;
            }
            if (!entityInsentient.k(entityLiving)) {
                return false;
            }
            memoryAccessor.a((Object)new BehaviorPositionEntity((net.minecraft.world.entity.Entity)entityLiving, true));
            entityInsentient.a(EnumHand.a);
            entityInsentient.z((net.minecraft.world.entity.Entity)entityLiving);
            memoryAccessor3.a((Object)true, (long)n);
            return true;
        }));
    }

    private static boolean isHoldingUsableProjectileWeapon(EntityInsentient entityInsentient) {
        return entityInsentient.b(itemStack -> {
            ItemProjectileWeapon itemProjectileWeapon;
            Item item = itemStack.d();
            return item instanceof ItemProjectileWeapon && entityInsentient.a(itemProjectileWeapon = (ItemProjectileWeapon)item);
        });
    }

    @NotNull
    public static BehaviorControl<EntityInsentient> stopAttackIfTargetInvalid(@NotNull EntityInsentient entityInsentient) {
        return BehaviorBuilder.a(b2 -> b2.group((App)b2.b(MemoryModuleType.o), (App)b2.a(MemoryModuleType.E)).apply((Applicative)b2, (memoryAccessor, memoryAccessor2) -> (worldServer, entityInsentient2, l) -> {
            if (!(entityInsentient2 instanceof ArenaMob)) {
                return true;
            }
            ArenaMob arenaMob = (ArenaMob)entityInsentient2;
            EntityLiving entityLiving = (EntityLiving)b2.b(memoryAccessor);
            Set set = arenaMob.getArena().getAliveGamePlayers().stream().map(Entity::getUniqueId).collect(Collectors.toSet());
            if (!set.contains(entityLiving.ct())) {
                MobAI.setAvoidTargetAndDontHuntForAWhile(entityInsentient, entityLiving);
                return true;
            }
            return false;
        }));
    }

    @NotNull
    public static BehaviorControl<EntityLiving> stopAngryIfTargetDead() {
        return BehaviorForgetAnger.a();
    }

    @NotNull
    public static BehaviorControl<EntityInsentient> reachTargetWhenOutOfRange() {
        Function<EntityLiving, Float> function = entityLiving -> Float.valueOf(1.0f);
        return BehaviorBuilder.a(b2 -> b2.group((App)b2.a(MemoryModuleType.m), (App)b2.a(MemoryModuleType.n), (App)b2.b(MemoryModuleType.o)).apply((Applicative)b2, (memoryAccessor, memoryAccessor2, memoryAccessor3) -> (worldServer, entityInsentient, l) -> {
            EntityLiving entityLiving = (EntityLiving)b2.b(memoryAccessor3);
            if (BehaviorUtil.a((EntityInsentient)entityInsentient, (EntityLiving)entityLiving, (int)1)) {
                memoryAccessor.b();
            } else {
                memoryAccessor2.a((Object)new BehaviorPositionEntity((net.minecraft.world.entity.Entity)entityLiving, true));
                memoryAccessor.a((Object)new MemoryTarget((BehaviorPosition)new BehaviorPositionEntity((net.minecraft.world.entity.Entity)entityLiving, false), ((Float)function.apply(entityInsentient)).floatValue(), 1));
            }
            return true;
        }));
    }
}

