/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_20_R1.brain.goal;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.api.IArena;
import su.nightexpress.ama.api.type.MobFaction;

public class NearestFactionTargetGoal<T extends EntityLiving>
extends PathfinderGoalTarget {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    private final IArena arena;
    private final MobFaction faction;
    private final PathfinderTargetCondition targetConditions;
    private EntityLiving target;

    public NearestFactionTargetGoal(@NotNull EntityInsentient entityInsentient, @NotNull IArena iArena, @NotNull MobFaction mobFaction) {
        super(entityInsentient, false, true);
        this.a(EnumSet.of(PathfinderGoal.Type.d));
        this.arena = iArena;
        this.faction = mobFaction;
        this.targetConditions = PathfinderTargetCondition.a().d().a(this.l());
    }

    public boolean a() {
        this.findTarget();
        return this.target != null;
    }

    protected void findTarget() {
        HashSet<EntityLiving> hashSet = new HashSet<EntityLiving>();
        if (this.faction == MobFaction.ENEMY) {
            hashSet.addAll(this.arena.getAliveGamePlayers().stream().map(player -> ((CraftPlayer)player).getHandle()).collect(Collectors.toSet()));
            hashSet.addAll(this.arena.getMobs().getAllies().stream().map(livingEntity -> ((CraftLivingEntity)livingEntity).getHandle()).collect(Collectors.toSet()));
        } else if (this.faction == MobFaction.ALLY) {
            hashSet.addAll(this.arena.getMobs().getEnemies().stream().map(livingEntity -> ((CraftLivingEntity)livingEntity).getHandle()).collect(Collectors.toSet()));
        }
        hashSet.removeIf(entityLiving -> !this.targetConditions.a((EntityLiving)this.e, entityLiving));
        this.target = !hashSet.isEmpty() ? (EntityLiving)Rnd.get(hashSet) : null;
    }

    public void c() {
        EntityTargetEvent.TargetReason targetReason = this.faction == MobFaction.ENEMY ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY;
        this.e.setTarget(this.target, targetReason, true);
        super.c();
    }

    public void setTarget(@Nullable EntityLiving entityLiving) {
        this.target = entityLiving;
    }
}

