/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_20_R1.mob;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.RamTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.api.IArena;
import su.nightexpress.ama.api.type.MobFaction;
import su.nightexpress.ama.nms.ArenaMob;
import su.nightexpress.ama.nms.v1_20_R1.brain.MobAI;
import su.nightexpress.ama.nms.v1_20_R1.brain.MobBrain;
import su.nightexpress.ama.nms.v1_20_R1.brain.behavior.MobCoreBehaviors;
import su.nightexpress.ama.nms.v1_20_R1.brain.behavior.MobFightBehaviors;
import su.nightexpress.ama.nms.v1_20_R1.brain.behavior.impl.PrepareRamTarget;

public class GoatMob
extends Goat
implements ArenaMob {
    public static final UniformInt TIME_BETWEEN_RAMS = UniformInt.a((int)100, (int)300);
    private static final PathfinderTargetCondition RAM_TARGET_CONDITIONS = PathfinderTargetCondition.a().a(entityLiving -> true);
    public static final int RAM_MIN_DISTANCE = 4;
    private final IArena arena;
    private final MobFaction faction;

    public GoatMob(@NotNull WorldServer worldServer, @NotNull IArena iArena, @NotNull MobFaction mobFaction) {
        super(EntityTypes.U, (World)worldServer);
        this.arena = iArena;
        this.faction = mobFaction;
        this.dK().a(MemoryModuleType.U, (Object)TIME_BETWEEN_RAMS.a(this.dI().z));
    }

    @Override
    @NotNull
    public IArena getArena() {
        return this.arena;
    }

    @Override
    @NotNull
    public MobFaction getFaction() {
        return this.faction;
    }

    protected BehaviorController.b<Goat> dL() {
        return MobBrain.brainProvider(this);
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.refreshBrain(this, (BehaviorController<Goat>)this.dL().a(dynamic));
    }

    @NotNull
    public BehaviorController<Goat> refreshBrain(@NotNull Goat goat2, @NotNull BehaviorController<Goat> behaviorController) {
        CountDownCooldownTicks countDownCooldownTicks = new CountDownCooldownTicks(MemoryModuleType.U);
        behaviorController.a(Activity.a, 0, ImmutableList.of(MobCoreBehaviors.lookAtTarget(), MobCoreBehaviors.moveToTarget(), MobCoreBehaviors.swim(), (Object)countDownCooldownTicks, MobFightBehaviors.stopAngryIfTargetDead()));
        behaviorController.a(Activity.b, 10, ImmutableList.of(MobFightBehaviors.autoTargetAndAttack()));
        behaviorController.a(Activity.k, 10, ImmutableList.of(MobFightBehaviors.stopAttackIfTargetInvalid((EntityInsentient)goat2), MobFightBehaviors.reachTargetWhenOutOfRange(), MobFightBehaviors.meleeAttack(20)));
        behaviorController.a(Activity.r, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RamTarget(goat -> TIME_BETWEEN_RAMS, RAM_TARGET_CONDITIONS, 3.0f, goat -> goat.h_() ? 1.0 : 2.5, goat -> goat.gi() ? SoundEffects.jU : SoundEffects.jK, goat -> goat.gi() ? SoundEffects.jV : SoundEffects.jL)), (Object)Pair.of((Object)1, new PrepareRamTarget<Goat>(4, 10, 1.5f, 20, goat -> goat.gi() ? SoundEffects.jT : SoundEffects.jJ))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.U, (Object)MemoryStatus.b)));
        behaviorController.a((Set)ImmutableSet.of((Object)Activity.a));
        behaviorController.b(Activity.b);
        behaviorController.f();
        this.bA = behaviorController;
        return behaviorController;
    }

    protected void W() {
        this.dI().ad().a("goatBrain");
        this.dK().a((WorldServer)this.dI(), (EntityLiving)this);
        this.dI().ad().c();
        this.dI().ad().a("goatActivityUpdate");
        this.updateActivity();
        this.dI().ad().c();
    }

    protected void updateActivity() {
        BehaviorController behaviorController = this.dK();
        if (MobAI.getAngerTarget((EntityInsentient)this).isPresent()) {
            behaviorController.a((List)ImmutableList.of((Object)Activity.r, (Object)Activity.k));
        } else {
            behaviorController.a(Activity.b);
        }
        this.v(behaviorController.a(MemoryModuleType.o));
    }

    public boolean a(DamageSource damageSource, float f) {
        Entity entity;
        if (super.a(damageSource, f) && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            MobAI.setAngerTarget((EntityInsentient)this, entityLiving, false);
            return true;
        }
        return false;
    }

    public EnumInteractionResult b(EntityHuman entityHuman, EnumHand enumHand) {
        return EnumInteractionResult.a((boolean)this.dI().B);
    }

    public boolean gf() {
        return false;
    }

    public boolean P_() {
        return false;
    }

    public boolean fZ() {
        return false;
    }

    public void g(@Nullable EntityHuman entityHuman) {
    }

    public void s(int n) {
    }

    public boolean gc() {
        return false;
    }

    public boolean a(EntityAnimal entityAnimal) {
        return false;
    }

    public void a(WorldServer worldServer, EntityAnimal entityAnimal) {
    }

    public boolean m(ItemStack itemStack) {
        return false;
    }
}

