/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.sign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.utils.LocationUtil;
import su.nexmedia.engine.utils.PDCUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Keys;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.sign.listener.SignListener;
import su.nightexpress.ama.sign.type.SignType;
import su.nightexpress.ama.stats.object.StatType;
import su.nightexpress.ama.stats.object.StatsScore;

public class SignManager
extends AbstractManager<AMA> {
    private static final String HEADER = "AMA";
    private Map<SignType, Set<Sign>> signs;

    public SignManager(@NotNull AMA aMA) {
        super((NexPlugin)aMA);
        DirMctLeUksmXxYhyQckpM3wxEWJVKy.1EjfNFBbuR(Class.forName("DiTectLeaSsnRcxog9aAnPQPPPboQo"));
    }

    protected void onLoad() {
        this.signs = new HashMap<SignType, Set<Sign>>();
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DiRe3TlEcKS", "\t0T\u0007\n\u001dZ6\u001f\u00025\b\f\u0010\t\u001c#\u0017\u001bk;$\"", (Object)"\u001d \u000e:\u0000\u0012W&\u000f\u0016 \b", "Rl6\u0006\u0011\u001d\u001d \u000f\u0011.\u0013\u001dL\tQ*\u001f\u001e0\u0016\f\u0011Up7\u0011\u0011,\u000e:\u0000\u0012W&\u000f\u0016 \bR", 75, -387851308, "XzQRct40noWzCohLNEVvDNFgnIQC4INNu1C8nTgHoKIrxUIATZP", (Object)((AMA)this.plugin)).runTaskLater((Plugin)this.plugin, () -> {
            ((AMA)this.plugin).getConfig().getStringList("Signs.Locations").forEach(string -> {
                Object object;
                Location location = LocationUtil.deserialize((String)string);
                if (location == null || !((object = location.getBlock().getState()) instanceof Sign)) {
                    return;
                }
                Sign sign = (Sign)object;
                object = this.getSignType(sign);
                if (object == null) {
                    return;
                }
                this.getSigns((SignType)((Object)((Object)((Object)object)))).add(sign);
            });
            this.update();
        }, 10L);
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DiRe3TlEcKS", "\u001d,@\u0007\f\tZ6\u000b\u0016)\u001c\f\u0016\u001d\u001c#\u0003\u000fw\u001d\u0000\u0002\u0000\u001c\u0011\u0007\t7#\b\u000b\u000fU'\u001c", (Object)"\u000f=\n%\f\u001dF'\u0000\u000b+", "F\u0015\u001d\u001cJ\u0000W:\u0003\u000b=\u0007\bJ\u000b\\%\u0007\u0000<A\b\u0015\u0007\u001d/\u000f\u00008\t\f\u0017Aw4\u000b\u0000-\"\u0000\u0016\u001aW,\u000b\u001cbG?", 75, -0.42729105486769003, "enTYeKqamrKCLyVC8YzEg3FzfaaMJXoTz4Qo6ybSHulSS", (Object)this, (Object)new SignListener(this));
    }

    protected void onShutdown() {
        ((AMA)this.plugin).getConfig().reload();
        ((AMA)this.plugin).getConfig().set("Signs.Locations", this.signs.values().stream().flatMap(Collection::stream).map(BlockState::getLocation).map(LocationUtil::serialize).toList());
        ((AMA)this.plugin).getConfig().saveChanges();
        this.signs.clear();
    }

    @NotNull
    public Set<Sign> getSigns(@NotNull SignType signType2) {
        return this.signs.computeIfAbsent(signType2, signType -> new HashSet());
    }

    public void update() {
        Stream.of(SignType.values()).forEach(this::update);
    }

    public void update(@NotNull SignType signType) {
        this.getSigns(signType).stream().filter(sign -> sign.getBlock().getState() instanceof Sign).forEach(sign -> this.setSignText((Sign)sign, signType, ((Map)Config.SIGNS_FORMAT.get()).getOrDefault((Object)signType, Collections.emptyList())));
    }

    public void setSignText(@NotNull Sign sign, @NotNull SignType signType, @NotNull List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        switch (signType) {
            case ARENA_JOIN: 
            case ARENA_LEAVE: 
            case ARENA_READY: 
            case ARENA_SHOP: {
                Object object = this.getSignArena(sign);
                if (object == null) break;
                arrayList.replaceAll(object.replacePlaceholders());
                break;
            }
            case KIT: {
                Object object = this.getSignKit(sign);
                if (object == null) break;
                arrayList.replaceAll(object.replacePlaceholders());
                break;
            }
            case STATS: {
                Skull skull;
                StatType statType;
                Object object = PDCUtil.getString((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_STAT_TYPE).orElse(null);
                StatType statType2 = statType = object != null ? (StatType)StringUtil.getEnum((String)object, StatType.class).orElse(null) : null;
                if (statType == null) {
                    return;
                }
                int n = PDCUtil.getInt((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_STAT_POSITION).orElse(-1);
                if (n < 1) {
                    return;
                }
                String string2 = PDCUtil.getString((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_ARENA_ID).orElse(null);
                Arena arena = string2 != null ? ((AMA)this.plugin).getArenaManager().getArenaById(string2) : null;
                StatsScore statsScore = ((AMA)this.plugin).getStatsManager().getScore(statType, n, string2);
                arrayList.replaceAll(string -> ((String)statsScore.replacePlaceholders(n).apply((String)string)).replace("%arena_name%", arena != null ? arena.getConfig().getName() : ""));
                String string3 = statsScore.isEmpty() ? "MHF_Question" : statsScore.getName();
                Block block = sign.getBlock().getRelative(BlockFace.UP);
                BlockState blockState = block.getState();
                if (blockState instanceof Skull) {
                    skull = (Skull)blockState;
                    skull.setOwner(string3);
                    skull.update();
                }
                if (!((blockState = sign.getBlockData()) instanceof Directional)) break;
                skull = (Directional)blockState;
                blockState = sign.getBlock().getRelative(skull.getFacing().getOppositeFace());
                Block block2 = blockState.getRelative(BlockFace.UP);
                BlockState blockState2 = block2.getState();
                if (blockState2 instanceof Skull) {
                    Skull skull2 = (Skull)blockState2;
                    skull2.setOwner(string3);
                    skull2.update();
                    break;
                }
                ((AMA)this.plugin).getStatsManager().setLeaderSkin(block2, statsScore.getName());
            }
        }
        for (int i = 0; i < 4 && i < arrayList.size(); ++i) {
            sign.setLine(i, (String)arrayList.get(i));
        }
        sign.setGlowingText(((Boolean)Config.SIGNS_GLOWING.get()).booleanValue());
        sign.update(true);
    }

    @Nullable
    public SignType getSignType(@NotNull Sign sign) {
        String string = PDCUtil.getString((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_TYPE).orElse(null);
        if (string == null) {
            return null;
        }
        return StringUtil.getEnum((String)string, SignType.class).orElse(null);
    }

    @Nullable
    public Arena getSignArena(@NotNull Sign sign) {
        String string = PDCUtil.getString((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_ARENA_ID).orElse(null);
        return string == null ? null : ((AMA)this.plugin).getArenaManager().getArenaById(string);
    }

    @Nullable
    public Kit getSignKit(@NotNull Sign sign) {
        String string = PDCUtil.getString((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_KIT_ID).orElse(null);
        return string == null ? null : ((AMA)this.plugin).getKitManager().getKitById(string);
    }

    public boolean signCreate(@NotNull Sign sign, @NotNull String[] stringArray) {
        if (stringArray.length < 2) {
            return false;
        }
        String string = stringArray[0];
        if (!string.equalsIgnoreCase(HEADER)) {
            return false;
        }
        SignType signType = StringUtil.getEnum((String)stringArray[1], SignType.class).orElse(null);
        if (signType == null) {
            return false;
        }
        if (signType == SignType.ARENA_JOIN) {
            if (stringArray.length < 3) {
                return false;
            }
            String string2 = stringArray[2];
            if (!((AMA)this.plugin).getArenaManager().isArenaExists(string2)) {
                return false;
            }
            PDCUtil.set((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_ARENA_ID, (String)string2);
        } else if (signType == SignType.KIT) {
            if (stringArray.length < 3) {
                return false;
            }
            String string3 = stringArray[2];
            if (!((AMA)this.plugin).getKitManager().isKitExists(string3)) {
                return false;
            }
            PDCUtil.set((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_KIT_ID, (String)string3);
        } else if (signType == SignType.STATS) {
            if (stringArray.length < 4) {
                return false;
            }
            StatType statType = StringUtil.getEnum((String)stringArray[2], StatType.class).orElse(null);
            if (statType == null) {
                return false;
            }
            String[] stringArray2 = stringArray[3].split(":");
            int n = StringUtil.getInteger((String)stringArray2[0], (int)-1);
            if (n <= 0) {
                return false;
            }
            Arena arena = stringArray2.length >= 2 ? ((AMA)this.plugin).getArenaManager().getArenaById(stringArray2[1]) : null;
            PDCUtil.set((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_STAT_TYPE, (String)statType.name());
            PDCUtil.set((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_STAT_POSITION, (int)n);
            if (arena != null) {
                PDCUtil.set((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_ARENA_ID, (String)arena.getId());
            }
        }
        PDCUtil.set((PersistentDataHolder)sign, (NamespacedKey)Keys.SIGN_TYPE, (String)signType.name());
        this.getSigns(signType).add(sign);
        ((AMA)this.plugin).getScheduler().runTask((Plugin)this.plugin, () -> this.update(signType));
        return true;
    }

    public boolean signInteract(@NotNull Player player, @NotNull Sign sign) {
        SignType signType = this.getSignType(sign);
        if (signType == null) {
            return false;
        }
        if (player.isSneaking() && player.getGameMode() == GameMode.CREATIVE) {
            return false;
        }
        switch (signType) {
            case ARENA_JOIN: {
                Arena arena = this.getSignArena(sign);
                if (arena == null) {
                    return false;
                }
                arena.joinLobby(player);
                break;
            }
            case ARENA_SHOP: {
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                if (arenaPlayer == null) {
                    return false;
                }
                arenaPlayer.getArena().getConfig().getShopManager().open(player);
                break;
            }
            case ARENA_LEAVE: {
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                if (arenaPlayer == null) {
                    return false;
                }
                arenaPlayer.leaveArena();
                break;
            }
            case ARENA_READY: {
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                if (arenaPlayer == null || arenaPlayer.isInGame()) {
                    return false;
                }
                arenaPlayer.setState(arenaPlayer.isReady() ? GameState.WAITING : GameState.READY);
                break;
            }
            case KIT: {
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                if (arenaPlayer == null) {
                    return false;
                }
                Kit kit = this.getSignKit(sign);
                if (kit == null) {
                    return false;
                }
                if (!kit.isAvailable(arenaPlayer, true) || !kit.buy(arenaPlayer)) break;
                ((AMA)this.plugin).getMessage(Lang.Kit_Select_Success).replace(kit.replacePlaceholders()).send((CommandSender)player);
                break;
            }
            case KIT_SHOP: {
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                if (arenaPlayer == null) {
                    return false;
                }
                ((AMA)this.plugin).getKitManager().getShopMenu().open(player, 1);
                break;
            }
            case KIT_SELECTOR: {
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                if (arenaPlayer == null) {
                    return false;
                }
                ((AMA)this.plugin).getKitManager().getSelectMenu().open(player, 1);
                break;
            }
            case STATS_OPEN: {
                ((AMA)this.plugin).getStatsManager().getStatsMenu().open(player, 1);
            }
        }
        return true;
    }
}

