/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.stats.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.api.menu.click.ClickHandler;
import su.nexmedia.engine.api.menu.impl.ConfigMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.item.MenuItem;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.stats.object.StatType;

public class StatsMenu
extends ConfigMenu<AMA> {
    private static final String PLACEHOLDER_SCORE = "%score%";
    private static final String PLACEHOLDER_TOTAL = "%total%";

    public StatsMenu(@NotNull AMA aMA, @NotNull JYML jYML) {
        super((NexPlugin)aMA, jYML);
        int n = 0;
        for (StatType statType : StatType.values()) {
            String string = "Stat_Icons." + statType.name() + ".";
            jYML.addMissing(string + "Item.Material", (Object)Material.MAP.name());
            jYML.addMissing(string + "Item.Name", (Object)aMA.getLangManager().getEnum((Enum)statType));
            jYML.addMissing(string + "Item.Lore", Arrays.asList("%arena_name%: %score%", PLACEHOLDER_TOTAL));
            jYML.addMissing(string + "Slots", (Object)n++);
            jYML.addMissing(string + "Type", (Object)statType.name());
        }
        jYML.saveChanges();
        this.registerHandler(MenuItemType.class).addClick((Enum)MenuItemType.CLOSE, (menuViewer, inventoryClickEvent) -> aMA.runTask(bukkitTask -> menuViewer.getPlayer().closeInventory())).addClick((Enum)MenuItemType.PAGE_NEXT, ClickHandler.forNextPage((Menu)this)).addClick((Enum)MenuItemType.PAGE_PREVIOUS, ClickHandler.forPreviousPage((Menu)this));
        this.load();
        for (String string : jYML.getSection("Stat_Icons")) {
            StatType statType;
            StatType statType2 = StringUtil.getEnum((String)string, StatType.class).orElse(null);
            if (statType2 == null) continue;
            statType = this.readItem("Stat_Icons." + string);
            statType.getOptions().addDisplayModifier((menuViewer, itemStack) -> {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta == null) {
                    return;
                }
                List list = itemMeta.getLore();
                if (list == null) {
                    return;
                }
                ArenaUser arenaUser = (ArenaUser)aMA.getUserManager().getUserData(menuViewer.getPlayer());
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : list) {
                    if (string.contains("%arena_name%")) {
                        for (Arena arena : aMA.getArenaManager().getArenas()) {
                            String string2 = String.valueOf(arenaUser.getStats(statType2, arena.getId()));
                            arrayList.add(((String)arena.getConfig().replacePlaceholders().apply(string)).replace(PLACEHOLDER_SCORE, string2));
                        }
                        continue;
                    }
                    arrayList.add(string.replace(PLACEHOLDER_TOTAL, String.valueOf(arenaUser.getStats(statType2))));
                }
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
            });
            this.addItem((MenuItem)statType);
        }
    }
}

