/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.mobs.impl.customMobs.listeners;

import net.advancedplugins.mobs.impl.customMobs.CustomEntityHandler;
import net.advancedplugins.mobs.impl.customMobs.entityBuilders.subclass.SoundType;
import net.advancedplugins.mobs.impl.customMobs.entityInstance.CustomEntityInstance;
import net.advancedplugins.mobs.impl.customMobs.entityInstance.ModelEngineEntityInstance;
import net.advancedplugins.mobs.impl.customMobs.events.CustomEntityAttackEvent;
import net.advancedplugins.mobs.impl.customMobs.utils.PlaySound;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffectType;

public class CustomEntityAttackListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void handleCustomDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        CustomEntityInstance customEntityInstance = CustomEntityHandler.getCustomEntityHandler().matchEntity(entityDamageByEntityEvent.getDamager().getUniqueId());
        if (customEntityInstance == null) {
            if (player instanceof Silverfish && player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                entityDamageByEntityEvent.setCancelled(true);
                player.remove();
            }
            return;
        }
        CustomEntityAttackEvent customEntityAttackEvent = new CustomEntityAttackEvent((Entity)player, customEntityInstance);
        if (customEntityInstance.getBase() == null) {
            return;
        }
        if (customEntityInstance instanceof ModelEngineEntityInstance) {
            ((ModelEngineEntityInstance)customEntityInstance).playAttack();
        }
        double d = Math.min(customEntityInstance.getBase().getDamage(), customEntityInstance.getBase().getDamage() * (entityDamageByEntityEvent.getFinalDamage() / entityDamageByEntityEvent.getDamage() + 0.2));
        customEntityAttackEvent.setDamage(customEntityInstance.getBase().getDamage());
        customEntityAttackEvent.setFinalDamage(d);
        customEntityAttackEvent.setCause(entityDamageByEntityEvent.getCause());
        customEntityAttackEvent.setEvent(entityDamageByEntityEvent);
        Bukkit.getPluginManager().callEvent((Event)customEntityAttackEvent);
        if (customEntityAttackEvent.isCancelled()) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        entityDamageByEntityEvent.setDamage(d);
        PlaySound.play(entityDamageByEntityEvent.getEntity().getLocation(), customEntityInstance.getBase().getSound(SoundType.AMBIENT));
    }
}

