/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.mobs.impl.utils.nbt.backend;

import java.util.Iterator;
import java.util.Set;
import net.advancedplugins.mobs.impl.commons.effects.effects.AdvancedEffect;
import net.advancedplugins.mobs.impl.utils.nbt.backend.NBTReflectionUtil;
import net.advancedplugins.mobs.impl.utils.nbt.backend.NBTType;
import net.advancedplugins.mobs.impl.utils.nbt.backend.ReflectionMethod;
import net.advancedplugins.mobs.impl.utils.nbt.utils.MinecraftVersion;

public class NBTCompound {
    private final String compundName;
    private final NBTCompound parent;
    private static final String[] a;

    protected NBTCompound(NBTCompound nBTCompound, String string) {
        this.compundName = string;
        this.parent = nBTCompound;
    }

    public String getName() {
        return this.compundName;
    }

    public Object getCompound() {
        return this.parent.getCompound();
    }

    protected void setCompound(Object object) {
        this.parent.setCompound(object);
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    public void setString(String string, String string2) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_STRING, string, string2);
    }

    public String getString(String string) {
        return (String)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_STRING, string);
    }

    protected String getContent(String string) {
        return NBTReflectionUtil.getContent(this, string);
    }

    public void setInteger(String string, Integer n) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INT, string, n);
    }

    public Integer getInteger(String string) {
        return (Integer)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INT, string);
    }

    public void setDouble(String string, Double d) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_DOUBLE, string, d);
    }

    public Double getDouble(String string) {
        return (Double)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_DOUBLE, string);
    }

    public void setByte(String string, Byte by) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTE, string, by);
    }

    public Byte getByte(String string) {
        return (Byte)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTE, string);
    }

    public void setShort(String string, Short s) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_SHORT, string, s);
    }

    public Short getShort(String string) {
        return (Short)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_SHORT, string);
    }

    public void setLong(String string, Long l) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONG, string, l);
    }

    public Long getLong(String string) {
        return (Long)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONG, string);
    }

    public void setFloat(String string, Float f) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_FLOAT, string, f);
    }

    public Float getFloat(String string) {
        return (Float)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_FLOAT, string);
    }

    public void setByteArray(String string, byte[] byArray) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTEARRAY, string, byArray);
    }

    public byte[] getByteArray(String string) {
        return (byte[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTEARRAY, string);
    }

    public void setIntArray(String string, int[] nArray) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INTARRAY, string, nArray);
    }

    public int[] getIntArray(String string) {
        return (int[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INTARRAY, string);
    }

    public void setBoolean(String string, Boolean bl) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BOOLEAN, string, bl);
    }

    protected void set(String string, Object object) {
        NBTReflectionUtil.set(this, string, object);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BOOLEAN, string);
    }

    public void setObject(String string, Object object) {
        NBTReflectionUtil.setObject(this, string, object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        return NBTReflectionUtil.getObject(this, string, clazz);
    }

    public Boolean hasKey(String string) {
        Boolean bl = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_HAS_KEY, string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void removeKey(String string) {
        NBTReflectionUtil.remove(this, string);
    }

    public Set<String> getKeys() {
        return NBTReflectionUtil.getKeys(this);
    }

    public NBTCompound addCompound(String string) {
        if (this.getType(string) == NBTType.NBTTagCompound) {
            return this.getCompound(string);
        }
        NBTReflectionUtil.addNBTTagCompound(this, string);
        return this.getCompound(string);
    }

    public NBTCompound getCompound(String string) {
        NBTCompound nBTCompound = new NBTCompound(this, string);
        if (NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
            return nBTCompound;
        }
        return null;
    }

    public NBTType getType(String string) {
        if (MinecraftVersion.init() == MinecraftVersion.MC1_7_R4) {
            return null;
        }
        Object object = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_TYPE, string);
        if (object == null) {
            return null;
        }
        return NBTType.valueOf(((Byte)object).byteValue());
    }

    public NBTCompound getOrCreateCompound(String string) {
        return this.addCompound(string);
    }

    public String toString() {
        StringBuilder stringBuilder;
        block2: {
            StringBuilder stringBuilder2 = new StringBuilder();
            AdvancedEffect[] advancedEffectArray = ReflectionMethod.b();
            for (String string : this.getKeys()) {
                stringBuilder = stringBuilder2.append(this.toString(string));
                if (advancedEffectArray != null) {
                    if (advancedEffectArray != null) continue;
                }
                break block2;
            }
            stringBuilder = stringBuilder2;
        }
        return stringBuilder.toString();
    }

    public String toString(String string) {
        StringBuilder stringBuilder;
        block3: {
            stringBuilder = new StringBuilder();
            NBTCompound nBTCompound = this;
            AdvancedEffect[] advancedEffectArray = ReflectionMethod.b();
            while (nBTCompound.getParent() != null) {
                String[] stringArray = a;
                stringBuilder.append(stringArray[1]);
                nBTCompound = nBTCompound.getParent();
                if (advancedEffectArray != null) {
                    if (advancedEffectArray != null) continue;
                }
                break block3;
            }
            if (this.getType(string) == NBTType.NBTTagCompound) {
                return this.getCompound(string).toString();
            }
        }
        return stringBuilder + "-" + string + a[0] + this.getContent(string) + System.lineSeparator();
    }

    public String asNBTString() {
        Object object = NBTReflectionUtil.gettoCompount(this.getCompound(), this);
        if (object == null) {
            return a[2];
        }
        return object.toString();
    }

    public void clearNBT() {
        Iterator<String> iterator = this.getKeys().iterator();
        AdvancedEffect[] advancedEffectArray = ReflectionMethod.b();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.removeKey(string);
            if (advancedEffectArray != null) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[3];
        int n = 0;
        String string = "\u0007\n\u0003\u001d\nW\u0002FW";
        int n2 = "\u0007\n\u0003\u001d\nW\u0002FW".length();
        int n3 = 2;
        int n4 = -1;
        while (true) {
            int n5 = ++n4;
            stringArray[n++] = NBTCompound.a(75, NBTCompound.a(string.substring(n5, n5 + n3)));
            if ((n4 += n3) >= n2) {
                a = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0xF);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 118;
                        break;
                    }
                    case 1: {
                        n5 = 97;
                        break;
                    }
                    case 2: {
                        n5 = 60;
                        break;
                    }
                    case 3: {
                        n5 = 90;
                        break;
                    }
                    case 4: {
                        n5 = 39;
                        break;
                    }
                    case 5: {
                        n5 = 51;
                        break;
                    }
                    default: {
                        n5 = 15;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

