/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.pets.libs.apache.commons.math3.distribution;

import net.advancedplugins.pets.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.MathIllegalNumberException;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.pets.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.pets.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.pets.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.pets.libs.apache.commons.math3.util.CombinatoricsUtils;
import net.advancedplugins.pets.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.pets.libs.apache.commons.math3.util.ResizableDoubleArray;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private static final double[] EXPONENTIAL_SA_QI;
    private final double mean;
    private final double logMean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistribution(double d) {
        this(d, 1.0E-9);
    }

    public ExponentialDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d) {
        this(randomGenerator, d, 1.0E-9);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d);
        }
        this.mean = d;
        this.logMean = FastMath.log(d);
        this.solverAbsoluteAccuracy = d2;
    }

    public double getMean() {
        return this.mean;
    }

    public double density(double d) {
        double d2;
        double d3 = this.logDensity(d);
        try {
            d2 = d3 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d3);
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        return d2;
    }

    public double logDensity(double d) {
        try {
            if (d < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        return -d / this.mean - this.logMean;
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                String[] stringArray = AbstractRealDistribution.b();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (stringArray != null) break block3;
            }
            d2 = 1.0 - FastMath.exp(-d / this.mean);
        }
        return d2;
    }

    public double inverseCumulativeProbability(double d) {
        double d2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    stringArray = AbstractRealDistribution.b();
                    try {
                        try {
                            if (!(d < 0.0) && !(d > 1.0)) break block6;
                        }
                        catch (OutOfRangeException outOfRangeException) {
                            throw ExponentialDistribution.c(outOfRangeException);
                        }
                        throw new OutOfRangeException(d, (Number)0.0, 1.0);
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        throw ExponentialDistribution.c(outOfRangeException);
                    }
                }
                if (d != 1.0) break block7;
                d2 = Double.POSITIVE_INFINITY;
                if (stringArray != null) break block8;
            }
            d2 = -this.mean * FastMath.log(1.0 - d);
        }
        return d2;
    }

    public double sample() {
        double d;
        double d2;
        double d3;
        String[] stringArray;
        double d4;
        block10: {
            d4 = 0.0;
            stringArray = AbstractRealDistribution.b();
            for (d3 = this.random.nextDouble(); d3 < 0.5; d3 *= 2.0) {
                d4 += EXPONENTIAL_SA_QI[0];
                try {
                    if (stringArray != null) {
                        if (stringArray != null) continue;
                        break;
                    }
                    break block10;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ExponentialDistribution.c(notStrictlyPositiveException);
                }
            }
            d3 += d3 - 1.0;
        }
        try {
            if (d3 <= EXPONENTIAL_SA_QI[0]) {
                return this.mean * (d4 + d3);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ExponentialDistribution.c(notStrictlyPositiveException);
        }
        int n = 0;
        double d5 = d2 = this.random.nextDouble();
        block5: while (true) {
            ++n;
            d2 = this.random.nextDouble();
            if (d2 < d5) {
                d = d5 = d2;
            }
            do {
                if (d3 > EXPONENTIAL_SA_QI[n]) continue block5;
                d = this.mean * (d4 + d5 * EXPONENTIAL_SA_QI[0]);
            } while (stringArray == null);
            break;
        }
        return d;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double d = this.getMean();
        return d * d;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    static {
        double d = FastMath.log(2.0);
        double d2 = 0.0;
        int n = 1;
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray(20);
        while (d2 < 1.0) {
            resizableDoubleArray.addElement(d2 += FastMath.pow(d, n) / (double)CombinatoricsUtils.factorial(n));
            ++n;
        }
        EXPONENTIAL_SA_QI = resizableDoubleArray.getElements();
    }

    private static MathIllegalNumberException c(MathIllegalNumberException mathIllegalNumberException) {
        return mathIllegalNumberException;
    }
}

