/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.actions.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.ActionExecutionBuilder;
import net.advancedplugins.as.impl.effects.effects.actions.handlers.DropsCollection;
import net.advancedplugins.as.impl.effects.effects.settings.SettingValues;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.CropUtils;
import net.advancedplugins.as.impl.utils.ItemDurability;
import net.advancedplugins.as.impl.utils.LocalLocation;
import net.advancedplugins.as.impl.utils.ReallyFastBlockHandler;
import net.advancedplugins.as.impl.utils.SchedulerUtils;
import net.advancedplugins.as.impl.utils.abilities.DropsSettings;
import net.advancedplugins.as.impl.utils.abilities.SmeltMaterial;
import net.advancedplugins.as.impl.utils.hooks.HookPlugin;
import net.advancedplugins.as.impl.utils.hooks.HooksHandler;
import net.advancedplugins.as.impl.utils.hooks.PluginHookInstance;
import net.advancedplugins.as.impl.utils.hooks.plugins.AureliumSkillsHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.ItemsAdderHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.McMMOHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.OraxenHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.ProtectionStonesHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.SlimeFunHook;
import net.advancedplugins.as.impl.utils.hooks.plugins.SuperiorSkyblock2Hook;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Slab;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DropsHandler {
    private final DropsSettings settings = new DropsSettings();
    private final HashMap<Location, DropsCollection> dropsMap = new HashMap();
    private ActionExecutionBuilder builder;
    private HashSet<Block> alreadyProcessed = new HashSet();
    int xpToDrop = 0;

    public void addDrops(Block block, ItemStack ... itemStackArray) {
        this.addDrops(block, Arrays.asList(itemStackArray));
    }

    public void addDrops(Block block, Collection<ItemStack> collection) {
        DropsCollection dropsCollection = this.dropsMap.computeIfAbsent(block.getLocation(), location -> new DropsCollection());
        dropsCollection.getItems().addAll(collection);
        this.dropsMap.put(block.getLocation(), dropsCollection);
    }

    public void addDrops(Location location2, ItemStack ... itemStackArray) {
        location2 = location2.getBlock().getLocation();
        DropsCollection dropsCollection = this.dropsMap.computeIfAbsent(location2, location -> new DropsCollection());
        dropsCollection.getItems().addAll(Arrays.asList(itemStackArray));
        this.dropsMap.put(location2, dropsCollection);
    }

    private void addParsedDrop(Block block, ItemStack itemStack) {
        DropsCollection dropsCollection = this.dropsMap.get(block.getLocation());
        dropsCollection.getParsedItems().add(itemStack);
    }

    public void clearDrops(Block block) {
        this.dropsMap.remove(block.getLocation());
    }

    public DropsCollection getDrops(Block block) {
        return this.dropsMap.getOrDefault(block.getLocation(), null);
    }

    public Collection<DropsCollection> getAllDrops() {
        return this.dropsMap.values();
    }

    public void handle() {
        ItemStack[] itemStackArray;
        Object object;
        if (!this.settings.isBreakBlocks() && !(this.builder.getEvent() instanceof PlayerFishEvent)) {
            return;
        }
        if (this.builder.getEvent() instanceof PlayerFishEvent && this.settings.getDropsMultiplier() == 0) {
            return;
        }
        LivingEntity livingEntity = this.builder.getMain();
        if (this.settings.getTool() == null) {
            this.settings.setTool(this.builder.getItem());
        }
        if (this.settings.getTool() == null) {
            return;
        }
        boolean bl = this.builder.getEvent() instanceof BlockBreakEvent;
        if (bl) {
            object = ((BlockBreakEvent)this.builder.getEvent()).getBlock();
            if (!this.settings.isBreakBlocks() && object.getState() instanceof Container && !object.getType().name().contains("SHULKER_BOX")) {
                itemStackArray = (Container)object.getState();
                itemStackArray.getInventory().forEach(arg_0 -> DropsHandler.lambda$handle$2((Block)object, arg_0));
            }
            if (livingEntity instanceof Player && HooksHandler.isEnabled(HookPlugin.MCMMO) && (itemStackArray = (McMMOHook)HooksHandler.getHook(HookPlugin.MCMMO)).hasHerbalismSkill((Player)livingEntity)) {
                int n;
                itemStackArray.processHerbalismBlockBreakEvent((Player)livingEntity, (BlockBreakEvent)this.builder.getEvent());
                if (this.settings.isAddToInventory() && itemStackArray.blockHasHerbalismBonusDrops((Block)object) && (n = itemStackArray.getHerbalismBonusDropMultiplier((Block)object)) >= 1) {
                    int n2 = n * CropUtils.getDropAmount((Block)object, object.getType(), this.settings.getTool());
                    this.addDrops((Block)object, new ItemStack(object.getType(), n2));
                }
            }
        }
        this.settings.setSilkTouch(this.settings.getTool().containsEnchantment(Enchantment.SILK_TOUCH));
        object = new ItemDurability(livingEntity, this.settings.getTool());
        ASManager.debug("[DropsHandler] " + this.dropsMap.size() + " blocks to be processed");
        for (Map.Entry entry : this.dropsMap.entrySet()) {
            ItemStack itemStack;
            Object object2;
            Object object3;
            boolean bl2;
            Object object4;
            Object object5;
            PluginHookInstance pluginHookInstance;
            Location location = (Location)entry.getKey();
            if (bl) {
                boolean bl3;
                ASManager.debug("[DropsHandler] " + new LocalLocation(location.getBlock().getLocation()).getEncode() + " has already been processed: " + this.alreadyProcessed.contains(location.getBlock()));
                if (this.alreadyProcessed.contains(location.getBlock())) continue;
                this.alreadyProcessed.add(location.getBlock());
                if (HooksHandler.isEnabled(HookPlugin.AURELIUMSKILLS) && livingEntity instanceof Player) {
                    ((AureliumSkillsHook)HooksHandler.getHook(HookPlugin.AURELIUMSKILLS)).addBrokenBlockToMap(location.getBlock(), (Player)livingEntity, this.settings);
                    if (this.builder.getEvent() instanceof BlockBreakEvent) {
                        bl3 = ((AureliumSkillsHook)HooksHandler.getHook(HookPlugin.AURELIUMSKILLS)).isTerraformEvent((BlockBreakEvent)this.builder.getEvent());
                        this.settings.setDurabilityDamage(!bl3);
                        this.settings.setTerraformEvent(bl3);
                    }
                }
                if (HooksHandler.isEnabled(HookPlugin.MCMMO) && livingEntity instanceof Player) {
                    bl3 = ((McMMOHook)HooksHandler.getHook(HookPlugin.MCMMO)).isTreeFellerEvent(this.builder.getEvent());
                    this.settings.setDurabilityDamage(!bl3);
                    this.settings.setTreeFellerEvent(bl3);
                }
            }
            if (HooksHandler.isEnabled(HookPlugin.SUPERIORSKYBLOCK2) && ((SuperiorSkyblock2Hook)(pluginHookInstance = (SuperiorSkyblock2Hook)HooksHandler.getHook(HookPlugin.SUPERIORSKYBLOCK2))).isStackedBlock(location.getBlock())) continue;
            if (HooksHandler.isEnabled(HookPlugin.ITEMSADDER) && ((ItemsAdderHook)(pluginHookInstance = (ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER))).isCustomBlock((Block)(object5 = ((Location)entry.getKey()).getBlock()))) {
                if (object5.hasMetadata("ae_custom_block_break")) {
                    object5.removeMetadata("ae_custom_block_break", (Plugin)EffectsHandler.getInstance());
                    List<ItemStack> list = ((ItemsAdderHook)pluginHookInstance).getLootForCustomBlock(this.settings.getTool(), (Block)object5);
                    object4 = new DropsCollection();
                    ((DropsCollection)object4).getParsedItems().addAll(list);
                    entry.setValue(object4);
                    SchedulerUtils.runTaskLater(() -> DropsHandler.lambda$handle$3((ItemsAdderHook)pluginHookInstance, (Block)object5));
                    continue;
                }
                if (this.settings.isSmelt()) continue;
            }
            if (HooksHandler.isEnabled(HookPlugin.ORAXEN) && ((OraxenHook)(pluginHookInstance = (OraxenHook)HooksHandler.getHook(HookPlugin.ORAXEN))).isCustomBlock((Block)(object5 = ((Location)entry.getKey()).getBlock())) && object5.hasMetadata("ae_custom_block_break")) {
                object5.removeMetadata("ae_custom_block_break", (Plugin)EffectsHandler.getInstance());
                List<ItemStack> list = ((OraxenHook)pluginHookInstance).getLootForCustomBlock((Block)object5);
                object4 = new DropsCollection();
                ((DropsCollection)object4).getParsedItems().addAll(list);
                entry.setValue(object4);
                SchedulerUtils.runTaskLater(() -> DropsHandler.lambda$handle$4((OraxenHook)pluginHookInstance, (Block)object5));
                continue;
            }
            if (HooksHandler.isEnabled(HookPlugin.PROTECTIONSTONES) && ((ProtectionStonesHook)(pluginHookInstance = (ProtectionStonesHook)HooksHandler.getHook(HookPlugin.PROTECTIONSTONES))).isProtectionStone(((Location)entry.getKey()).getBlock())) {
                entry.setValue(new DropsCollection());
                continue;
            }
            pluginHookInstance = location.getBlock().getType();
            object5 = pluginHookInstance.name();
            if (((String)object5).contains("SPAWNER")) continue;
            boolean bl3 = bl2 = this.builder.getBlock() == null || location.equals((Object)this.builder.getBlock().getLocation());
            if (livingEntity instanceof Player && !bl2 && this.settings.isBreakBlocks() && !EffectsHandler.getProtection().canBreak(location, (Player)livingEntity) || this.settings.getTool().getType() != Material.SHEARS && ((String)object5).equals("GRASS") && MinecraftVersion.getVersionNumber() > 1122 || ((String)object5).equals("TALL_GRASS") || ((String)object5).equals("LONG_GRASS") || ((String)object5).equals("DEAD_BUSH")) continue;
            if (((String)object5).endsWith("_BED")) {
                if (((DropsCollection)entry.getValue()).getItems().isEmpty()) {
                    entry.setValue((DropsCollection)entry.getValue()).getItems().add(new ItemStack(Material.matchMaterial((String)object5)));
                }
                if ((object4 = ASManager.getOtherHalfOfBed(location.getBlock())) == null) continue;
                object3 = location.getBlock();
                object2 = (Bed)object3.getBlockData();
                if (!object2.getPart().equals((Object)Bed.Part.FOOT)) {
                    object2.setPart(Bed.Part.FOOT);
                    object3.setBlockData((BlockData)object2);
                    object3.getState().update(true, true);
                }
                object4.setType(Material.AIR);
                location.getBlock().setType(Material.AIR);
            }
            if (((String)object5).equalsIgnoreCase("CHORUS_FLOWER")) {
                entry.setValue((DropsCollection)entry.getValue()).getItems().add(ASManager.matchMaterial((String)object5, 1, 0));
            }
            if (((String)object5).equalsIgnoreCase("SNOW") || ((String)object5).equalsIgnoreCase("GRASS")) {
                entry.setValue((DropsCollection)entry.getValue()).getItems().addAll(location.getBlock().getDrops(this.settings.getTool(), (Entity)livingEntity));
            }
            if (HooksHandler.isEnabled(HookPlugin.SLIMEFUN) && ((SlimeFunHook)(object4 = (SlimeFunHook)HooksHandler.getHook(HookPlugin.SLIMEFUN))).isSlimefunItem(location)) continue;
            object4 = ((DropsCollection)entry.getValue()).getItems().iterator();
            while (object4.hasNext()) {
                Slab slab;
                Object object6;
                object3 = object4.next();
                if (!ASManager.isValid((Material)pluginHookInstance) || (((String)object5).contains("GLASS") || ((String)object5).contains("ICE")) && !this.settings.isSilkTouch()) continue;
                object2 = null;
                object2 = this.settings.isSilkTouch() ? pluginHookInstance : (this.settings.isSmelt() ? ((itemStack = SmeltMaterial.material((Material)(object3 == null ? pluginHookInstance : object3.getType()))) != null ? itemStack.getType() : (object3 == null ? pluginHookInstance : object3.getType())) : (object3 == null ? pluginHookInstance : object3.getType()));
                object2 = ASManager.getNonWallMaterial((Material)object2);
                if (!ASManager.isValid((Material)(object2 = ASManager.getFixedMaterial((Material)object2)))) continue;
                if (ASManager.isTall((Material)object2)) {
                    this.handleTallBlock(location.getBlock());
                }
                if (object2.name().equalsIgnoreCase("REDSTONE_WIRE")) {
                    object2 = ASManager.matchMaterial("REDSTONE", 1, 0).getType();
                }
                if (bl && this.settings.isSmelt() && ((BlockBreakEvent)this.builder.getEvent()).getBlock().getType() == Material.valueOf((String)"NETHER_GOLD_ORE")) {
                    object2 = Material.GOLD_INGOT;
                }
                int n = this.settings.getDropsMultiplier() < 2 ? ASManager.getDropAmount(location.getBlock(), (Material)object2, this.builder.getItem()) : this.settings.getDropsMultiplier() * ASManager.getDropAmount(location.getBlock(), (Material)object2, this.builder.getItem());
                if (object3 == null) {
                    object3 = new ItemStack((Material)object2);
                } else {
                    object3.setType((Material)object2);
                }
                if (bl && (object6 = ((BlockBreakEvent)this.builder.getEvent()).getBlock()).getBlockData() instanceof Slab && (slab = (Slab)object6.getBlockData()).getType().equals((Object)Slab.Type.DOUBLE)) {
                    n *= 2;
                }
                if (pluginHookInstance == Material.ENDER_CHEST && !this.settings.isSilkTouch()) {
                    n = 8;
                } else if (pluginHookInstance == Material.ENDER_CHEST) {
                    n = 1;
                }
                if (n < 1) continue;
                object3.setAmount(n);
                if (pluginHookInstance == Material.SUGAR_CANE || pluginHookInstance == Material.CACTUS && this.settings.isAddToInventory()) {
                    object6 = this.findAllVerticalBlocks(location.getBlock(), (Material)pluginHookInstance, new ArrayList<Block>());
                    object3.setAmount(object3.getAmount() + object6.size());
                }
                if (this.settings.isAddToInventory() && this.settings.isSilkTouch() && CropUtils.isCrop((Material)pluginHookInstance)) {
                    if (CropUtils.isWheat((Material)pluginHookInstance)) {
                        this.addParsedDrop(location.getBlock(), new ItemStack(Material.matchMaterial((String)"WHEAT_SEEDS"), CropUtils.getSeedAmount()));
                    } else if (CropUtils.isBeetroot((Material)pluginHookInstance)) {
                        this.addParsedDrop(location.getBlock(), new ItemStack(Material.BEETROOT_SEEDS, CropUtils.getSeedAmount()));
                    }
                }
                this.addParsedDrop(location.getBlock(), (ItemStack)object3);
            }
            if (this.settings.isAddToInventory() && livingEntity instanceof Player) {
                if (HooksHandler.isEnabled(HookPlugin.ITEMSADDER)) {
                    object4 = (ItemsAdderHook)HooksHandler.getHook(HookPlugin.ITEMSADDER);
                    object3 = new ArrayList();
                    this.dropsMap.keySet().stream().map(Location::getBlock).filter(block -> block.getType() != Material.AIR).filter(((ItemsAdderHook)object4)::isCustomBlock).forEach(arg_0 -> DropsHandler.lambda$handle$6((List)object3, arg_0));
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        itemStack = (Location)object2.next();
                        this.dropsMap.remove(itemStack);
                    }
                }
                if (HooksHandler.isEnabled(HookPlugin.ORAXEN)) {
                    object4 = (OraxenHook)HooksHandler.getHook(HookPlugin.ORAXEN);
                    object3 = new ArrayList();
                    this.dropsMap.keySet().stream().map(Location::getBlock).filter(block -> block.getType() != Material.AIR).filter(((OraxenHook)object4)::isCustomBlock).forEach(arg_0 -> DropsHandler.lambda$handle$8((List)object3, arg_0));
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        itemStack = (Location)object2.next();
                        this.dropsMap.remove(itemStack);
                    }
                }
            }
            if (!this.settings.isBreakBlocks()) continue;
            if (((ItemDurability)object).isBroken()) {
                this.clearDrops(location.getBlock());
                break;
            }
            if (livingEntity instanceof Player && !((Player)livingEntity).getGameMode().equals((Object)GameMode.CREATIVE) && !CropUtils.isCrop(location.getBlock().getType()) && this.settings.isDurabilityDamage() && ASManager.doChancesPass((int)(100.0 / (double)((ItemDurability)object).getUnbreakingLevel() + 1.0))) {
                ((ItemDurability)object).damageItem((short)1);
            }
            if (this.settings.isDropExp() && !this.getSettings().isSilkTouch()) {
                this.breakAndDropExp((Player)livingEntity, true, location.getBlock(), bl ? (BlockBreakEvent)this.builder.getEvent() : null);
                continue;
            }
            this.breakBlock((Player)livingEntity, true, location.getBlock());
        }
        if (this.settings.isDropExp() && !this.getSettings().isSilkTouch() && bl) {
            this.dropBlockBreakEventExperience(this.xpToDrop, ((BlockBreakEvent)this.builder.getEvent()).getBlock());
        }
        if (this.settings.isAddToInventory() && livingEntity instanceof Player) {
            itemStackArray = (ItemStack[])this.dropsMap.values().stream().flatMap(dropsCollection -> dropsCollection.getParsedItems().stream()).toArray(ItemStack[]::new);
            ASManager.giveItem((Player)livingEntity, itemStackArray);
            return;
        }
        for (Map.Entry<Location, DropsCollection> entry : this.dropsMap.entrySet()) {
            ASManager.dropItem(entry.getKey().add(0.5, 0.0, 0.5), entry.getValue().getParsedItems().toArray(new ItemStack[0]));
        }
        this.dropsMap.clone();
    }

    private void breakAndDropExp(Player player, boolean bl, Block block, BlockBreakEvent blockBreakEvent) {
        this.breakBlock(player, bl, block);
        if (blockBreakEvent == null) {
            return;
        }
        this.xpToDrop += blockBreakEvent.getExpToDrop();
    }

    private void dropBlockBreakEventExperience(int n, Block block) {
        if (n == 0) {
            return;
        }
        Location location = block.getLocation().clone();
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY() + 0.5);
        location.setZ((double)location.getBlockZ() + 0.5);
        ExperienceOrb experienceOrb = (ExperienceOrb)block.getWorld().spawnEntity(location, EntityType.EXPERIENCE_ORB);
        experienceOrb.setExperience(n);
    }

    public BlockBreakEvent breakBlock(Player player, boolean bl, Block ... blockArray) {
        BlockBreakEvent blockBreakEvent = null;
        if (blockArray.length == 0) {
            return null;
        }
        if (this.builder.getEvent() instanceof BlockBreakEvent) {
            if (HooksHandler.isEnabled(HookPlugin.AURELIUMSKILLS)) {
                boolean bl2 = bl = !this.settings.isTerraformEvent();
            }
            if (HooksHandler.isEnabled(HookPlugin.MCMMO)) {
                boolean bl3 = bl = !this.settings.isTreeFellerEvent();
                if (this.settings.isTreeFellerEvent()) {
                    this.builder.getBlock().setMetadata("ae-mcmmo-treefeller-tpdrops", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)true));
                    Arrays.stream(blockArray).forEach(block -> McMMOHook.treeFellerTelepathyBlocks.put((Block)block, System.currentTimeMillis()));
                }
            }
        }
        ArrayList<Block> arrayList = new ArrayList<Block>(Arrays.asList(blockArray));
        if (bl) {
            for (Block block2 : blockArray) {
                if (this.builder.getBlock() != null && this.builder.getBlock().equals(block2) && this.getAllBlocks().size() > 1) continue;
                block2.setMetadata("blockbreakevent-ignore", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)true));
                blockBreakEvent = new BlockBreakEvent(block2, player);
                Bukkit.getPluginManager().callEvent((Event)blockBreakEvent);
                block2.removeMetadata("blockbreakevent-ignore", (Plugin)EffectsHandler.getInstance());
                if (!blockBreakEvent.isCancelled()) continue;
                this.dropsMap.remove(block2.getLocation());
                arrayList.remove(block2);
            }
        }
        if (!arrayList.isEmpty() && !this.settings.isTreeFellerEvent()) {
            ReallyFastBlockHandler reallyFastBlockHandler = ReallyFastBlockHandler.getForWorld(((Block)arrayList.get(0)).getWorld());
            reallyFastBlockHandler.setType(Material.AIR, arrayList.toArray(new Block[0]));
            if (SettingValues.isAddBrokenBlocksToMCStats()) {
                arrayList.forEach(block -> player.incrementStatistic(Statistic.MINE_BLOCK, block.getType()));
            }
        }
        return blockBreakEvent;
    }

    private List<Block> findAllVerticalBlocks(Block block, Material material, List<Block> list) {
        Block block2 = block.getLocation().add(0.0, 1.0, 0.0).getBlock();
        if (block2.getType() != material) {
            return list;
        }
        list.add(block2);
        block2.setType(Material.AIR);
        return this.findAllVerticalBlocks(block2, material, list);
    }

    private byte handleTallBlock(Block block) {
        byte by = block.getData();
        if (ASManager.isTall(block.getType())) {
            Block block2 = block.getRelative(BlockFace.DOWN);
            if (block.getType() == block2.getType()) {
                by = block2.getData();
                block2.setType(Material.AIR);
            }
        }
        return by;
    }

    public List<Block> getAllBlocks() {
        return this.dropsMap.keySet().stream().map(Location::getBlock).collect(Collectors.toList());
    }

    public void removeBlock(Block block) {
        this.dropsMap.remove(block.getLocation());
    }

    public DropsSettings getSettings() {
        return this.settings;
    }

    public HashMap<Location, DropsCollection> getDropsMap() {
        return this.dropsMap;
    }

    public void setBuilder(ActionExecutionBuilder actionExecutionBuilder) {
        this.builder = actionExecutionBuilder;
    }

    private static /* synthetic */ void lambda$handle$8(List list, Block block) {
        block.setMetadata("telepathy-broken-oraxen", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)true));
        list.add(block.getLocation());
    }

    private static /* synthetic */ void lambda$handle$6(List list, Block block) {
        block.setMetadata("telepathy-broken-itemsadder", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)true));
        list.add(block.getLocation());
    }

    private static /* synthetic */ void lambda$handle$4(OraxenHook oraxenHook, Block block) {
        oraxenHook.removeBlock(block);
    }

    private static /* synthetic */ void lambda$handle$3(ItemsAdderHook itemsAdderHook, Block block) {
        itemsAdderHook.removeBlock(block);
    }

    private static /* synthetic */ void lambda$handle$2(Block block, ItemStack itemStack) {
        if (itemStack != null && itemStack.getType() != Material.AIR) {
            block.getWorld().dropItem(block.getLocation(), itemStack);
        }
    }
}

