/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.conditions;

import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.advancedplugins.as.impl.effects.effects.actions.ActionExecution;
import net.advancedplugins.as.impl.effects.effects.conditions.ConResult;
import net.advancedplugins.as.impl.effects.effects.conditions.ConditionType;
import net.advancedplugins.as.impl.effects.effects.variables.Variables;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.ColorUtils;
import net.advancedplugins.as.impl.utils.MathUtils;
import net.advancedplugins.as.impl.utils.text.Text;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Fractor {
    private static ConditionType getOriginalCondition(String string) {
        if (string.contains("%stop%")) {
            return ConditionType.STOP;
        }
        if (string.contains("%force%")) {
            return ConditionType.FORCE;
        }
        if (string.contains("%continue%")) {
            return ConditionType.CONTINUE;
        }
        if (string.contains("%allow%")) {
            return ConditionType.ALLOW;
        }
        if (string.contains("-")) {
            if (string.contains("%chance%")) {
                return ConditionType.REMOVE;
            }
        } else if (string.contains("+") && string.contains("%chance%")) {
            string = string.replaceAll(" ", "");
            string = string.replace("%chance%", "");
            if (!StringUtils.isNumeric((String)(string = string.replace("+", "")))) {
                return ConditionType.NONE;
            }
            return ConditionType.ADD;
        }
        return ConditionType.NONE;
    }

    public static ConResult getResult(String string, LivingEntity livingEntity, LivingEntity livingEntity2, ActionExecution actionExecution) {
        if (string.startsWith("[")) {
            string = string.substring(1);
        }
        if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            string = string.toLowerCase(Locale.ROOT);
            Fractor.debug("------------------------------------");
            if (livingEntity != null) {
                Fractor.debug("Attacker: " + livingEntity.getType());
            }
            Fractor.debug("Victim: " + (livingEntity2 == null ? "N/A" : livingEntity2.getType()));
            Fractor.debug("Condition in: \"" + string + "\"");
            ConResult conResult = Fractor.parseCondition(string, livingEntity, livingEntity2, actionExecution);
            if (conResult != null) {
                Fractor.debug("Condition result: " + (Object)((Object)conResult.getCondition()));
            }
            Fractor.debug("------------------------------------");
            return conResult;
        }
        catch (Exception exception) {
            ASManager.reportIssue(exception, "Invalid condition: " + string);
            return new ConResult(ConditionType.STOP, "", ConditionType.STOP);
        }
    }

    private static ConResult parseCondition(String string, LivingEntity livingEntity, LivingEntity livingEntity2, ActionExecution actionExecution) {
        if (livingEntity == null && livingEntity2 == null) {
            Bukkit.getLogger().log(Level.SEVERE, "Invalid entity for condition: " + string);
            return null;
        }
        if (livingEntity2 == null) {
            livingEntity2 = livingEntity;
        } else if (livingEntity == null) {
            livingEntity = livingEntity2;
        }
        string = Variables.replaceVariables(string, livingEntity, livingEntity2, actionExecution);
        Fractor.debug("Condition out: \"" + string + "\"");
        String[] stringArray = string.split(" : ");
        String string2 = stringArray[0];
        if (stringArray.length < 2) {
            Bukkit.getLogger().warning("Invalid condition: " + string + ", enchant was stopped from parsing");
            if (livingEntity instanceof Player && livingEntity.isOp()) {
                livingEntity.sendMessage(Text.modify("&cInvalid condition: " + string + ", enchant was stopped from parsing"));
            }
            return new ConResult(ConditionType.STOP, 0, Fractor.getOriginalCondition(string));
        }
        stringArray[0] = stringArray[0].replace(" ", "");
        stringArray[1] = stringArray[1].replace(" ", "");
        String string3 = stringArray[1];
        if (string2.contains("&&")) {
            String[] stringArray2;
            for (String string4 : stringArray2 = string2.split("&&")) {
                boolean bl = Fractor.read(string4, livingEntity);
                if (bl) continue;
                return new ConResult(ConditionType.NONE, null, Fractor.getOriginalCondition(string));
            }
            String bl = stringArray[1];
            return Fractor.getEnding(bl, livingEntity);
        }
        if (string2.contains("||")) {
            boolean bl;
            String[] stringArray3 = string2.split("\\|\\|");
            boolean bl2 = false;
            for (String string5 : stringArray3) {
                boolean bl3 = Fractor.read(string5, livingEntity);
                if (!bl3) continue;
                bl = true;
                break;
            }
            String string6 = stringArray[1];
            if (bl) {
                return Fractor.getEnding(string6, livingEntity);
            }
            return new ConResult(ConditionType.STOP, null, Fractor.getOriginalCondition(string));
        }
        boolean bl = Fractor.read(string2, livingEntity);
        if (bl) {
            return Fractor.getEnding(string3, livingEntity);
        }
        return new ConResult(ConditionType.NONE, null, Fractor.getOriginalCondition(string));
    }

    private static ConResult getEnding(String string, LivingEntity livingEntity) {
        ConResult conResult = null;
        if (string.contains("%stop%")) {
            conResult = new ConResult(ConditionType.STOP, 0, Fractor.getOriginalCondition(string));
        } else if (string.contains("%force%")) {
            conResult = new ConResult(ConditionType.FORCE, 0, Fractor.getOriginalCondition(string));
        } else if (string.contains("%continue%")) {
            conResult = new ConResult(ConditionType.CONTINUE, 0, Fractor.getOriginalCondition(string));
        } else if (string.contains("%allow%")) {
            conResult = new ConResult(ConditionType.ALLOW, 0, Fractor.getOriginalCondition(string));
        } else if (string.contains("-")) {
            if (string.contains("%chance%")) {
                string = string.replaceAll(" ", "");
                string = string.replace("%chance%", "");
                if (!StringUtils.isNumeric((String)(string = string.replace("-", "")))) {
                    if (livingEntity instanceof Player && livingEntity.isOp()) {
                        livingEntity.sendMessage(ColorUtils.format("&4Condition (" + string + ") contains letters, but must be numeric only. Check if this condition fits this enchant type if you see no visible error"));
                    }
                    return new ConResult(ConditionType.NONE, null, Fractor.getOriginalCondition(string));
                }
                conResult = new ConResult(ConditionType.REMOVE, ASManager.parseInt(string.split("-")[1].replace("+", "")), Fractor.getOriginalCondition(string));
            }
        } else if (string.contains("+") && string.contains("%chance%")) {
            string = string.replaceAll(" ", "");
            string = string.replace("%chance%", "");
            if (!StringUtils.isNumeric((String)(string = string.replace("+", "")))) {
                if (livingEntity instanceof Player && livingEntity.isOp()) {
                    livingEntity.sendMessage(ColorUtils.format("&4Condition (" + string + ") contains letters, but must be numeric only."));
                }
                return new ConResult(ConditionType.NONE, null, Fractor.getOriginalCondition(string));
            }
            conResult = new ConResult(ConditionType.ADD, ASManager.parseInt(string), Fractor.getOriginalCondition(string));
        }
        return conResult;
    }

    private static boolean read(String string, LivingEntity livingEntity) {
        boolean bl = false;
        if (string.contains(">=")) {
            String[] stringArray = string.replaceAll(" ", "").split(">=");
            if (!MathUtils.isDouble(stringArray[0]) || !MathUtils.isDouble(stringArray[1])) {
                if (livingEntity instanceof Player && livingEntity.isOp()) {
                    livingEntity.sendMessage(ColorUtils.format("&4Condition (" + string + ") contains letters, but must be numeric only."));
                }
                return false;
            }
            bl = Double.parseDouble(stringArray[0]) >= Double.parseDouble(stringArray[1]);
        } else if (string.contains("<=")) {
            String[] stringArray = string.replaceAll(" ", "").split("<=");
            if (!MathUtils.isDouble(stringArray[0]) || !MathUtils.isDouble(stringArray[1])) {
                if (livingEntity instanceof Player && livingEntity.isOp()) {
                    livingEntity.sendMessage(ColorUtils.format("&4Condition (" + string + ") contains letters, but must be numeric only."));
                }
                return false;
            }
            bl = Double.parseDouble(stringArray[0]) <= Double.parseDouble(stringArray[1]);
        } else if (string.contains(">")) {
            String[] stringArray = string.replaceAll(" ", "").split(">");
            if (!MathUtils.isDouble(stringArray[0]) || !MathUtils.isDouble(stringArray[1])) {
                if (livingEntity instanceof Player && livingEntity.isOp()) {
                    livingEntity.sendMessage(ColorUtils.format("&4Condition (" + string + ") contains letters, but must be numeric only."));
                }
                return false;
            }
            bl = Double.parseDouble(stringArray[0]) > Double.parseDouble(stringArray[1]);
        } else if (string.contains("<")) {
            String[] stringArray = string.replaceAll(" ", "").split("<");
            if (!MathUtils.isDouble(stringArray[0]) || !MathUtils.isDouble(stringArray[1])) {
                if (livingEntity instanceof Player && livingEntity.isOp()) {
                    ColorUtils.format("&4Condition (" + string + ") contains letters, but must be numeric only.");
                }
            } else {
                bl = Double.parseDouble(stringArray[0]) < Double.parseDouble(stringArray[1]);
            }
        } else if (string.contains("!=")) {
            String[] stringArray = string.replaceAll(" ", "").split("!=");
            bl = !MathUtils.isDouble(stringArray[0]) || !MathUtils.isDouble(stringArray[1]) ? !stringArray[0].equalsIgnoreCase(stringArray[1]) : Double.parseDouble(stringArray[0]) != Double.parseDouble(stringArray[1]);
        } else if (string.contains("=")) {
            String[] stringArray = string.replaceAll(" ", "").split("=");
            bl = !MathUtils.isDouble(stringArray[0]) || !MathUtils.isDouble(stringArray[1]) ? stringArray[0].equalsIgnoreCase(stringArray[1]) : Double.parseDouble(stringArray[0]) == Double.parseDouble(stringArray[1]);
        } else if (string.contains("matchesregex")) {
            String[] stringArray = string.split("matchesregex");
            Pattern pattern = Pattern.compile(stringArray[1], 2);
            Matcher matcher = pattern.matcher(stringArray[0]);
            bl = matcher.find();
        } else if (string.contains("contains")) {
            String[] stringArray = string.split("contains");
            bl = stringArray[0].toLowerCase(Locale.ROOT).contains(stringArray[1].toLowerCase(Locale.ROOT));
        }
        return bl;
    }

    private static void debug(String string) {
        ASManager.debug(string);
    }
}

