/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.effects.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.advancedplugins.as.impl.effects.effects.actions.execution.ExecutionTask;
import net.advancedplugins.as.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.PotionEffectMatcher;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ApplyPotionEffect
extends AdvancedEffect {
    private static int permanentLength = -1;
    private static final Map<UUID, List<PotionEffectType>> activatedPermanentPotions = new HashMap<UUID, List<PotionEffectType>>();

    public ApplyPotionEffect(JavaPlugin javaPlugin) {
        super(javaPlugin, "POTION", "Add potion effect", "%e:<POTION>:<LEVEL>:[TICKS]");
        if (!MinecraftVersion.isNewerThan(MinecraftVersion.MC1_19_R3)) {
            permanentLength = Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean executeEffect(ExecutionTask executionTask, LivingEntity livingEntity, String[] stringArray) {
        PotionEffectType potionEffectType = PotionEffectMatcher.matchPotion(stringArray[0]);
        int n = ASManager.parseInt(stringArray[1]);
        if (executionTask.getBuilder().isPermanent()) {
            if (executionTask.getBuilder().isRemoved()) {
                livingEntity.removePotionEffect(potionEffectType);
                List list = activatedPermanentPotions.getOrDefault(livingEntity.getUniqueId(), new ArrayList());
                list.remove(potionEffectType);
                if (list.isEmpty()) {
                    activatedPermanentPotions.remove(livingEntity.getUniqueId());
                } else {
                    activatedPermanentPotions.put(livingEntity.getUniqueId(), list);
                }
                return true;
            }
            if (!livingEntity.hasPotionEffect(potionEffectType) || !ASManager.hasPotionEffect(livingEntity, potionEffectType, n)) {
                PotionEffect potionEffect = new PotionEffect(potionEffectType, permanentLength, n, true, false);
                livingEntity.addPotionEffect(potionEffect);
                List list = activatedPermanentPotions.getOrDefault(livingEntity.getUniqueId(), new ArrayList());
                list.add(potionEffect.getType());
                activatedPermanentPotions.put(livingEntity.getUniqueId(), list);
            }
            return true;
        }
        if (stringArray.length > 2) {
            int n2;
            int n3 = ASManager.parseInt(stringArray[2]);
            if ((livingEntity.hasPotionEffect(potionEffectType) || ASManager.hasPotionEffect(livingEntity, potionEffectType, n)) && (n2 = Objects.requireNonNull(livingEntity.getPotionEffect(potionEffectType)).getDuration()) > n3) {
                return true;
            }
            if (stringArray.length > 3 && !ASManager.parseBoolean(stringArray[3], true)) {
                livingEntity.addPotionEffect(new PotionEffect(potionEffectType, n3, n).withIcon(false).withParticles(false));
                return true;
            }
            livingEntity.addPotionEffect(new PotionEffect(potionEffectType, n3, n));
            return true;
        }
        return true;
    }

    public static int getPermanentLength() {
        return permanentLength;
    }

    public static Map<UUID, List<PotionEffectType>> getActivatedPermanentPotions() {
        return activatedPermanentPotions;
    }
}

