/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal;

import net.advancedplugins.as.impl.effects.effects.actions.AdvancedTrigger;
import net.advancedplugins.as.impl.effects.effects.actions.utils.GetAllRollItems;
import net.advancedplugins.as.impl.effects.effects.actions.utils.StackItem;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class PassiveDeathTrigger
extends AdvancedTrigger {
    public PassiveDeathTrigger() {
        super("PASSIVE_DEATH");
        this.setComboEnabled(true);
        this.setDescription("Activates when Player dies due to non-combat related reason");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPassiveDeath(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getCause().name().contains("ATTACK") || entityDamageEvent.getCause().name().contains("EXPLOSION") || entityDamageEvent.getCause().name().contains("SONIC_BOOM")) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (entityDamageEvent.getEntity().hasMetadata("ae_ignore")) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityDamageEvent.getEntity();
        if (livingEntity.getHealth() - entityDamageEvent.getFinalDamage() > 0.0) {
            return;
        }
        if (MinecraftVersion.getVersionNumber() >= 1130) {
            ItemStack itemStack = livingEntity.getEquipment().getItemInMainHand();
            ItemStack object = livingEntity.getEquipment().getItemInOffHand();
            if (itemStack.getType().name().equalsIgnoreCase("TOTEM_OF_UNDYING") || object.getType().name().equalsIgnoreCase("TOTEM_OF_UNDYING")) {
                return;
            }
        }
        for (StackItem stackItem : GetAllRollItems.get(livingEntity)) {
            this.executionBuilder().setVictim(livingEntity).setAttackerMain(false).setEvent((Event)entityDamageEvent).setStackItem(stackItem).setItemType(stackItem.getRollItemType()).setItem(stackItem.getItem()).buildAndExecute();
        }
    }
}

