/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.mechanics.triggers.internal;

import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.AdvancedTrigger;
import net.advancedplugins.as.impl.effects.effects.actions.utils.RollItemType;
import net.advancedplugins.as.impl.effects.effects.effects.utils.TridentShootHandler;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class ShootTrigger
extends AdvancedTrigger {
    public ShootTrigger() {
        super("SHOOT");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHitEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ItemStack itemStack;
        RollItemType rollItemType;
        if (!(entityDamageByEntityEvent.getDamager() instanceof Projectile)) {
            return;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity().hasMetadata("ae_ignore")) {
            return;
        }
        Projectile projectile = (Projectile)entityDamageByEntityEvent.getDamager();
        ProjectileSource projectileSource = projectile.getShooter();
        if (!(projectileSource instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)projectileSource;
        if (projectile instanceof Arrow) {
            if (!projectile.hasMetadata(EffectsHandler.getKey() + "handRIT")) {
                return;
            }
            rollItemType = (RollItemType)((Object)((MetadataValue)projectile.getMetadata(EffectsHandler.getKey() + "handRIT").get(0)).value());
            itemStack = livingEntity.getEquipment().getItem(rollItemType.getSlot());
        } else if (MinecraftVersion.isNew() && projectile instanceof Trident) {
            itemStack = TridentShootHandler.getItem(livingEntity.getUniqueId());
            if (itemStack == null) {
                return;
            }
            rollItemType = RollItemType.HAND;
        } else {
            return;
        }
        if (itemStack.getType() != Material.BOW && itemStack.getType() != Material.TRIDENT && itemStack.getType() != Material.CROSSBOW) {
            return;
        }
        if (projectile.hasMetadata("enchantsActivation") && !((MetadataValue)projectile.getMetadata("enchantsActivation").get(0)).asBoolean()) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getEntity();
        boolean bl = projectile.getLocation().getY() - player.getLocation().getY() > 1.45;
        this.executionBuilder().setAttacker(livingEntity).processVariables("%is headshot%;" + bl, "%projectile type%;" + (projectile instanceof Arrow ? "arrow" : "trident")).setVictim((LivingEntity)player).setAttackerMain(true).setEvent((Event)entityDamageByEntityEvent).setItemType(rollItemType).setItem(itemStack).buildAndExecute();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onShoot(EntityShootBowEvent entityShootBowEvent) {
        boolean bl = entityShootBowEvent.getForce() >= 0.5f;
        entityShootBowEvent.getProjectile().setMetadata(EffectsHandler.getKey() + "enchantsActivation", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)bl));
        EquipmentSlot equipmentSlot = EquipmentSlot.HAND;
        if (MinecraftVersion.getVersionNumber() < 1160) {
            if (entityShootBowEvent.getEntity() instanceof Player) {
                equipmentSlot = RollItemType.getHand((Player)entityShootBowEvent.getEntity(), entityShootBowEvent.getBow()).getSlot();
            } else if (entityShootBowEvent.getEntity().getEquipment() != null) {
                equipmentSlot = entityShootBowEvent.getEntity().getEquipment().getItemInMainHand().equals((Object)entityShootBowEvent.getBow()) ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
            }
        } else {
            equipmentSlot = entityShootBowEvent.getHand();
        }
        entityShootBowEvent.getProjectile().setMetadata(EffectsHandler.getKey() + "handRIT", (MetadataValue)new FixedMetadataValue((Plugin)EffectsHandler.getInstance(), (Object)RollItemType.getFromEquipment(equipmentSlot)));
    }
}

