/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.effects.effects.variables;

import java.util.Arrays;
import java.util.stream.StreamSupport;
import net.advancedplugins.ae.features.souls.SoulsAPI;
import net.advancedplugins.as.impl.effects.armorutils.ArmorType;
import net.advancedplugins.as.impl.effects.effects.EffectsHandler;
import net.advancedplugins.as.impl.effects.effects.actions.ActionExecution;
import net.advancedplugins.as.impl.effects.effects.utils.Combo;
import net.advancedplugins.as.impl.effects.effects.variables.Variables;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.AreaUtils;
import net.advancedplugins.as.impl.utils.ColorUtils;
import net.advancedplugins.as.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.items.api.AdvancedItemsAPI;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public enum StaticVariable {
    ADVANCEDITEMS_TYPE("advanceditems type", true),
    ADVANCEDITEMS_HELMET_TYPE("advanceditems helmet type", true),
    ADVANCEDITEMS_CHESTPLATE_TYPE("advanceditems chestplate type", true),
    ADVANCEDITEMS_LEGGINGS_TYPE("advanceditems leggings type", true),
    ADVANCEDITEMS_BOOTS_TYPE("advanceditems boots type", true),
    ADVANCEDENCHANTMENTS_SOULS("souls on item", true),
    CAN_BREAK("can break", true),
    FACTION_LAND("faction land", true),
    FOOD("food", true),
    IS_BLEEDING("is bleeding", true),
    HELMET("helmet", true),
    CHESTPLATE("chestplate", true),
    LEGGINGS("leggings", true),
    BOOTS("boots", true),
    IS_BLOCKING("is blocking", true),
    IS_FLYING("is flying", false),
    IS_SNEAKING("is sneaking", true),
    PERMISSIONS("permissions", true),
    IS_OP("is op", true),
    TRIGGER_TYPE("trigger type", false),
    BLOCK_BELOW("block below", false),
    COMBO("combo", false),
    CUSTOM_NAME("custom name", false),
    HEALTH("health", false),
    HEALTH_PERCENTAGE("health percentage", false),
    IS_CRITICAL("is critical", false),
    IS_GLIDING("is gliding", false),
    IS_HOLDING("is holding", false),
    IS_HOSTILE("is hostile", false),
    IS_ON_FIRE("is on fire", false),
    IS_NIGHT("is night", false),
    IS_REMOVAL("is removal", false),
    IS_UNDER_WATER("is under water", false),
    ITEM_SLOT("item slot", false),
    MAX_HEALTH("max health", false),
    MOB_TYPE("mob type", false),
    IS_PLAYER("is player", false),
    ITEM_TYPE("item type", false),
    NAME("name", false),
    NEARBY_MOBS("nearby mobs", false),
    OFFHAND_ITEM("offhand item", false),
    PLAYERS("players", false),
    TIME("time", false),
    WORLD("world", false),
    X("x", false),
    X_DOUBLE("x double", false),
    Y("y", false),
    Y_DOUBLE("y double", false),
    Z("z", false),
    Z_DOUBLE("z double", false),
    BLOCK_TAGS("block tags", false);

    private final String name;
    private final boolean player;

    private StaticVariable(String string2, boolean bl) {
        this.name = string2;
        this.player = bl;
    }

    public boolean needsPlayer() {
        return this.player;
    }

    public static String getValue(Variables.VariableData variableData, StaticVariable staticVariable, String string2, ActionExecution actionExecution) {
        Player player;
        LivingEntity livingEntity = StaticVariable.getTarget(variableData, staticVariable);
        if (staticVariable.needsPlayer() && livingEntity instanceof Player) {
            player = (Player)livingEntity;
            switch (staticVariable) {
                case ADVANCEDENCHANTMENTS_SOULS: {
                    if (!Bukkit.getPluginManager().isPluginEnabled("AdvancedEnchantments")) break;
                    return SoulsAPI.getSoulsOnItem((ItemStack)actionExecution.getBuilder().getItem()) + "";
                }
                case ADVANCEDITEMS_TYPE: 
                case ADVANCEDITEMS_BOOTS_TYPE: 
                case ADVANCEDITEMS_CHESTPLATE_TYPE: 
                case ADVANCEDITEMS_HELMET_TYPE: 
                case ADVANCEDITEMS_LEGGINGS_TYPE: {
                    ItemStack itemStack;
                    if (!Bukkit.getPluginManager().isPluginEnabled("AdvancedItems")) break;
                    ArmorType armorType = null;
                    if (staticVariable.equals((Object)ADVANCEDITEMS_BOOTS_TYPE)) {
                        armorType = ArmorType.BOOTS;
                    } else if (staticVariable.equals((Object)ADVANCEDITEMS_CHESTPLATE_TYPE)) {
                        armorType = ArmorType.CHESTPLATE;
                    } else if (staticVariable.equals((Object)ADVANCEDITEMS_HELMET_TYPE)) {
                        armorType = ArmorType.HELMET;
                    } else if (staticVariable.equals((Object)ADVANCEDITEMS_LEGGINGS_TYPE)) {
                        armorType = ArmorType.LEGGINGS;
                    }
                    ItemStack itemStack2 = itemStack = armorType == null ? actionExecution.getBuilder().getItem() : ((Player)livingEntity).getInventory().getItem(armorType.getEquipmentSlot());
                    if (itemStack == null) {
                        return "null";
                    }
                    return AdvancedItemsAPI.getCustomItemName((ItemStack)itemStack);
                }
                case CAN_BREAK: {
                    if (actionExecution.getBuilder().getBlock() == null) {
                        return "false";
                    }
                    return EffectsHandler.getProtection().canBreak(actionExecution.getBuilder().getBlock().getLocation(), player) + "";
                }
                case FOOD: {
                    return player.getFoodLevel() + "";
                }
                case IS_BLOCKING: {
                    return player.isBlocking() + "";
                }
                case IS_FLYING: {
                    return player.isFlying() + "";
                }
                case PERMISSIONS: {
                    return Arrays.toString(player.getEffectivePermissions().stream().map(permissionAttachmentInfo -> permissionAttachmentInfo.getPermission()).toArray());
                }
                case IS_OP: {
                    return player.isOp() + "";
                }
                case IS_SNEAKING: {
                    return player.isSneaking() + "";
                }
                case HELMET: {
                    return ASManager.tryOrElse(() -> player.getInventory().getHelmet().getType().name(), "AIR");
                }
                case CHESTPLATE: {
                    return ASManager.tryOrElse(() -> player.getInventory().getChestplate().getType().name(), "AIR");
                }
                case LEGGINGS: {
                    return ASManager.tryOrElse(() -> player.getInventory().getLeggings().getType().name(), "AIR");
                }
                case BOOTS: {
                    return ASManager.tryOrElse(() -> player.getInventory().getBoots().getType().name(), "AIR");
                }
            }
        }
        switch (staticVariable) {
            case TRIGGER_TYPE: {
                return actionExecution.getBuilder().getType();
            }
            case ITEM_TYPE: {
                return actionExecution.getBuilder().getItem().getType().name();
            }
            case BLOCK_BELOW: {
                return livingEntity.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().name();
            }
            case COMBO: {
                return Combo.getCombos(livingEntity.getUniqueId()) + "";
            }
            case CUSTOM_NAME: {
                return livingEntity.isCustomNameVisible() ? ColorUtils.stripColor(livingEntity.getCustomName()) : "N/A";
            }
            case HEALTH: {
                return livingEntity.getHealth() + "";
            }
            case HEALTH_PERCENTAGE: {
                return (int)(livingEntity.getHealth() / livingEntity.getMaxHealth() * 100.0) + "";
            }
            case IS_CRITICAL: {
                player = livingEntity.getLocation().getBlock().getType();
                boolean bl = livingEntity.getFallDistance() > 0.0f && !livingEntity.isOnGround() && !livingEntity.isInsideVehicle() && !livingEntity.hasPotionEffect(PotionEffectType.BLINDNESS) && !livingEntity.getLocation().getBlock().isLiquid() && player != Material.LADDER && player != Material.VINE && (MinecraftVersion.getVersionNumber() < 1160 || player != Material.WEEPING_VINES_PLANT && player != Material.TWISTING_VINES_PLANT);
                return bl + "";
            }
            case IS_GLIDING: {
                return MinecraftVersion.getVersionNumber() >= 190 ? livingEntity.isGliding() + "" : "false";
            }
            case IS_HOLDING: {
                return livingEntity.getEquipment().getItemInHand().getType().name();
            }
            case IS_HOSTILE: {
                return (livingEntity instanceof Monster) + "";
            }
            case IS_ON_FIRE: {
                return (livingEntity.getFireTicks() > 0) + "";
            }
            case IS_REMOVAL: {
                return actionExecution.getBuilder().isRemoved() + "";
            }
            case IS_NIGHT: {
                long l = livingEntity.getWorld().getTime();
                return (l >= 12300L && l <= 23850L) + "";
            }
            case IS_UNDER_WATER: {
                return livingEntity.getEyeLocation().getBlock().getType().name().contains("WATER") + "";
            }
            case ITEM_SLOT: {
                return actionExecution.getBuilder().getItemType().name();
            }
            case MAX_HEALTH: {
                return livingEntity.getMaxHealth() + "";
            }
            case MOB_TYPE: {
                return livingEntity.getType().name();
            }
            case IS_PLAYER: {
                return String.valueOf(livingEntity instanceof Player);
            }
            case NAME: {
                return livingEntity.getName();
            }
            case NEARBY_MOBS: {
                return AreaUtils.getEntitiesInRadius(10, (Entity)livingEntity, AreaUtils.RadiusTarget.MOBS).size() + "";
            }
            case OFFHAND_ITEM: {
                return MinecraftVersion.getVersionNumber() >= 190 ? livingEntity.getEquipment().getItemInOffHand().getType().name() : "AIR";
            }
            case PLAYERS: {
                return AreaUtils.getEntitiesInRadius(10, (Entity)livingEntity, AreaUtils.RadiusTarget.PLAYERS).size() + "";
            }
            case TIME: {
                return livingEntity.getWorld().getTime() + "";
            }
            case WORLD: {
                return livingEntity.getWorld().getName();
            }
            case X: {
                return livingEntity.getLocation().getBlockX() + "";
            }
            case Y: {
                return livingEntity.getLocation().getBlockY() + "";
            }
            case Z: {
                return livingEntity.getLocation().getBlockZ() + "";
            }
            case X_DOUBLE: {
                return livingEntity.getLocation().getX() + "";
            }
            case Y_DOUBLE: {
                return livingEntity.getLocation().getY() + "";
            }
            case Z_DOUBLE: {
                return livingEntity.getLocation().getZ() + "";
            }
            case BLOCK_TAGS: {
                Block block = actionExecution.getBuilder().getBlock();
                if (block == null) {
                    return "[]";
                }
                String[] stringArray = (String[])StreamSupport.stream(Bukkit.getTags((String)"blocks", actionExecution.getBuilder().getBlock().getType().getClass()).spliterator(), false).map(tag -> tag).filter(tag -> tag.isTagged((Keyed)block.getType())).map(tag -> tag.getKey() + "").map(string -> string.replace(":", "@")).toArray(String[]::new);
                return "[" + ASManager.join(stringArray, ", ") + "]";
            }
        }
        return "";
    }

    public static LivingEntity getTarget(Variables.VariableData variableData, StaticVariable staticVariable) {
        return variableData.condition.contains("victim " + staticVariable.getName()) ? variableData.secondary : variableData.primary;
    }

    public String getName() {
        return this.name;
    }
}

