/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.as.impl.utils.commands;

import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Command<T extends CommandSender> {
    protected final JavaPlugin plugin;
    private final String permission;
    private final boolean isConsole;
    private Function<T, String> noPermission;
    private Function<T, String> notOnline;

    public Command(JavaPlugin javaPlugin, String string, boolean bl) {
        this.plugin = javaPlugin;
        this.permission = string;
        this.isConsole = bl;
        this.noPermission = commandSender -> "&cYou do not have permission to do this.";
    }

    public abstract void onExecute(T var1, String[] var2);

    public void middleMan(CommandSender commandSender, String[] stringArray) {
        this.onExecute(commandSender, stringArray);
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isConsole() {
        return this.isConsole;
    }

    public void noPermissionLang(Function<T, String> function) {
        this.noPermission = function;
    }

    public void setNotOnlineLang(Function<T, String> function) {
        this.notOnline = function;
    }

    public String getNoPermissionLang(CommandSender commandSender) {
        return this.noPermission.apply(commandSender);
    }

    public String getNotOnlineLang(CommandSender commandSender) {
        return this.notOnline.apply(commandSender);
    }

    public boolean isPlayerOnline(CommandSender commandSender, Player player) {
        if (player == null || !player.isOnline()) {
            commandSender.sendMessage(this.notOnline.apply(commandSender));
            return false;
        }
        return true;
    }
}

