/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.biomes.nms;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.as.impl.utils.nbt.backend.ReflectionMethod;
import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.biomes.AdvancedBiomeBase;
import net.advancedplugins.seasons.biomes.SeasonData;
import net.advancedplugins.seasons.enums.ColorType;
import net.advancedplugins.seasons.enums.SeasonType;
import net.advancedplugins.seasons.objects.INMSBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_19_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class NMSBiome_1_19_4
implements INMSBiome {
    private static CraftServer craftserver;
    private static DedicatedServer dedicatedserver;
    public static IRegistry<BiomeBase> registrywritable;
    private static HashMap<Integer, Biome> biomeIds;
    public BiomeBase.a newBiome;
    private int biomeID;

    public NMSBiome_1_19_4() {
        craftserver = (CraftServer)Bukkit.getServer();
        dedicatedserver = craftserver.getServer();
        NMSBiome_1_19_4.unlockRegistry();
        registrywritable = dedicatedserver.aX().d(Registries.an);
        for (Biome biome : Biome.values()) {
            try {
                Holder holder = CraftBlock.biomeToBiomeBase(registrywritable, (Biome)biome);
                if (holder == null) continue;
                biomeIds.put(registrywritable.a((Object)((BiomeBase)holder.a())), biome);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NMSBiome_1_19_4(AdvancedBiomeBase advancedBiomeBase, SeasonType seasonType, SeasonData seasonData, int n) {
        try {
            ResourceKey resourceKey = ResourceKey.a((ResourceKey)Registries.an, (MinecraftKey)new MinecraftKey("advanced", advancedBiomeBase.getName() + "_" + seasonType.name().toLowerCase() + "_" + n));
            BiomeBase biomeBase = (BiomeBase)registrywritable.a(ResourceKey.a((ResourceKey)Registries.an, (MinecraftKey)new MinecraftKey("minecraft", advancedBiomeBase.getBiomes().get(0).toLowerCase())));
            this.newBiome = new BiomeBase.a();
            BiomeFog.a a2 = new BiomeFog.a();
            this.newBiome.a(biomeBase.c());
            this.newBiome.a(biomeBase.d());
            this.newBiome.a(biomeBase.b());
            this.newBiome.b(0.05f);
            this.newBiome.a(0.75f);
            if (!seasonData.isSnow()) {
                this.newBiome.a(BiomeBase.TemperatureModifier.b);
            } else {
                this.newBiome.a(BiomeBase.TemperatureModifier.a);
                this.newBiome.a(0.0f);
            }
            a2.a(BiomeFog.GrassColor.a);
            a2.d(ASManager.hexToDecimal(seasonData.getColors().get((Object)ColorType.SKY)));
            a2.b(ASManager.hexToDecimal(seasonData.getColors().get((Object)ColorType.WATER)));
            a2.c(ASManager.hexToDecimal(seasonData.getColors().get((Object)ColorType.WATERFOG)));
            a2.f(ASManager.hexToDecimal(seasonData.getColors().get((Object)ColorType.GRASS)));
            a2.e(ASManager.hexToDecimal(seasonData.getColors().get((Object)ColorType.TREE)));
            a2.a(ASManager.hexToDecimal(seasonData.getColors().get((Object)ColorType.FOG)));
            this.newBiome.a(a2.a());
            BiomeBase biomeBase2 = this.newBiome.a();
            RegistryMaterials registryMaterials = (RegistryMaterials)registrywritable;
            Field field = RegistryMaterials.class.getDeclaredField(ReflectionMethod.NMS_REGISTER_BIOME.getMethodName());
            field.setAccessible(true);
            field.set(registryMaterials, new IdentityHashMap());
            registryMaterials.f((Object)biomeBase2);
            registryMaterials.a(resourceKey, (Object)biomeBase2, Lifecycle.stable());
            field.set(registryMaterials, null);
            this.biomeID = this.getBiomeId(biomeBase2);
        }
        catch (Exception exception) {
            Core.getInstance().getLogger().warning("Failed to load biome " + advancedBiomeBase.getName() + " season " + seasonType.name() + ": " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public Holder<BiomeBase> getBiome() {
        return Holder.a((Object)((BiomeBase)registrywritable.a(this.biomeID)));
    }

    @Override
    public int getBiomeId(Holder<BiomeBase> holder) {
        return this.getBiomeId((BiomeBase)holder.a());
    }

    @Override
    public Integer getVanillaBiomeId(Biome biome) {
        return ASManager.getKeysByValue(biomeIds, biome).stream().findFirst().orElse(null);
    }

    @Override
    public int getBiomeID() {
        return this.biomeID;
    }

    @Override
    public Holder<BiomeBase> getBiome(int n) {
        return Holder.a((Object)((BiomeBase)registrywritable.a(n)));
    }

    @Override
    public int getBiomeId(BiomeBase biomeBase) {
        return registrywritable.a((Object)biomeBase);
    }

    @Override
    public Biome getDefaultBiome(int n) {
        return biomeIds.get(n);
    }

    public static void unlockRegistry() {
        RegistryMaterials registryMaterials = (RegistryMaterials)dedicatedserver.aX().d(Registries.an);
        try {
            Arrays.stream(RegistryMaterials.class.getDeclaredFields()).filter(field -> field.getType().equals(Boolean.TYPE)).forEach(field -> {
                try {
                    field.setAccessible(true);
                    field.setBoolean(registryMaterials, false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void sendChunkUpdate(Chunk chunk, Player player) {
        block7: {
            try {
                Method method;
                Object object;
                EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
                Field field = entityPlayer.getClass().getDeclaredField("b");
                field.setAccessible(true);
                ServerPlayerConnection serverPlayerConnection = (ServerPlayerConnection)field.get(entityPlayer);
                if (serverPlayerConnection == null) break block7;
                CraftChunk craftChunk = (CraftChunk)chunk;
                Object object2 = null;
                try {
                    object = craftChunk.getClass().getMethod("getHandle", Class.forName("net.minecraft.world.level.chunk.ChunkStatus"));
                    object2 = ((Method)object).invoke((Object)craftChunk, ChunkStatus.n);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = craftChunk.getClass().getMethod("getHandle", new Class[0]);
                        object2 = method.invoke((Object)craftChunk, new Object[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                object = (CraftWorld)chunk.getWorld();
                method = object.getHandle();
                serverPlayerConnection.a((Packet)new ClientboundLevelChunkWithLightPacket((net.minecraft.world.level.chunk.Chunk)object2, method.l_(), null, null, true));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getType(ChunkSection chunkSection, int n, int n2, int n3) {
        return "" + chunkSection.a(n, n2, n3).b().k();
    }

    public static HashMap<Integer, Biome> getBiomeIds() {
        return biomeIds;
    }

    static {
        biomeIds = new HashMap();
    }
}

