/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.handlers.grass;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import net.advancedplugins.as.impl.utils.ASManager;
import net.advancedplugins.seasons.handlers.grass.GrassPattern;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class GrassPatternsUtil {
    private static final Random random = new Random();
    private static ImmutableList<GrassPattern> grassPatterns = null;

    private static void init() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new GrassPattern((ImmutableList<Material>)ImmutableList.of((Object)Material.FERN), 10, 1, 2, 100));
        builder.add((Object)new GrassPattern((ImmutableList<Material>)ImmutableList.of((Object)Material.DANDELION), 55, 2, 20, 40));
        builder.add((Object)new GrassPattern((ImmutableList<Material>)ImmutableList.of((Object)Material.POPPY), 64, 2, 10, 40));
        builder.add((Object)new GrassPattern((ImmutableList<Material>)ImmutableList.of((Object)Material.POPPY), 45, 3, 10, 40));
        builder.add((Object)new GrassPattern((ImmutableList<Material>)ImmutableList.of((Object)Material.DANDELION, (Object)Material.AZURE_BLUET), 90, 5, 5, 20));
        builder.add((Object)new GrassPattern((ImmutableList<Material>)ImmutableList.of((Object)Material.DANDELION, (Object)Material.AZURE_BLUET), 222, 5, 10, 20));
        grassPatterns = builder.build();
    }

    public static Material process(Block block) {
        if (grassPatterns == null) {
            GrassPatternsUtil.init();
        }
        int n = block.getX();
        int n2 = block.getZ();
        for (GrassPattern grassPattern : grassPatterns) {
            int n3 = grassPattern.getPatchInterval();
            int n4 = grassPattern.getPatchRadius();
            int n5 = n / n3 * n3;
            int n6 = n2 / n3 * n3;
            int n7 = n5 + random.nextInt(21) - grassPattern.getOffset();
            int n8 = n6 + random.nextInt(21) - grassPattern.getOffset();
            if (Math.abs(n - n7) <= n4 && Math.abs(n2 - n8) <= n4 && ASManager.doChancesPass(grassPattern.getChance())) {
                return (Material)grassPattern.getMaterials().get(random.nextInt(grassPattern.getMaterials().size()));
            }
            if (!ASManager.doChancesPass(20 / grassPatterns.size())) continue;
            return Material.GRASS;
        }
        return Material.AIR;
    }
}

