/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.seasons.listeners;

import net.advancedplugins.seasons.Core;
import net.advancedplugins.seasons.handlers.CropsHandler;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;

public class CropGrowthListener
implements Listener {
    private final CropsHandler cropsHandler;

    @EventHandler
    public void onGrow(BlockGrowEvent blockGrowEvent) {
        Block block = blockGrowEvent.getBlock();
        if (!(block.getBlockData() instanceof Ageable)) {
            return;
        }
        Ageable ageable = (Ageable)block.getBlockData();
        if (!Core.getWorldHandler().isWorldEnabled(block.getWorld().getName())) {
            return;
        }
        blockGrowEvent.setCancelled(true);
        if (ageable.getLightEmission() < 0) {
            return;
        }
        int n = ageable.getAge();
        int n2 = ageable.getMaximumAge();
        ageable.setAge(this.cropsHandler.getBlockGrowth(block, n, n2));
        block.setBlockData((BlockData)ageable);
    }

    public CropGrowthListener(CropsHandler cropsHandler) {
        this.cropsHandler = cropsHandler;
    }
}

