/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsoplus.utils;

import com.alonsoaliaga.alonsoplus.others.Materials;
import com.alonsoaliaga.alonsoplus.others.Sounds;
import com.alonsoaliaga.alonsoplus.utils.AlonsoUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.tr7zw.nbtapi.NBTCompound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class LocalUtils {
    public static long DAY_START;
    public static long DAY_END;
    public static boolean hexColorSupport;
    public static boolean longInventoryTitleSupport;
    public static boolean fixColors;
    private static Map<org.bukkit.ChatColor, ColorSet<Integer, Integer, Integer>> colorMap;
    private static final NavigableMap<Long, String> suffixes;

    public static String translateAlternateHexColorCodes(Character c, String string) {
        string = org.bukkit.ChatColor.translateAlternateColorCodes((char)c.charValue(), (String)string);
        if (string.length() < 7 || !string.contains("#")) {
            return string;
        }
        Matcher matcher = Pattern.compile("#[A-Fa-f0-9]{6}").matcher(string);
        if (fixColors) {
            while (matcher.find()) {
                String string2 = matcher.group(0);
                ChatColor chatColor = ChatColor.of((String)string2);
                org.bukkit.ChatColor chatColor2 = LocalUtils.fromRGB(chatColor.getColor().getRed(), chatColor.getColor().getGreen(), chatColor.getColor().getBlue());
                String string3 = chatColor.toString();
                string = string.replace(string2, string3.substring(0, string3.length() - 1) + chatColor2.getChar());
            }
        } else {
            while (matcher.find()) {
                String string4 = matcher.group(0);
                ChatColor chatColor = ChatColor.of((String)string4);
                string = string.replace(string4, chatColor.toString());
            }
        }
        return string;
    }

    public static org.bukkit.ChatColor fromRGB(int n, int n2, int n3) {
        TreeMap treeMap = new TreeMap();
        colorMap.forEach((chatColor, colorSet) -> {
            int n4 = Math.abs(n - (Integer)colorSet.getRed());
            int n5 = Math.abs(n2 - (Integer)colorSet.getGreen());
            int n6 = Math.abs(n3 - (Integer)colorSet.getBlue());
            treeMap.put(n4 + n5 + n6, chatColor);
        });
        return (org.bukkit.ChatColor)treeMap.firstEntry().getValue();
    }

    public static void setFixColors(boolean bl) {
        if (fixColors != bl) {
            LocalUtils.logp((bl ? "Enabling" : "Disabling") + " HEX color fix for 1.8 - 1.15 players.." + (bl ? " (This is an experimental feature)" : ""));
        }
        fixColors = bl;
    }

    public static String colorize(String string) {
        if (hexColorSupport) {
            return LocalUtils.translateAlternateHexColorCodes(Character.valueOf('&'), string);
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static List<String> colorize(List<String> list) {
        return list.stream().map(LocalUtils::colorize).collect(Collectors.toList());
    }

    public static void logp(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "AlonsoPlus" + "] &7" + string));
    }

    public static void logd(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(AlonsoUtils.second + "[" + "AlonsoPlus" + "]" + AlonsoUtils.first + "&l[Debug] &7" + string));
    }

    public static void loge(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize("&c[AlonsoPlus] " + string));
    }

    public static void log(String string) {
        Bukkit.getConsoleSender().sendMessage(LocalUtils.colorize(string));
    }

    public static Material findMaterial(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Material.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Material.COBBLESTONE;
    }

    public static Sound findSound(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            return Sound.valueOf((String)"CLICK");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Sound.valueOf((String)"UI_BUTTON_CLICK");
        }
    }

    public static Sound getSound(String string) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (Exception exception) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public static Sound getSound(String string, Sound sound) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (Exception exception) {
            try {
                return Sound.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return sound;
            }
        }
    }

    public static Sound getSoundException(String string) {
        try {
            return Sounds.valueOf(string.toUpperCase()).getSound();
        }
        catch (Exception exception) {
            return Sound.valueOf((String)string.toUpperCase());
        }
    }

    public static Material getMaterial(String string) {
        try {
            return Materials.valueOf(string).getMaterial();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Material.valueOf((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public static Material getMaterial(String string, Material material) {
        try {
            return Materials.valueOf(string).getMaterial();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Material.valueOf((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return material;
            }
        }
    }

    public static Material getMaterialException(String string) {
        try {
            return Materials.valueOf(string).getMaterial();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Material.valueOf((String)string);
        }
    }

    public static List<EntityType> getEntityTypes(String ... stringArray) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        for (String string : stringArray) {
            try {
                arrayList.add(EntityType.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static List<EntityType> getEntityTypes(List<String> list) {
        ArrayList<EntityType> arrayList = new ArrayList<EntityType>();
        for (String string : list) {
            try {
                arrayList.add(EntityType.valueOf((String)string.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LocalUtils.logp("&cInvalid entity type: " + string.toUpperCase());
            }
        }
        return arrayList;
    }

    public static String numberFormat(long l) {
        if (l == Long.MIN_VALUE) {
            return LocalUtils.numberFormat(-9223372036854775807L);
        }
        if (l < 0L) {
            return "-" + LocalUtils.numberFormat(-l);
        }
        if (l < 1000L) {
            return Long.toString(l);
        }
        Map.Entry<Long, String> entry = suffixes.floorEntry(l);
        Long l2 = entry.getKey();
        String string = entry.getValue();
        long l3 = l / (l2 / 10L);
        boolean bl = l3 < 100L && (double)l3 / 10.0 != (double)(l3 / 10L);
        return bl ? (double)l3 / 10.0 + string : l3 / 10L + string;
    }

    public static String limitString(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static void setUUID(NBTCompound nBTCompound, String string, UUID uUID) {
        if (AlonsoUtils.serverVersion.isOlderThan(AlonsoUtils.ServerVersion.v1_16)) {
            nBTCompound.setString(string, uUID.toString());
        } else {
            nBTCompound.setUUID(string, uUID);
        }
    }

    public static String pascalCase(String string) {
        return LocalUtils.pascalCase(string, false);
    }

    public static String pascalCase(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 1) {
            return string.toUpperCase();
        }
        String string2 = bl ? string.trim().replace("_", " ").replace("-", " ") : string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : string2.split(" ")) {
            if (!string3.isEmpty()) {
                arrayList.add(string3.substring(0, 1).toUpperCase() + string3.substring(1).toLowerCase());
                continue;
            }
            arrayList.add("");
        }
        return String.join((CharSequence)" ", arrayList);
    }

    public static String firstCase(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string.length() <= 1) {
            return string2.toUpperCase();
        }
        return string2.substring(0, 1).toUpperCase() + string2.substring(1).toLowerCase();
    }

    public static String firstCase(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        if (!bl) {
            return LocalUtils.firstCase(string);
        }
        String string2 = string.trim();
        if (string.length() <= 1) {
            return string2.toUpperCase();
        }
        return (string2.substring(0, 1).toUpperCase() + string2.substring(1).toLowerCase()).replace("_", " ").replace("-", " ");
    }

    public static boolean isDay(long l) {
        if (l >= 24000L) {
            l %= 24000L;
        }
        return l > DAY_START || l < DAY_END;
    }

    public static boolean isNight(long l) {
        return !LocalUtils.isDay(l);
    }

    @Nullable
    public static Location decodeLocation(String string) {
        if (string == null) {
            return null;
        }
        try {
            String[] stringArray = string.split("\\|");
            World world = Bukkit.getWorld((String)stringArray[0]);
            if (world == null) {
                return null;
            }
            return new Location(world, Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Player player, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (alonsoPlugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            protocolManager.sendServerPacket(player, packetContainer);
        }
        catch (Exception exception) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to %s", "[AlonsoPlus] ", player.getName()));
        }
    }

    public static void sendProtocolActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Collection<Player> collection, String string) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        packetContainer.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)string));
        try {
            if (alonsoPlugin.getPluginUtils().getActionBarProtocolMethod() == 0) {
                packetContainer.getBytes().write(0, (Object)2);
            } else {
                packetContainer.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            for (Player player : collection) {
                protocolManager.sendServerPacket(player, packetContainer);
            }
        }
        catch (Exception exception) {
            LocalUtils.log(String.format("&c%s[ProtocolLib] Error sending Action Bar to players.", "[AlonsoPlus] "));
        }
    }

    public static void sendBungeeActionBar(Player player, String string) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
    }

    public static void sendActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Player player, String string) {
        if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            LocalUtils.sendBungeeActionBar(player, string);
        } else if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar(alonsoPlugin, player, string);
        } else {
            player.sendMessage(string);
        }
    }

    public static void sendActionBar(AlonsoUtils.AlonsoPlugin alonsoPlugin, Collection<Player> collection, String string) {
        if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.BUNGEE) {
            for (Player player : collection) {
                LocalUtils.sendBungeeActionBar(player, string);
            }
        } else if (alonsoPlugin.getPluginUtils().getActionBarType() == AlonsoUtils.ActionBarType.PROTOCOL) {
            LocalUtils.sendProtocolActionBar(alonsoPlugin, collection, string);
        } else {
            for (Player player : collection) {
                player.sendMessage(string);
            }
        }
    }

    @Nullable
    public static String encodeLocation(Location location) {
        if (location == null) {
            return null;
        }
        try {
            String string = "%s|%s|%s|%s|%s|%s";
            return String.format(string, location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void send(CommandSender commandSender, String string) {
        commandSender.sendMessage(LocalUtils.colorize(string));
    }

    public static Collection<Material> getMaterials(String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        return Stream.of(Material.values()).filter(material -> list.contains(material.name())).collect(Collectors.toList());
    }

    public static List<Location> getLocationsInLine(Location location, Location location2) {
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        Vector vector2 = location.getDirection();
        double d = location.distance(location2);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(location.clone());
        int n = 0;
        while ((double)n < d) {
            Location location3 = location.add(vector2);
            arrayList.add(location3.clone());
            ++n;
        }
        return arrayList;
    }

    public static List<Location> getLocationsInLine(Location location, Location location2, double d) {
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        Vector vector2 = location.getDirection();
        double d2 = location.distance(location2);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(location.clone());
        for (double d3 = 0.0; d3 < d2; d3 += d) {
            Location location3 = location.add(vector2);
            arrayList.add(location3.clone());
        }
        return arrayList;
    }

    public static String getDuration(long l, boolean bl) {
        if (!bl) {
            return LocalUtils.getDuration(l);
        }
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (l > 86399999L) {
            return Math.abs(l5) + "d " + Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 1439999L) {
            return Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 59999L) {
            return Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        long l6 = Math.abs(l2) % 60L;
        return (l6 <= 0L ? 1L : l6) + "s";
    }

    public static String getDuration(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (l > 86399999L) {
            return Math.abs(l5) + "d " + Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        if (l > 3599999L) {
            return Math.abs(l4 % 24L) + "h " + Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
        }
        return Math.abs(l3) % 60L + "m " + Math.abs(l2) % 60L + "s";
    }

    public static String getWatchDuration(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        if (l > 86399999L) {
            return Math.abs(l5) + ":" + Math.abs(l4 % 24L) + ":" + Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
        }
        if (l > 1439999L) {
            return Math.abs(l4 % 24L) + ":" + Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
        }
        return Math.abs(l3) % 60L + ":" + Math.abs(l2) % 60L;
    }

    public static String random(List<String> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <E> E randomNbt(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static LivingEntity getLivingEntityAround(Player player, UUID uUID, int n, int n2) {
        Optional<Entity> optional = player.getNearbyEntities((double)n2, (double)n2, (double)n2).stream().filter(entity -> entity instanceof LivingEntity && entity.getEntityId() == n).findFirst();
        return optional.orElse(null);
    }

    public static TextComponent createClickable(@Nonnull String string, HoverEvent.Action action, @Nullable String string2, ClickEvent.Action action2, String string3) {
        TextComponent textComponent = new TextComponent(LocalUtils.colorize(string));
        if (string2 != null && action != null) {
            textComponent.setHoverEvent(new HoverEvent(action, new ComponentBuilder(LocalUtils.colorize(string2)).create()));
        }
        if (string3 != null && action2 != null) {
            textComponent.setClickEvent(new ClickEvent(action2, string3));
        }
        return textComponent;
    }

    public static void sendTitle(Player player, String string, String string2, int n, int n2, int n3) {
        if (AlonsoUtils.serverVersion.isOlderEqualThan(AlonsoUtils.ServerVersion.v1_12)) {
            player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2));
        } else {
            player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2), n, n2, n3);
        }
    }

    public static void sendTitle(Player player, String string, String string2) {
        player.sendTitle(LocalUtils.colorize(string), LocalUtils.colorize(string2), 15, 30, 15);
    }

    public static String fixInventoryTitle(String string) {
        return longInventoryTitleSupport ? string : (string.length() > 32 ? string.substring(0, 32) : string);
    }

    public static void findClasses(String string, String ... stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            try {
                Class.forName(string2);
                bl = true;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (!bl) {
            Class.forName(string);
        }
    }

    static {
        Inventory inventory;
        DAY_START = 22750L;
        DAY_END = 12750L;
        fixColors = true;
        colorMap = new HashMap<org.bukkit.ChatColor, ColorSet<Integer, Integer, Integer>>();
        try {
            inventory = Class.forName("net.md_5.bungee.api.ChatColor");
            inventory.getDeclaredMethod("of", String.class);
            hexColorSupport = true;
            LocalUtils.logp("Hex colors are available! Ready for RGB..");
        }
        catch (Throwable throwable) {
            hexColorSupport = false;
            LocalUtils.logp("Hex colors are not available! Ignoring..");
        }
        try {
            inventory = Bukkit.createInventory(null, (int)9, (String)"Hello Thanks For Downloading My Plugin. Consider donating to support my work on https://alonsoaliaga.com/donate");
            inventory.setItem(0, new ItemStack(Materials.PLAYER_HEAD.getMaterial()));
            longInventoryTitleSupport = true;
            LocalUtils.logp("Inventory title with support for more than 32 characters. Skipping..");
        }
        catch (Throwable throwable) {
            longInventoryTitleSupport = false;
            LocalUtils.logp("Inventory title without support for more than 32 characters. Limiting..");
        }
        if (hexColorSupport) {
            LocalUtils.log("Enabling HEX color fix for 1.8 - 1.15 players.. (This is an experimental feature");
            colorMap.put(org.bukkit.ChatColor.BLACK, new ColorSet<Integer, Integer, Integer>(0, 0, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_BLUE, new ColorSet<Integer, Integer, Integer>(0, 0, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_GREEN, new ColorSet<Integer, Integer, Integer>(0, 170, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_AQUA, new ColorSet<Integer, Integer, Integer>(0, 170, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_RED, new ColorSet<Integer, Integer, Integer>(170, 0, 0));
            colorMap.put(org.bukkit.ChatColor.DARK_PURPLE, new ColorSet<Integer, Integer, Integer>(170, 0, 170));
            colorMap.put(org.bukkit.ChatColor.GOLD, new ColorSet<Integer, Integer, Integer>(255, 170, 0));
            colorMap.put(org.bukkit.ChatColor.GRAY, new ColorSet<Integer, Integer, Integer>(170, 170, 170));
            colorMap.put(org.bukkit.ChatColor.DARK_GRAY, new ColorSet<Integer, Integer, Integer>(85, 85, 85));
            colorMap.put(org.bukkit.ChatColor.BLUE, new ColorSet<Integer, Integer, Integer>(85, 85, 255));
            colorMap.put(org.bukkit.ChatColor.GREEN, new ColorSet<Integer, Integer, Integer>(85, 255, 85));
            colorMap.put(org.bukkit.ChatColor.AQUA, new ColorSet<Integer, Integer, Integer>(85, 255, 255));
            colorMap.put(org.bukkit.ChatColor.RED, new ColorSet<Integer, Integer, Integer>(255, 85, 85));
            colorMap.put(org.bukkit.ChatColor.LIGHT_PURPLE, new ColorSet<Integer, Integer, Integer>(255, 85, 255));
            colorMap.put(org.bukkit.ChatColor.YELLOW, new ColorSet<Integer, Integer, Integer>(255, 255, 85));
            colorMap.put(org.bukkit.ChatColor.WHITE, new ColorSet<Integer, Integer, Integer>(255, 255, 255));
        }
        suffixes = new TreeMap<Long, String>();
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }

    private static class ColorSet<R, G, B> {
        R red = null;
        G green = null;
        B blue = null;

        ColorSet(R r, G g, B b) {
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public R getRed() {
            return this.red;
        }

        public G getGreen() {
            return this.green;
        }

        public B getBlue() {
            return this.blue;
        }
    }
}

