/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.commands;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.api.events.TagPurchaseEvent;
import com.alonsoaliaga.alonsotags.api.events.TagSelectEvent;
import com.alonsoaliaga.alonsotags.commands.AbstractCommand;
import com.alonsoaliaga.alonsotags.others.ColorData;
import com.alonsoaliaga.alonsotags.others.CommandData;
import com.alonsoaliaga.alonsotags.others.PlayerData;
import com.alonsoaliaga.alonsotags.others.Sounds;
import com.alonsoaliaga.alonsotags.others.TagData;
import com.alonsoaliaga.alonsotags.utils.AlonsoUtils;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class MainCommand
extends AbstractCommand {
    private AlonsoTags plugin;
    private boolean supportDeveloper;
    private List<String> openList;
    private List<String> reloadList;
    private List<String> userList;
    private List<String> setList;
    private List<String> adminList;
    private List<String> emptyList = Collections.emptyList();
    private boolean testServer = false;
    private String testError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, you can only use commands to modify your player in this test server!");
    private String testReloadError = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");
    private String testPaste = LocalUtils.colorize("&cHey {PLAYER}! For security reasons, this command is disabled in this test server!");

    public MainCommand(AlonsoTags alonsoTags, String string, List<String> list) {
        super(string, "/" + string, "AlonsoTags main command.", list);
        this.plugin = alonsoTags;
        this.register();
        this.reloadMessages();
    }

    private void reloadMessages() {
        this.adminList = new ArrayList<String>();
        this.userList = new ArrayList<String>();
        this.supportDeveloper = this.plugin.getFiles().getConfig().get().getBoolean("Options.Support-developer", true);
        this.openList = this.plugin.getFiles().getConfig().get().getStringList("Options.Sub-commands.Open");
        if (this.openList.isEmpty()) {
            this.openList = Arrays.asList("open");
        }
        this.setList = this.plugin.getFiles().getConfig().get().getStringList("Options.Sub-commands.Set");
        if (this.setList.isEmpty()) {
            this.setList = Arrays.asList("set");
        }
        this.reloadList = this.plugin.getFiles().getConfig().get().getStringList("Options.Sub-commands.Reload");
        if (this.reloadList.isEmpty()) {
            this.reloadList = Arrays.asList("reload");
        }
        this.userList.addAll(this.openList);
        this.adminList.addAll(this.openList);
        this.adminList.addAll(this.setList);
        this.adminList.addAll(this.reloadList);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Object object;
        if (!this.plugin.allowedWorlds.isEmpty() && !commandSender.hasPermission(this.plugin.permissions.adminPermission) && commandSender instanceof Player && !this.plugin.allowedWorlds.contains((object = (Player)commandSender).getWorld().getName())) {
            object.sendMessage(this.plugin.messages.disabledWorld);
            return true;
        }
        if (stringArray.length >= 1) {
            if (stringArray[0].equalsIgnoreCase("paste") && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testPaste.replace("{PLAYER}", commandSender.getName()));
                    return true;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    String string;
                    String string2 = Arrays.stream(this.plugin.tagsSlots).boxed().map(String::valueOf).collect(Collectors.joining(","));
                    String string3 = string = "Plugin: " + this.plugin.getDescription().getName() + "\nVersion: " + this.plugin.getDescription().getVersion() + "\nJava: " + System.getProperty("java.version") + "\nOS: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")\nServer: " + this.plugin.getServer().getName() + " (" + this.plugin.getServer().getVersion() + ")\nUser: www.spigotmc.org/members/%%__USER__%%/\nDebug: " + this.plugin.debugMode + " (" + AlonsoUtils.serverVersion.name() + ")\nDate: " + new Date().toString() + "\nParse output: " + this.plugin.parseOutput + "\nParse recognition output: " + this.plugin.parseRecognitionOutput + "\nTags slot: " + string2 + " (Default?" + "10,11,12,13,14,15,16,19,20,21,22,23,24,25,28,29,30,31,32,33,34,37,38,39,40,41,42,43".equals(string2) + ") \nChat compatibility: " + (this.plugin.chatCompatibility ? "Enabled" : "Disabled") + "\nPlayer head: Active=" + (this.plugin.playerHeadActiveItem != null) + "| Inactive=" + (this.plugin.playerHeadInactiveItem != null) + "\nTags: " + this.plugin.getTagsMap().size() + " (" + this.plugin.getTagSlotPagesMap().size() + " pages)\nItemsAdder hook: " + this.plugin.itemsAdderSupport + "\nOraxen hook: " + this.plugin.oraxenSupport + "\nObfuscate enabled: " + this.plugin.obfuscateEnabled + "\nLocked icon enabled: " + this.plugin.lockedIconEnabled + "\nDatabase:" + (this.plugin.hikariEnabled ? "HikariCP" : (this.plugin.mysqlEnabled ? "MySQL" : "SQLite")) + "\nCurrencies loaded: " + (this.plugin.getCurrencyMap().isEmpty() ? "None" : this.plugin.getCurrencyMap().keySet().stream().map(Enum::name).collect(Collectors.joining(","))) + "\nVault currencies loaded: " + (this.plugin.getVaultHooksMap().isEmpty() ? "None" : String.join((CharSequence)",", this.plugin.getVaultHooksMap().keySet())) + "\nColors: " + this.plugin.getColorsMap().size();
                    int n = ThreadLocalRandom.current().nextInt(1, 11);
                    for (int i = 0; i < n; ++i) {
                        string3 = Base64.getEncoder().encodeToString(string3.getBytes());
                    }
                    String string4 = String.valueOf(n).length() + "" + n + string3 + n + "A";
                    if (commandSender instanceof Player) {
                        Player player = (Player)commandSender;
                        player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                        LocalUtils.send(commandSender, "&aRequired data has been sent to console! Share it with the developer.");
                    }
                    LocalUtils.log("&c***************************************************************************");
                    LocalUtils.log("&eRequested data by " + commandSender.getName() + ", share this with the developer:");
                    Bukkit.getServer().getConsoleSender().sendMessage("\u00a7e" + string4);
                    LocalUtils.log("&c***************************************************************************");
                });
                return true;
            }
            if (this.openList.contains(stringArray[0].toLowerCase())) {
                if (stringArray.length >= 2 && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                    object = Bukkit.getPlayer((String)stringArray[1]);
                    if (object == null) {
                        commandSender.sendMessage(this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (this.testServer && !object.getName().equalsIgnoreCase(commandSender.getName()) && !commandSender.isOp()) {
                        LocalUtils.send(commandSender, this.testError.replace("{PLAYER}", commandSender.getName()));
                        return true;
                    }
                    if (!this.plugin.getDataMap().containsKey(object.getUniqueId())) {
                        if (this.plugin.connectionListener.loadingProcess.containsKey(object.getUniqueId())) {
                            LocalUtils.send((CommandSender)object, this.plugin.messages.dataIsLoading);
                            return true;
                        }
                        this.plugin.connectionListener.loadPlayerSync((Player)object);
                        if (!this.plugin.getDataMap().containsKey(object.getUniqueId())) {
                            commandSender.sendMessage(this.plugin.messages.targetNotLoaded);
                            return true;
                        }
                    }
                    PlayerData playerData = this.plugin.getDataMap().get(object.getUniqueId());
                    this.plugin.openTags((Player)object, playerData, 1, null, true);
                } else if (commandSender instanceof Player) {
                    object = (Player)commandSender;
                    if (!this.plugin.getDataMap().containsKey(object.getUniqueId())) {
                        if (this.plugin.connectionListener.loadingProcess.containsKey(object.getUniqueId())) {
                            LocalUtils.send((CommandSender)object, this.plugin.messages.dataIsLoading);
                            return true;
                        }
                        this.plugin.connectionListener.loadPlayerSync((Player)object);
                        if (!this.plugin.getDataMap().containsKey(object.getUniqueId())) {
                            object.sendMessage(this.plugin.messages.pleaseReconnect);
                            return true;
                        }
                    }
                    PlayerData playerData = this.plugin.getDataMap().get(object.getUniqueId());
                    this.plugin.openTags((Player)object, playerData, 1, null, true);
                } else {
                    LocalUtils.send(commandSender, "&cConsole cannot open tags GUI.. Try /alonsotags help");
                }
                return true;
            }
            if (this.setList.contains(stringArray[0].toLowerCase()) && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (stringArray.length >= 3) {
                    object = Bukkit.getPlayer((String)stringArray[1]);
                    if (object == null) {
                        LocalUtils.send(commandSender, this.plugin.messages.invalidTarget);
                        return true;
                    }
                    if (!this.plugin.getDataMap().containsKey(object.getUniqueId())) {
                        LocalUtils.send((CommandSender)object, this.plugin.messages.pleaseReconnect);
                        LocalUtils.send(commandSender, this.plugin.messages.targetNotLoaded);
                        return true;
                    }
                    PlayerData playerData = this.plugin.getDataMap().get(object.getUniqueId());
                    String string2 = stringArray[2].toLowerCase(Locale.ROOT);
                    if (string2.equals("null") || string2.equals("none")) {
                        if (playerData.hasEnabledTag()) {
                            TagSelectEvent tagSelectEvent = new TagSelectEvent((Player)object, playerData.getEnabledTag(), null, TagSelectEvent.Reason.COMMAND, false, null);
                            Bukkit.getPluginManager().callEvent((Event)tagSelectEvent);
                            if (tagSelectEvent.isCancelled()) {
                                return true;
                            }
                            this.plugin.closeIfTagInventory((Player)object);
                            playerData.setEnabledTag(null);
                            playerData.setCurrentTag(null);
                            playerData.setCurrentRecognitionTitle("");
                            playerData.setEnabledColor("default");
                            playerData.setCurrentColor("");
                            playerData.markModified();
                            LocalUtils.send((CommandSender)object, this.plugin.messages.tagCleared);
                            LocalUtils.send(commandSender, this.plugin.messages.setTargetSuccessClear.replace("{TARGET}", object.getName()));
                        } else {
                            LocalUtils.send((CommandSender)object, this.plugin.messages.tagNotSelected);
                            LocalUtils.send(commandSender, this.plugin.messages.setTargetNoTagSelected.replace("{PLAYER}", object.getName()));
                        }
                        return true;
                    }
                    if (this.plugin.getTagsMap().containsKey(string2)) {
                        String string3;
                        String string4;
                        boolean bl = false;
                        boolean bl2 = false;
                        ColorData colorData = null;
                        for (int i = 3; i <= 5 && stringArray.length > i; ++i) {
                            string4 = stringArray[i];
                            if (string4.startsWith("addpurchasedtag=")) {
                                bl = string4.substring(16).equalsIgnoreCase("true");
                                continue;
                            }
                            if (string4.startsWith("free=")) {
                                bl2 = string4.substring(5).equalsIgnoreCase("true");
                                continue;
                            }
                            if (colorData != null) continue;
                            colorData = this.plugin.getColorsMap().get(string4);
                        }
                        TagData tagData = this.plugin.getTagsMap().get(string2);
                        String string5 = tagData.isDyeable() ? (colorData == null ? "default" : colorData.getColorIdentifier()) : (string4 = "default");
                        String string6 = tagData.isDyeable() ? (colorData == null ? "" : colorData.getColor()) : (string3 = "");
                        if (tagData.isPurchasable() && !playerData.getPurchasedTags().contains(tagData.getTagIdentifier())) {
                            void var16_31;
                            void var17_41;
                            Object object4;
                            int n;
                            int n2 = n = bl2 ? 0 : tagData.getPrice();
                            if (n > 0) {
                                if (tagData.getCurrencyManager() == null) {
                                    LocalUtils.send((CommandSender)object, this.plugin.messages.currencyNotAvailable);
                                    object.playSound(object.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                                    return true;
                                }
                                if (!tagData.getCurrencyManager().hasEnough((Player)object, tagData.getPrice())) {
                                    LocalUtils.send((CommandSender)object, tagData.getNotEnoughMoneyMessage().replace("{COST}", String.valueOf(tagData.getPrice())));
                                    object.playSound(object.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                                    return true;
                                }
                                object4 = new TagPurchaseEvent((Player)object, tagData.getTagIdentifier(), n, TagPurchaseEvent.Reason.COMMAND);
                                Bukkit.getPluginManager().callEvent((Event)object4);
                                if (((TagPurchaseEvent)((Object)object4)).isCancelled()) {
                                    return true;
                                }
                                if (!tagData.getCurrencyManager().withdraw((Player)object, tagData.getPrice())) {
                                    LocalUtils.send((CommandSender)object, this.plugin.messages.errorPurchasing);
                                    object.playSound(object.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                                    return true;
                                }
                            }
                            if (bl) {
                                playerData.getPurchasedTags().add(tagData.getTagIdentifier());
                                playerData.markModified();
                                if (!tagData.getPurchaseCommands().isEmpty()) {
                                    for (CommandData object32 : tagData.getPurchaseCommands()) {
                                        object32.performCommand((Player)object);
                                    }
                                }
                            }
                            object4 = new TagSelectEvent((Player)object, playerData.getEnabledTag(), tagData.getTagIdentifier(), TagSelectEvent.Reason.COMMAND, tagData.isDyeable(), string4);
                            Bukkit.getPluginManager().callEvent((Event)object4);
                            if (((TagSelectEvent)((Object)object4)).isCancelled()) {
                                return true;
                            }
                            if (!tagData.getPreSelectCommands().isEmpty()) {
                                for (CommandData commandData : tagData.getPreSelectCommands()) {
                                    commandData.performCommand((Player)object, tagData, tagData.getTag());
                                }
                            }
                            playerData.setEnabledTag(tagData.getTagIdentifier());
                            String string7 = tagData.getTag();
                            String string8 = tagData.getRecognitionTitle();
                            if (colorData == null || colorData.isDefaultColor()) {
                                String string9 = string7.replace("{COLOR}", tagData.getDefaultColor());
                                String string10 = string8.replace("{COLOR}", tagData.getDefaultColor());
                                playerData.setEnabledColor("default");
                                playerData.setCurrentColor(tagData.getDefaultColor());
                            } else {
                                String string11 = string7.replace("{COLOR}", colorData.getColor());
                                String string12 = string8.replace("{COLOR}", colorData.getColor());
                                playerData.setEnabledColor(colorData.getColorIdentifier());
                                playerData.setCurrentColor(colorData.getColor());
                            }
                            playerData.setCurrentRecognitionTitle((String)var17_41);
                            playerData.setCurrentTag((String)var16_31);
                            playerData.markModified();
                            String string13 = playerData.getParsedCurrentTag();
                            LocalUtils.send(commandSender, this.plugin.messages.setTargetSuccess.replace("{PLAYER}", object.getName()));
                            LocalUtils.send((CommandSender)object, this.plugin.messages.tagPurchased.replace("{TAG}", string13).replace("{PRICE}", String.valueOf(n)).replace("{TAG_NAME}", tagData.getTagName()));
                            LocalUtils.send((CommandSender)object, this.plugin.messages.tagSelected.replace("{TAG}", string13));
                            if (!tagData.getPostSelectCommands().isEmpty()) {
                                for (CommandData commandData : tagData.getPostSelectCommands()) {
                                    commandData.performCommand((Player)object, tagData, string13);
                                }
                            }
                        } else {
                            void var16_36;
                            TagSelectEvent tagSelectEvent = new TagSelectEvent((Player)object, playerData.getEnabledTag(), tagData.getTagIdentifier(), TagSelectEvent.Reason.COMMAND, tagData.isDyeable(), string4);
                            Bukkit.getPluginManager().callEvent((Event)tagSelectEvent);
                            if (tagSelectEvent.isCancelled()) {
                                return true;
                            }
                            if (!tagData.getPreSelectCommands().isEmpty()) {
                                for (CommandData commandData : tagData.getPreSelectCommands()) {
                                    commandData.performCommand((Player)object, tagData, tagData.getTag());
                                }
                            }
                            playerData.setEnabledTag(tagData.getTagIdentifier());
                            Object object6 = tagData.getTag();
                            String string14 = tagData.getRecognitionTitle();
                            if (colorData == null || colorData.isDefaultColor()) {
                                object6 = ((String)object6).replace("{COLOR}", tagData.getDefaultColor());
                                String string15 = string14.replace("{COLOR}", tagData.getDefaultColor());
                                playerData.setEnabledColor("default");
                                playerData.setCurrentColor(tagData.getDefaultColor());
                            } else {
                                object6 = ((String)object6).replace("{COLOR}", colorData.getColor());
                                String string16 = string14.replace("{COLOR}", colorData.getColor());
                                playerData.setEnabledColor(colorData.getColorIdentifier());
                                playerData.setCurrentColor(colorData.getColor());
                            }
                            playerData.setCurrentTag((String)object6);
                            playerData.setCurrentRecognitionTitle((String)var16_36);
                            playerData.markModified();
                            LocalUtils.send(commandSender, this.plugin.messages.setTargetSuccess.replace("{PLAYER}", object.getName()));
                            LocalUtils.send((CommandSender)object, this.plugin.messages.tagSelected.replace("{TAG}", playerData.getCurrentTag()));
                            String string17 = playerData.getParsedCurrentTag();
                            if (!tagData.getPostSelectCommands().isEmpty()) {
                                for (CommandData commandData : tagData.getPostSelectCommands()) {
                                    commandData.performCommand((Player)object, tagData, string17);
                                }
                            }
                        }
                    } else {
                        LocalUtils.send(commandSender, this.plugin.messages.setInvalidTag.replace("{TAG}", string2));
                    }
                    return true;
                }
                LocalUtils.send(commandSender, "&cUsage: /alonsotags set <player> <tag-identifier/null> [color-identifier] [addpurchasedtag=false/true] [free=false/true]");
                return true;
            }
            if (this.reloadList.contains(stringArray[0].toLowerCase()) && commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                if (this.testServer && commandSender instanceof Player && !commandSender.isOp()) {
                    LocalUtils.send(commandSender, this.testReloadError.replace("{PLAYER}", commandSender.getName()));
                    return true;
                }
                this.plugin.getFiles().getConfig().reload();
                this.plugin.getFiles().getTags().reload();
                this.plugin.getFiles().getColors().reload();
                this.plugin.permissions.reloadMessages();
                this.plugin.loadBooks();
                this.plugin.messages.reloadMessages();
                this.plugin.reloadMessages();
                this.plugin.clickListener.reloadMessages();
                this.plugin.connectionListener.reloadMessages();
                this.plugin.chatListener.reloadMessages();
                this.plugin.loadTags();
                this.plugin.loadColors();
                commandSender.sendMessage(this.plugin.messages.reloaded);
                return true;
            }
            if (this.supportDeveloper) {
                LocalUtils.send(commandSender, " ");
                LocalUtils.send(commandSender, AlonsoUtils.second + "&l" + "AlonsoTags" + " " + AlonsoUtils.first + "by " + AlonsoUtils.second + "&lAlonsoAliaga " + AlonsoUtils.first + "Version &6" + this.plugin.getDescription().getVersion());
            }
            if (commandSender.hasPermission(this.plugin.permissions.adminPermission)) {
                for (String string9 : this.plugin.messages.adminHelpList) {
                    commandSender.sendMessage(string9);
                }
            } else {
                for (String string10 : this.plugin.messages.userHelpList) {
                    commandSender.sendMessage(string10);
                }
            }
            if (this.supportDeveloper) {
                LocalUtils.send(commandSender, " ");
                if (commandSender instanceof Player) {
                    object = (Player)commandSender;
                    object.playSound(object.getLocation(), Sounds.PICKUP.getSound(), 1.0f, 1.0f);
                }
            }
            return true;
        }
        if (commandSender instanceof Player) {
            object = (Player)commandSender;
            if (!LocalUtils.hasPermission((CommandSender)object, this.plugin.permissions.tagsMenuPermission)) {
                LocalUtils.send(commandSender, this.plugin.messages.tagsMenuNoPermission);
                return true;
            }
            if (!this.plugin.getDataMap().containsKey(object.getUniqueId())) {
                object.sendMessage(this.plugin.messages.pleaseReconnect);
                return true;
            }
            PlayerData playerData = this.plugin.getDataMap().get(object.getUniqueId());
            this.plugin.openTags((Player)object, playerData, 1, null, true);
        } else {
            LocalUtils.send(commandSender, "&cConsole cannot open tags GUI.. Try /alonsotags help");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length >= 1) {
            if (stringArray.length == 1) {
                return commandSender.hasPermission(this.plugin.permissions.adminPermission) ? this.adminList : this.userList;
            }
            if (commandSender.hasPermission(this.plugin.permissions.adminPermission) && this.adminList.contains(stringArray[0].toLowerCase())) {
                if (this.reloadList.contains(stringArray[0].toLowerCase(Locale.ROOT))) {
                    return this.emptyList;
                }
                if (this.setList.contains(stringArray[0].toLowerCase(Locale.ROOT))) {
                    if (stringArray.length == 2) {
                        return this.onlinePlayers(commandSender, stringArray);
                    }
                    if (stringArray.length == 3) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add("null");
                        arrayList.addAll(this.plugin.getTagsMap().keySet());
                        return arrayList;
                    }
                    if (stringArray.length == 4 || stringArray.length == 5 || stringArray.length == 6) {
                        ArrayList<String> arrayList = new ArrayList<String>(this.plugin.getColorsMap().keySet());
                        arrayList.add("addpurchasedtag=true");
                        arrayList.add("addpurchasedtag=false");
                        arrayList.add("free=true");
                        arrayList.add("free=false");
                        return arrayList;
                    }
                    return this.emptyList;
                }
            }
        }
        return this.onlinePlayers(commandSender, stringArray);
    }
}

