/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.economy;

import com.alonsoaliaga.alonsotags.economy.CurrencyManager;
import com.alonsoaliaga.alonsotags.enums.CostType;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class VaultHook
implements CurrencyManager {
    private Economy economy;

    public VaultHook(Economy economy) {
        this.economy = economy;
    }

    @Override
    public boolean hasEnough(Player player, int n) {
        return this.economy.has((OfflinePlayer)player, (double)n);
    }

    @Override
    public boolean hasEnough(Player player, double d) {
        return this.economy.has((OfflinePlayer)player, d);
    }

    @Override
    public boolean hasEnough(UUID uUID, double d) {
        return this.economy.has((OfflinePlayer)Bukkit.getPlayer((UUID)uUID), d);
    }

    @Override
    public boolean withdraw(Player player, int n) {
        return this.economy.withdrawPlayer((OfflinePlayer)player, (double)n).transactionSuccess();
    }

    @Override
    public boolean withdraw(Player player, double d) {
        return this.economy.withdrawPlayer((OfflinePlayer)player, d).transactionSuccess();
    }

    @Override
    public boolean withdraw(UUID uUID, double d) {
        return this.economy.withdrawPlayer((OfflinePlayer)Bukkit.getPlayer((UUID)uUID), d).transactionSuccess();
    }

    @Override
    public boolean add(Player player, int n) {
        return this.economy.depositPlayer((OfflinePlayer)player, (double)n).transactionSuccess();
    }

    @Override
    public boolean add(Player player, double d) {
        return this.economy.depositPlayer((OfflinePlayer)player, d).transactionSuccess();
    }

    @Override
    public boolean add(UUID uUID, double d) {
        return this.economy.depositPlayer((OfflinePlayer)Bukkit.getPlayer((UUID)uUID), d).transactionSuccess();
    }

    @Override
    public CostType getType() {
        return CostType.VAULT;
    }
}

