/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.libraries.hikari.metrics;

import com.alonsoaliaga.alonsotags.libraries.hikari.util.ClockSource;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PoolStats {
    private final AtomicLong reloadAt;
    private final long timeoutMs;
    protected volatile int totalConnections;
    protected volatile int idleConnections;
    protected volatile int activeConnections;
    protected volatile int pendingThreads;
    protected volatile int maxConnections;
    protected volatile int minConnections;

    public PoolStats(long l) {
        this.timeoutMs = l;
        this.reloadAt = new AtomicLong();
    }

    public int getTotalConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.totalConnections;
    }

    public int getIdleConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.idleConnections;
    }

    public int getActiveConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.activeConnections;
    }

    public int getPendingThreads() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.pendingThreads;
    }

    public int getMaxConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.maxConnections;
    }

    public int getMinConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.minConnections;
    }

    protected abstract void update();

    private boolean shouldLoad() {
        long l;
        long l2;
        do {
            l = ClockSource.currentTime();
            l2 = this.reloadAt.get();
            if (l2 <= l) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(l2, ClockSource.plusMillis(l, this.timeoutMs)));
        return true;
    }
}

