/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.others;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.enums.CommandType;
import com.alonsoaliaga.alonsotags.others.Sounds;
import com.alonsoaliaga.alonsotags.others.TagData;
import com.alonsoaliaga.alonsotags.utils.AlonsoUtils;
import com.alonsoaliaga.alonsotags.utils.BungeeUtils;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import com.alonsoaliaga.alonsotags.utils.ProtocolLibUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTContainer;
import de.tr7zw.nbtapi.NBTItem;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommandData {
    private AlonsoTags plugin = AlonsoTags.getInstance();
    private String command;
    private String title = "";
    private String subtitle = "";
    private CommandType commandType;
    private Sound sound = null;
    private List<FireworkEffect> fireWorkEffects = new ArrayList<FireworkEffect>();
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private CommandType.ConnectionType connectionType;
    private String bookData = null;
    private int power = 1;
    private int delay = 5;
    private String customSound = null;
    private SoundCategory soundCategory;
    private boolean soundCategorySpecified = false;

    public CommandData(String string, CommandType commandType, CommandType.ConnectionType connectionType) {
        this.command = string.trim();
        this.commandType = commandType == null ? CommandType.PLAYER : commandType;
        this.connectionType = connectionType;
        if (this.process()) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("Successfully loaded command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
            }
        } else if (this.plugin.debugMode) {
            LocalUtils.logp("Couldn't load command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
        }
    }

    private boolean process() {
        if (this.commandType == CommandType.SOUND_BROADCAST || this.commandType == CommandType.SOUND || this.commandType == CommandType.SOUND_WORLD_BROADCAST) {
            String[] stringArray = this.command.split(",");
            this.sound = LocalUtils.getSound(stringArray[0].trim(), Sounds.LEVEL_UP.getSound());
            if (stringArray.length >= 2) {
                try {
                    this.volume = Float.parseFloat(stringArray[1].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (stringArray.length >= 3) {
                    try {
                        this.pitch = Float.parseFloat(stringArray[2].trim());
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else if (this.commandType == CommandType.CUSTOM_SOUND_BROADCAST || this.commandType == CommandType.CUSTOM_SOUND || this.commandType == CommandType.CUSTOM_SOUND_WORLD_BROADCAST) {
            String[] stringArray = this.command.split(",");
            this.customSound = stringArray[0];
            if (stringArray.length >= 2) {
                try {
                    this.volume = Float.parseFloat(stringArray[1].trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (stringArray.length >= 3) {
                    try {
                        this.pitch = Float.parseFloat(stringArray[2].trim());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (stringArray.length >= 4 && LocalUtils.isSoundCategoryAvailable()) {
                        try {
                            this.soundCategory = SoundCategory.valueOf((String)stringArray[3]);
                            this.soundCategorySpecified = true;
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        } else if (this.commandType == CommandType.TITLE || this.commandType == CommandType.TITLE_BROADCAST || this.commandType == CommandType.TITLE_WORLD_BROADCAST) {
            String[] stringArray = this.command.split("(?i)<SEPARATOR>");
            this.title = stringArray[0];
            if (stringArray.length >= 2) {
                this.subtitle = stringArray[1];
            }
        } else {
            if (this.commandType == CommandType.BOOK) {
                this.bookData = this.plugin.booksMap.get(this.command.toLowerCase().replace(".txt", ""));
                return this.bookData != null;
            }
            if (this.commandType == CommandType.FIREWORK) {
                String[] stringArray;
                for (String string : stringArray = this.command.split("\\|")) {
                    if (string.matches("(?i)^power=\\d+$")) {
                        try {
                            this.power = Math.max(0, Math.min(20, Integer.valueOf(string.replaceAll("(?i)^power=\\d+$", ""))));
                        }
                        catch (Throwable throwable) {
                            this.power = 1;
                        }
                        continue;
                    }
                    if (string.matches("(?i)^delay=\\d+$")) {
                        try {
                            this.delay = Math.max(0, Math.min(100, Integer.valueOf(string.replaceAll("(?i)^delay=\\d+$", ""))));
                        }
                        catch (Throwable throwable) {
                            this.delay = 1;
                        }
                        continue;
                    }
                    FireworkEffect.Builder builder = FireworkEffect.builder();
                    FireworkEffect.Type type = null;
                    Color color = null;
                    Color color2 = null;
                    boolean bl = false;
                    boolean bl2 = false;
                    String[] stringArray2 = string.split(":");
                    if (stringArray2.length >= 1) {
                        try {
                            type = FireworkEffect.Type.valueOf((String)stringArray2[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (stringArray2.length >= 2) {
                            color = LocalUtils.getColor(stringArray2[1]);
                            if (stringArray2.length >= 3) {
                                try {
                                    color2 = LocalUtils.getColor(stringArray2[2]);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (stringArray2.length >= 4) {
                                    boolean bl3 = bl = stringArray2[3].equalsIgnoreCase("true") || stringArray2[3].equalsIgnoreCase("yes") || stringArray2[3].equalsIgnoreCase("flicker");
                                    if (stringArray2.length >= 5) {
                                        boolean bl4 = bl2 = stringArray2[4].equalsIgnoreCase("true") || stringArray2[4].equalsIgnoreCase("yes") || stringArray2[4].equalsIgnoreCase("trail");
                                    }
                                }
                            }
                        }
                    }
                    if (type != null) {
                        builder.with(type);
                    } else {
                        builder.with(FireworkEffect.Type.CREEPER);
                    }
                    if (color != null) {
                        builder.withColor(color);
                    } else {
                        builder.withColor(Color.WHITE);
                    }
                    if (color2 != null) {
                        builder.withFade(color2);
                    } else {
                        builder.withFade(Color.WHITE);
                    }
                    builder.flicker(bl).trail(bl2);
                    this.fireWorkEffects.add(builder.build());
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("Type: " + (type == null ? type : type.name()) + " | Color: " + (color == null ? color : Integer.valueOf(color.asRGB())) + " | Fade color:" + (color2 == null ? color2 : color2.asRGB() + " | Flicker: " + bl + " | Trail: " + bl2));
                    }
                    if (!this.plugin.debugMode) continue;
                    LocalUtils.logp("Successfully built firework(" + builder.build().toString() + ").");
                }
                LocalUtils.logp("Successfully loaded " + this.fireWorkEffects.size() + " effects for fireworks!");
            }
        }
        return true;
    }

    public CommandData(String string) {
        this.command = string.trim();
        this.connectionType = CommandType.ConnectionType.getFromCommand(this.command);
        this.command = this.connectionType == null ? this.command : this.command.substring(this.connectionType.getToRemove().length());
        this.connectionType = this.connectionType == null ? CommandType.ConnectionType.NORMAL : this.connectionType;
        this.commandType = CommandType.getFromCommand(this.command);
        this.command = this.commandType == null ? this.command : this.command.substring(this.commandType.getToRemove().length());
        CommandType commandType = this.commandType = this.commandType == null ? CommandType.PLAYER : this.commandType;
        if (this.process()) {
            if (this.plugin.debugMode) {
                LocalUtils.logp("Successfully loaded command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
            }
        } else if (this.plugin.debugMode) {
            LocalUtils.logp("Couldn't load command '" + this.command + "&r&7' with type '" + this.commandType.name() + "'!");
        }
    }

    public void performCommand(@Nonnull Player player) {
        this.performCommand(player, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public void performCommand(@Nonnull Player var1_1, TagData var2_2, String var3_3) {
        if (var1_1.hasPlayedBefore() != false ? this.connectionType == CommandType.ConnectionType.FIRST_JOIN : this.connectionType == CommandType.ConnectionType.KNOWN_PLAYER) {
            return;
        }
        switch (1.$SwitchMap$com$alonsoaliaga$alonsotags$enums$CommandType[this.commandType.ordinal()]) {
            case 1: {
                var1_1.performCommand(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 2: {
                var4_4 = this.setPlaceholders(var1_1, this.command, var2_2, var3_3);
                if (var1_1.isOp()) {
                    var1_1.performCommand(var4_4);
                    break;
                }
                var1_1.setOp(true);
                try {
                    var1_1.performCommand(var4_4);
                    var1_1.setOp(false);
                }
                catch (Throwable var5_18) {
                    var1_1.setOp(false);
                    LocalUtils.logp("Error running '" + var4_4 + "' as OP! Removing OP..");
                    var5_18.printStackTrace();
                }
                break;
            }
            case 3: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 4: {
                var1_1.sendMessage(LocalUtils.colorize(this.setPlaceholders(var1_1, this.command, var2_2, var3_3)));
                break;
            }
            case 5: {
                var1_1.chat(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 6: {
                Bukkit.broadcastMessage((String)LocalUtils.colorize(this.setPlaceholders(var1_1, this.command, var2_2, var3_3)));
                break;
            }
            case 7: {
                var4_5 = LocalUtils.colorize(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                for (Player var6_31 : var1_1.getWorld().getPlayers()) {
                    var6_31.sendMessage(var4_5);
                }
                break;
            }
            case 8: {
                var1_1.playSound(var1_1.getLocation(), this.sound, this.volume, this.pitch);
                break;
            }
            case 9: {
                for (Player var5_20 : Bukkit.getOnlinePlayers()) {
                    var5_20.playSound(var5_20.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case 10: {
                for (Player var5_21 : var1_1.getWorld().getPlayers()) {
                    var5_21.playSound(var5_21.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case 11: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    var1_1.playSound(var1_1.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    break;
                }
                var1_1.playSound(var1_1.getLocation(), this.customSound, this.volume, this.pitch);
                break;
            }
            case 12: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    for (Player var5_22 : Bukkit.getOnlinePlayers()) {
                        var5_22.playSound(var5_22.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    }
                } else {
                    for (Player var5_23 : Bukkit.getOnlinePlayers()) {
                        var5_23.playSound(var5_23.getLocation(), this.customSound, this.volume, this.pitch);
                    }
                }
                break;
            }
            case 13: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    for (Player var5_24 : var1_1.getWorld().getPlayers()) {
                        var5_24.playSound(var5_24.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    }
                } else {
                    for (Player var5_25 : var1_1.getWorld().getPlayers()) {
                        var5_25.playSound(var5_25.getLocation(), this.customSound, this.volume, this.pitch);
                    }
                }
                break;
            }
            case 14: {
                LocalUtils.sendTitle(var1_1, this.setPlaceholders(var1_1, this.title, var2_2, var3_3), this.setPlaceholders(var1_1, this.subtitle, var2_2, var3_3));
                break;
            }
            case 15: {
                LocalUtils.sendTitle(Bukkit.getOnlinePlayers(), this.setPlaceholders(var1_1, this.title, var2_2, var3_3), this.setPlaceholders(var1_1, this.subtitle, var2_2, var3_3));
                break;
            }
            case 16: {
                LocalUtils.sendTitle(var1_1.getWorld().getPlayers(), this.setPlaceholders(var1_1, this.title, var2_2, var3_3), this.setPlaceholders(var1_1, this.subtitle, var2_2, var3_3));
                break;
            }
            case 17: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                var4_12 = new ByteArrayOutputStream();
                var5_26 = new DataOutputStream(var4_12);
                try {
                    var5_26.writeUTF("AlonsoTags");
                    var5_26.writeUTF("BUNGEE_CONSOLE");
                    var5_26.writeUTF(var1_1.getName());
                    var5_26.writeUTF(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                }
                catch (IOException var6_32) {
                    if (!this.plugin.debugMode) ** GOTO lbl109
                    LocalUtils.logp("Error writing UTF for BUNGEE_CONSOLE. Debug mode is enabled: " + var6_32.getMessage());
                }
lbl109:
                // 3 sources

                BungeeUtils.sendBungeeMessage(var1_1, var4_12.toByteArray());
                break;
            }
            case 18: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                var4_13 = new ByteArrayOutputStream();
                var5_27 = new DataOutputStream(var4_13);
                try {
                    var5_27.writeUTF("AlonsoTags");
                    var5_27.writeUTF("BUNGEE_PLAYER_CHAT");
                    var5_27.writeUTF(var1_1.getName());
                    var5_27.writeUTF(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                }
                catch (IOException var6_33) {
                    if (!this.plugin.debugMode) ** GOTO lbl127
                    LocalUtils.logp("Error writing UTF for BUNGEE_PLAYER_CHAT. Debug mode is enabled: " + var6_33.getMessage());
                }
lbl127:
                // 3 sources

                BungeeUtils.sendBungeeMessage(var1_1, var4_13.toByteArray());
                break;
            }
            case 19: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                var4_14 = new ByteArrayOutputStream();
                var5_28 = new DataOutputStream(var4_14);
                try {
                    var5_28.writeUTF("AlonsoTags");
                    var5_28.writeUTF("BUNGEE_PLAYER_COMMAND");
                    var5_28.writeUTF(var1_1.getName());
                    var5_28.writeUTF(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                }
                catch (IOException var6_34) {
                    if (!this.plugin.debugMode) ** GOTO lbl145
                    LocalUtils.logp("Error writing UTF for BUNGEE_PLAYER_COMMAND. Debug mode is enabled: " + var6_34.getMessage());
                }
lbl145:
                // 3 sources

                BungeeUtils.sendBungeeMessage(var1_1, var4_14.toByteArray());
                break;
            }
            case 20: {
                LocalUtils.sendActionBar((AlonsoUtils.AlonsoPlugin)this.plugin, var1_1, this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 21: {
                LocalUtils.sendActionBar(this.plugin, Bukkit.getOnlinePlayers(), this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 22: {
                LocalUtils.sendActionBar(this.plugin, var1_1.getWorld().getPlayers(), this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 23: {
                var4_15 = (Firework)var1_1.getWorld().spawn(var1_1.getLocation().add(0.0, 1.0, 0.0), Firework.class);
                var5_29 = var4_15.getFireworkMeta();
                var5_29.addEffects(this.fireWorkEffects);
                var4_15.setFireworkMeta(var5_29);
                var5_29.setPower(this.power);
                if (this.delay == 0) {
                    var4_15.detonate();
                    break;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performCommand$0(org.bukkit.entity.Firework ), ()V)((Firework)var4_15), (long)this.delay);
                break;
            }
            case 24: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(var1_1, this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 25: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 26: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(var1_1.getWorld().getPlayers(), this.setPlaceholders(var1_1, this.command, var2_2, var3_3));
                break;
            }
            case 27: {
                if (!AlonsoUtils.PluginUtils.hasNbtApiSupport() || this.bookData == null) break;
                try {
                    var4_16 = new ItemStack(Material.WRITTEN_BOOK);
                    var5_30 = new NBTItem(var4_16, true);
                    var5_30.mergeCompound((NBTCompound)new NBTContainer(this.setPlaceholders(var1_1, this.bookData, var2_2, var3_3)));
                    if (LocalUtils.openBook(var1_1, var4_16)) break;
                    LocalUtils.logp("Custom book couldn't be sent, make sure you have required dependencies. Join our discord server for support!");
                    break;
                }
                catch (Throwable var4_17) {
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("Error creating custom book! You are reading the next stacktrace because debug mode is enabled.");
                        var4_17.printStackTrace();
                        break;
                    }
                    LocalUtils.logp("Error creating custom book! Error: " + var4_17.getMessage());
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void performCommand(@Nonnull Player var1_1, HashMap<String, String> var2_2) {
        if (var1_1.hasPlayedBefore() != false ? this.connectionType == CommandType.ConnectionType.FIRST_JOIN : this.connectionType == CommandType.ConnectionType.KNOWN_PLAYER) {
            return;
        }
        switch (1.$SwitchMap$com$alonsoaliaga$alonsotags$enums$CommandType[this.commandType.ordinal()]) {
            case 1: {
                var1_1.performCommand(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 2: {
                var3_3 = LocalUtils.setPlaceholders(var1_1, this.command, var2_2);
                if (var1_1.isOp()) {
                    var1_1.performCommand(var3_3);
                    break;
                }
                var1_1.setOp(true);
                try {
                    var1_1.performCommand(var3_3);
                    var1_1.setOp(false);
                }
                catch (Throwable var4_17) {
                    var1_1.setOp(false);
                    LocalUtils.logp("Error running '" + var3_3 + "' as OP! Removing OP..");
                    var4_17.printStackTrace();
                }
                break;
            }
            case 3: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 4: {
                var1_1.sendMessage(LocalUtils.colorize(LocalUtils.setPlaceholders(var1_1, this.command, var2_2)));
                break;
            }
            case 5: {
                var1_1.chat(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 6: {
                Bukkit.broadcastMessage((String)LocalUtils.colorize(LocalUtils.setPlaceholders(var1_1, this.command, var2_2)));
                break;
            }
            case 7: {
                var3_4 = LocalUtils.colorize(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                for (Player var5_30 : var1_1.getWorld().getPlayers()) {
                    var5_30.sendMessage(var3_4);
                }
                break;
            }
            case 8: {
                var1_1.playSound(var1_1.getLocation(), this.sound, this.volume, this.pitch);
                break;
            }
            case 9: {
                for (Player var4_19 : Bukkit.getOnlinePlayers()) {
                    var4_19.playSound(var4_19.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case 10: {
                for (Player var4_20 : var1_1.getWorld().getPlayers()) {
                    var4_20.playSound(var4_20.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case 11: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    var1_1.playSound(var1_1.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    break;
                }
                var1_1.playSound(var1_1.getLocation(), this.customSound, this.volume, this.pitch);
                break;
            }
            case 12: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    for (Player var4_21 : Bukkit.getOnlinePlayers()) {
                        var4_21.playSound(var4_21.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    }
                } else {
                    for (Player var4_22 : Bukkit.getOnlinePlayers()) {
                        var4_22.playSound(var4_22.getLocation(), this.customSound, this.volume, this.pitch);
                    }
                }
                break;
            }
            case 13: {
                if (LocalUtils.isSoundCategoryAvailable() && this.soundCategorySpecified) {
                    for (Player var4_23 : var1_1.getWorld().getPlayers()) {
                        var4_23.playSound(var4_23.getLocation(), this.customSound, this.soundCategory, this.volume, this.pitch);
                    }
                } else {
                    for (Player var4_24 : var1_1.getWorld().getPlayers()) {
                        var4_24.playSound(var4_24.getLocation(), this.customSound, this.volume, this.pitch);
                    }
                }
                break;
            }
            case 17: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                var3_11 = new ByteArrayOutputStream();
                var4_25 = new DataOutputStream(var3_11);
                try {
                    var4_25.writeUTF("AlonsoTags");
                    var4_25.writeUTF("BUNGEE_CONSOLE");
                    var4_25.writeUTF(var1_1.getName());
                    var4_25.writeUTF(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                }
                catch (IOException var5_31) {
                    if (!this.plugin.debugMode) ** GOTO lbl100
                    LocalUtils.logp("Error writing UTF for BUNGEE_CONSOLE. Debug mode is enabled: " + var5_31.getMessage());
                }
lbl100:
                // 3 sources

                BungeeUtils.sendBungeeMessage(var1_1, var3_11.toByteArray());
                break;
            }
            case 18: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                var3_12 = new ByteArrayOutputStream();
                var4_26 = new DataOutputStream(var3_12);
                try {
                    var4_26.writeUTF("AlonsoTags");
                    var4_26.writeUTF("BUNGEE_PLAYER_CHAT");
                    var4_26.writeUTF(var1_1.getName());
                    var4_26.writeUTF(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                }
                catch (IOException var5_32) {
                    if (!this.plugin.debugMode) ** GOTO lbl118
                    LocalUtils.logp("Error writing UTF for BUNGEE_PLAYER_CHAT. Debug mode is enabled: " + var5_32.getMessage());
                }
lbl118:
                // 3 sources

                BungeeUtils.sendBungeeMessage(var1_1, var3_12.toByteArray());
                break;
            }
            case 19: {
                if (!BungeeUtils.isAvailable()) {
                    if (!this.plugin.debugMode) break;
                    LocalUtils.logp("Bungee message system is not available. Ignoring..");
                    break;
                }
                var3_13 = new ByteArrayOutputStream();
                var4_27 = new DataOutputStream(var3_13);
                try {
                    var4_27.writeUTF("AlonsoTags");
                    var4_27.writeUTF("BUNGEE_PLAYER_COMMAND");
                    var4_27.writeUTF(var1_1.getName());
                    var4_27.writeUTF(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                }
                catch (IOException var5_33) {
                    if (!this.plugin.debugMode) ** GOTO lbl136
                    LocalUtils.logp("Error writing UTF for BUNGEE_PLAYER_COMMAND. Debug mode is enabled: " + var5_33.getMessage());
                }
lbl136:
                // 3 sources

                BungeeUtils.sendBungeeMessage(var1_1, var3_13.toByteArray());
                break;
            }
            case 14: {
                LocalUtils.sendTitle(var1_1, LocalUtils.setPlaceholders(var1_1, this.title, var2_2), LocalUtils.setPlaceholders(var1_1, this.subtitle, var2_2));
                break;
            }
            case 15: {
                LocalUtils.sendTitle(Bukkit.getOnlinePlayers(), LocalUtils.setPlaceholders(var1_1, this.title, var2_2), LocalUtils.setPlaceholders(var1_1, this.subtitle, var2_2));
                break;
            }
            case 16: {
                LocalUtils.sendTitle(var1_1.getWorld().getPlayers(), LocalUtils.setPlaceholders(var1_1, this.title, var2_2), LocalUtils.setPlaceholders(var1_1, this.subtitle, var2_2));
                break;
            }
            case 20: {
                LocalUtils.sendActionBar((AlonsoUtils.AlonsoPlugin)this.plugin, var1_1, LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 21: {
                LocalUtils.sendActionBar(this.plugin, Bukkit.getOnlinePlayers(), LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 22: {
                LocalUtils.sendActionBar(this.plugin, var1_1.getWorld().getPlayers(), LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 23: {
                var3_14 = (Firework)var1_1.getWorld().spawn(var1_1.getLocation().add(0.0, 1.0, 0.0), Firework.class);
                var4_28 = var3_14.getFireworkMeta();
                var4_28.addEffects(this.fireWorkEffects);
                var3_14.setFireworkMeta(var4_28);
                var4_28.setPower(this.power);
                if (this.delay == 0) {
                    var3_14.detonate();
                    break;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performCommand$1(org.bukkit.entity.Firework ), ()V)((Firework)var3_14), (long)this.delay);
                break;
            }
            case 24: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(var1_1, LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 25: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 26: {
                if (this.plugin.debugMode) {
                    LocalUtils.logp("ProtocolLib is supported: " + AlonsoUtils.PluginUtils.hasProtocolLibSupport());
                }
                if (!AlonsoUtils.PluginUtils.hasProtocolLibSupport()) break;
                ProtocolLibUtils.sendJSON(var1_1.getWorld().getPlayers(), LocalUtils.setPlaceholders(var1_1, this.command, var2_2));
                break;
            }
            case 27: {
                if (!AlonsoUtils.PluginUtils.hasNbtApiSupport() || this.bookData == null) break;
                try {
                    var3_15 = new ItemStack(Material.WRITTEN_BOOK);
                    var4_29 = new NBTItem(var3_15, true);
                    var4_29.mergeCompound((NBTCompound)new NBTContainer(LocalUtils.setPlaceholders(var1_1, this.bookData, var2_2)));
                    if (LocalUtils.openBook(var1_1, var3_15)) break;
                    LocalUtils.logp("Custom book couldn't be sent, make sure you have required dependencies. Join our discord server for support!");
                    break;
                }
                catch (Throwable var3_16) {
                    if (this.plugin.debugMode) {
                        LocalUtils.logp("Error creating custom book! You are reading the next stacktrace because debug mode is enabled.");
                        var3_16.printStackTrace();
                        break;
                    }
                    LocalUtils.logp("Error creating custom book! Error: " + var3_16.getMessage());
                }
            }
        }
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public CommandType.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    private String setPlaceholders(Player player, String string, @Nullable TagData tagData, @Nullable String string2) {
        String string3 = player.getName();
        String string4 = player.getWorld().getName();
        String string5 = player.getWorld().getUID().toString();
        String string6 = String.valueOf(player.getLocation().getBlockX());
        String string7 = String.valueOf(player.getLocation().getBlockY());
        String string8 = String.valueOf(player.getLocation().getBlockZ());
        String string9 = player.getUniqueId().toString();
        if (tagData != null) {
            string = string.replace("{TAG_IDENTIFIER}", tagData.getTagIdentifier()).replace("{TAG_NAME}", tagData.getTagName());
        }
        if (string2 != null) {
            string = string.replace("{FINAL_TAG}", string2);
        }
        string = string.replace("{PLAYER}", string3).replace("{UUID}", string9).replace("{WORLD}", string4).replace("{WORLD_UUID}", string5).replace("{X}", string6).replace("{Y}", string7).replace("{Z}", string8);
        return AlonsoUtils.PluginUtils.hasPlaceholderApiSupport() ? PlaceholderAPI.setPlaceholders((Player)player, (String)string) : string;
    }

    private static /* synthetic */ void lambda$performCommand$1(Firework firework) {
        if (!firework.isDead() && firework.isValid()) {
            firework.detonate();
        }
    }

    private static /* synthetic */ void lambda$performCommand$0(Firework firework) {
        if (!firework.isDead() && firework.isValid()) {
            firework.detonate();
        }
    }
}

