/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsotags.utils;

import com.alonsoaliaga.alonsotags.AlonsoTags;
import com.alonsoaliaga.alonsotags.utils.LocalUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTListCompound;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class ItemUtils {
    private static ItemStack headItemSample;
    private static boolean gameProfileSupport;
    private static boolean setOwningPlayerSupport;
    private static boolean oldItemStackSupport;
    private static boolean setOwnerProfileSupport;
    private static boolean gameProfileNoneNullRequired;
    private static boolean nbtAPISupport;
    public static Constructor<?> CONSTRUCTOR_ITEM_STACK_OLD;
    public static Field PROFILE_FIELD;
    public static Method METHOD_SET_OWNER;
    private static String headPluginName;
    private static boolean newSetUnbreakableMethod;
    private static boolean newIsUnbreakableMethod;
    private static boolean getOfflinePlayerByNameSupport;
    private static boolean setUnbreakableSupport;
    private static boolean isUnbreakableSupport;
    private static boolean damageableSupport;
    private static boolean setDurabilityItemStackSupport;
    private static boolean getDurabilityItemStackSupport;
    public static Method METHOD_SET_UNBREAKABLE_OLD;
    public static Method METHOD_IS_UNBREAKABLE_OLD;
    public static Method METHOD_ITEM_META_SPIGOT;
    public static Method SET_DURABILITY_ITEM_STACK_METHOD;
    public static Method GET_DURABILITY_ITEM_STACK_METHOD;

    public static SkullMeta setOwnerPlayer(SkullMeta skullMeta, UUID uUID, String string) {
        if (setOwningPlayerSupport) {
            skullMeta.setOwningPlayer(uUID == null ? Bukkit.getOfflinePlayer((String)string) : Bukkit.getOfflinePlayer((UUID)uUID));
        } else if (METHOD_SET_OWNER != null) {
            try {
                METHOD_SET_OWNER.invoke((Object)skullMeta, string);
            }
            catch (Throwable throwable) {
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("SkullMeta#setOwner failed using reflections. Stacktrace is because debug mode is enabled!");
                    throwable.printStackTrace();
                }
                LocalUtils.logp("SkullMeta#setOwner failed using reflections: " + throwable.getMessage());
            }
        }
        return skullMeta;
    }

    public static ItemStack getHeadBase() {
        return headItemSample.clone();
    }

    public static ItemStack buildHead(String string, UUID uUID) {
        return ItemUtils.buildHead(null, null, string, uUID);
    }

    public static ItemStack buildHead(String string) {
        return ItemUtils.buildHead(string, UUID.randomUUID());
    }

    public static ItemStack buildHead(String string, List<String> list, String string2) {
        return ItemUtils.buildHead(string, list, string2, UUID.randomUUID());
    }

    public static ItemStack addTexture(ItemStack itemStack, String string, UUID uUID) {
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (setOwnerProfileSupport) {
            block10: {
                try {
                    PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)uUID, (String)headPluginName);
                    String string2 = ItemUtils.getTextureUrl(string);
                    if (string2 != null) {
                        playerProfile.getTextures().setSkin(new URL(string2));
                        skullMeta.setOwnerProfile(playerProfile);
                    } else if (AlonsoTags.getInstance().debugMode) {
                        LocalUtils.logp("Provided texture for custom head is not valid!");
                    }
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block10;
                    LocalUtils.logp("Error calling SkullMeta#setOwnerProfile. This is a debug message!");
                    throwable.printStackTrace();
                    LocalUtils.logp("Stacktrace above is because debug mode is enabled!");
                }
            }
            itemStack.setItemMeta((ItemMeta)skullMeta);
            return itemStack;
        }
        if (PROFILE_FIELD != null) {
            block11: {
                try {
                    GameProfile gameProfile = new GameProfile(uUID, headPluginName);
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
                    PROFILE_FIELD.set(skullMeta, gameProfile);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block11;
                    LocalUtils.logp("Error calling reflections for 'profile' field. This is a debug message!");
                    throwable.printStackTrace();
                    LocalUtils.logp("Stacktrace above is because debug mode is enabled!");
                }
            }
            itemStack.setItemMeta((ItemMeta)skullMeta);
            itemStack = ItemStack.deserialize((Map)itemStack.serialize());
            return itemStack;
        }
        if (nbtAPISupport) {
            NBTItem nBTItem = new NBTItem(itemStack);
            NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
            LocalUtils.setUUID(nBTCompound, "Id", uUID);
            NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
            nBTListCompound.setString("Value", string);
            return nBTItem.getItem();
        }
        return itemStack;
    }

    public static ItemStack buildHead(String string, List<String> list, String string2, UUID uUID) {
        ItemStack itemStack = headItemSample.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (string != null) {
            itemMeta.setDisplayName(LocalUtils.colorize(string));
        }
        if (list != null && !list.isEmpty()) {
            itemMeta.setLore(LocalUtils.colorize(list));
        }
        itemStack.setItemMeta(itemMeta);
        if (string2.isEmpty()) {
            return itemStack;
        }
        if (setOwnerProfileSupport) {
            SkullMeta skullMeta;
            block13: {
                skullMeta = (SkullMeta)itemStack.getItemMeta();
                try {
                    PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)uUID, (String)headPluginName);
                    String string3 = ItemUtils.getTextureUrl(string2);
                    if (string3 != null) {
                        playerProfile.getTextures().setSkin(new URL(string3));
                        skullMeta.setOwnerProfile(playerProfile);
                    } else if (AlonsoTags.getInstance().debugMode) {
                        LocalUtils.logp("Provided texture for custom head is not valid!");
                    }
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block13;
                    LocalUtils.logp("Error calling SkullMeta#setOwnerProfile. This is a debug message!");
                    throwable.printStackTrace();
                    LocalUtils.logp("Stacktrace above is because debug mode is enabled!");
                }
            }
            itemStack.setItemMeta((ItemMeta)skullMeta);
            return itemStack;
        }
        if (PROFILE_FIELD != null) {
            SkullMeta skullMeta;
            block14: {
                skullMeta = (SkullMeta)itemStack.getItemMeta();
                try {
                    GameProfile gameProfile = new GameProfile(uUID, headPluginName);
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string2));
                    PROFILE_FIELD.set(skullMeta, gameProfile);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block14;
                    LocalUtils.logp("Error calling reflections for 'profile' field. This is a debug message!");
                    throwable.printStackTrace();
                    LocalUtils.logp("Stacktrace above is because debug mode is enabled!");
                }
            }
            itemStack.setItemMeta((ItemMeta)skullMeta);
            itemStack = ItemStack.deserialize((Map)itemStack.serialize());
            return itemStack;
        }
        if (nbtAPISupport) {
            NBTItem nBTItem = new NBTItem(itemStack);
            NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
            LocalUtils.setUUID(nBTCompound, "Id", uUID);
            NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
            nBTListCompound.setString("Value", string2);
            return nBTItem.getItem();
        }
        return itemStack;
    }

    public static boolean isCustomHeadSupported() {
        return setOwnerProfileSupport || gameProfileSupport || nbtAPISupport;
    }

    public static ItemStack createDurabilityItem(Material material, int n, boolean bl) {
        if (oldItemStackSupport) {
            try {
                return (ItemStack)CONSTRUCTOR_ITEM_STACK_OLD.newInstance(material, 1, (short)n);
            }
            catch (Throwable throwable) {
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.loge("Error creating new instance for ItemStack using reflections..");
                    throwable.printStackTrace();
                }
                return new ItemStack(material);
            }
        }
        if (bl) {
            ItemStack itemStack = new ItemStack(material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof Damageable) {
                ((Damageable)itemMeta).setDamage(n);
                itemStack.setItemMeta(itemMeta);
            }
            return itemStack;
        }
        return new ItemStack(material);
    }

    public static String getTextureUrl(String string) {
        if (string.startsWith("http://textures.minecraft.net/texture/") || string.startsWith("https://textures.minecraft.net/texture/")) {
            return string;
        }
        try {
            String string2;
            int n;
            String string3 = new String(Base64.getDecoder().decode(string));
            int n2 = string3.indexOf("http://textures.minecraft.net/texture/");
            if (n2 != -1 && (n = (string2 = string3.substring(n2)).indexOf("\"")) != -1) {
                return string2.substring(0, n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ItemMeta setUnbreakable(ItemMeta itemMeta, boolean bl) {
        block5: {
            if (newSetUnbreakableMethod) {
                itemMeta.setUnbreakable(bl);
            } else if (setUnbreakableSupport) {
                try {
                    Object object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    METHOD_SET_UNBREAKABLE_OLD.invoke(object, bl);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block5;
                    LocalUtils.loge("Reflections for setUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return itemMeta;
    }

    public static boolean isUnbreakable(ItemMeta itemMeta) {
        block4: {
            if (newIsUnbreakableMethod) {
                return itemMeta.isUnbreakable();
            }
            if (isUnbreakableSupport) {
                try {
                    Object object = METHOD_ITEM_META_SPIGOT.invoke((Object)itemMeta, new Object[0]);
                    return (Boolean)METHOD_IS_UNBREAKABLE_OLD.invoke(object, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block4;
                    LocalUtils.loge("Reflections for isUnbreakable method failed. This is a debug message!");
                }
            }
        }
        return false;
    }

    public static void setDurability(ItemStack itemStack, int n) {
        block6: {
            if (damageableSupport) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta instanceof Damageable) {
                    ((Damageable)itemMeta).setDamage(n);
                    itemStack.setItemMeta(itemMeta);
                }
            } else if (setDurabilityItemStackSupport) {
                try {
                    SET_DURABILITY_ITEM_STACK_METHOD.invoke((Object)itemStack, (short)n);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block6;
                    LocalUtils.logp("You are reading the next stacktrace because you have debug mode enabled!");
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static int getDurability(ItemStack itemStack) {
        block6: {
            if (damageableSupport) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta instanceof Damageable) {
                    return ((Damageable)itemMeta).getDamage();
                }
            } else if (getDurabilityItemStackSupport) {
                try {
                    return (Integer)GET_DURABILITY_ITEM_STACK_METHOD.invoke((Object)itemStack, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!AlonsoTags.getInstance().debugMode) break block6;
                    LocalUtils.logp("You are reading the next stacktrace because you have debug mode enabled!");
                    throwable.printStackTrace();
                }
            }
        }
        return -1;
    }

    public static SkullMeta setOwnerPlayer(SkullMeta skullMeta, String string) {
        if (setOwningPlayerSupport && getOfflinePlayerByNameSupport) {
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)string));
        } else if (METHOD_SET_OWNER != null) {
            try {
                METHOD_SET_OWNER.invoke((Object)skullMeta, string);
            }
            catch (Throwable throwable) {
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("SkullMeta#setOwner failed using reflections. Stacktrace is because debug mode is enabled!");
                    throwable.printStackTrace();
                }
                LocalUtils.logp("SkullMeta#setOwner failed using reflections: " + throwable.getMessage());
            }
        }
        return skullMeta;
    }

    public static SkullMeta setOwnerPlayer(SkullMeta skullMeta, Player player) {
        if (setOwningPlayerSupport && getOfflinePlayerByNameSupport) {
            skullMeta.setOwningPlayer((OfflinePlayer)player);
        } else if (METHOD_SET_OWNER != null) {
            try {
                METHOD_SET_OWNER.invoke((Object)skullMeta, player.getName());
            }
            catch (Throwable throwable) {
                if (AlonsoTags.getInstance().debugMode) {
                    LocalUtils.logp("SkullMeta#setOwner failed using reflections. Stacktrace is because debug mode is enabled!");
                    throwable.printStackTrace();
                }
                LocalUtils.logp("SkullMeta#setOwner failed using reflections: " + throwable.getMessage());
            }
        }
        return skullMeta;
    }

    static {
        Object object;
        SkullMeta skullMeta;
        SkullMeta skullMeta2;
        block39: {
            gameProfileSupport = false;
            setOwningPlayerSupport = false;
            oldItemStackSupport = false;
            setOwnerProfileSupport = false;
            gameProfileNoneNullRequired = false;
            nbtAPISupport = Bukkit.getServer().getPluginManager().getPlugin("NBTAPI") != null;
            CONSTRUCTOR_ITEM_STACK_OLD = null;
            PROFILE_FIELD = null;
            METHOD_SET_OWNER = null;
            headPluginName = "AlonsoTags";
            getOfflinePlayerByNameSupport = false;
            damageableSupport = false;
            setDurabilityItemStackSupport = false;
            getDurabilityItemStackSupport = false;
            METHOD_SET_UNBREAKABLE_OLD = null;
            METHOD_IS_UNBREAKABLE_OLD = null;
            METHOD_ITEM_META_SPIGOT = null;
            SET_DURABILITY_ITEM_STACK_METHOD = null;
            GET_DURABILITY_ITEM_STACK_METHOD = null;
            try {
                CONSTRUCTOR_ITEM_STACK_OLD = ItemStack.class.getConstructor(Material.class, Integer.TYPE, Short.TYPE);
                oldItemStackSupport = true;
                LocalUtils.logp("Old ItemStack constructor is available!");
            }
            catch (Throwable throwable) {
                LocalUtils.logp("Old ItemStack constructor is not available!");
            }
            Material material = LocalUtils.findMaterial("PLAYER_HEAD", "SKULL_ITEM");
            if (material.name().equals("PLAYER_HEAD")) {
                headItemSample = new ItemStack(material);
            } else {
                try {
                    headItemSample = (ItemStack)CONSTRUCTOR_ITEM_STACK_OLD.newInstance(material, 1, (byte)3);
                }
                catch (Throwable throwable) {
                    headItemSample = new ItemStack(material, 1, 3);
                }
            }
            try {
                SkullMeta.class.getMethod("setOwningPlayer", OfflinePlayer.class);
                LocalUtils.logp("SkullMeta#setOwningPlayer method is available for heads.");
                setOwningPlayerSupport = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                METHOD_SET_OWNER = SkullMeta.class.getMethod("setOwner", String.class);
                LocalUtils.logp("SkullMeta#setOwner method is available for heads.");
            }
            catch (Throwable throwable) {
                LocalUtils.logp("SkullMeta#setOwner method is not available for heads.");
            }
            try {
                new GameProfile(UUID.randomUUID(), null);
            }
            catch (Throwable throwable) {
                gameProfileNoneNullRequired = true;
            }
            try {
                ItemStack itemStack = headItemSample.clone();
                skullMeta2 = (SkullMeta)itemStack.getItemMeta();
                Bukkit.class.getDeclaredMethod("createPlayerProfile", UUID.class, String.class);
                SkullMeta.class.getDeclaredMethod("setOwnerProfile", PlayerProfile.class);
                skullMeta = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)headPluginName);
                skullMeta.getTextures().setSkin(new URL(ItemUtils.getTextureUrl("ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=")));
                skullMeta2.setOwnerProfile((PlayerProfile)skullMeta);
                itemStack.setItemMeta((ItemMeta)skullMeta2);
                LocalUtils.logp("SkullMeta#setOwnerProfile method is available for heads. Using it for heads..");
                setOwnerProfileSupport = true;
            }
            catch (Throwable throwable) {
                LocalUtils.logp("SkullMeta#setOwnerProfile is not available for heads. Ignoring..");
                try {
                    skullMeta2 = headItemSample.clone();
                    skullMeta = (SkullMeta)skullMeta2.getItemMeta();
                    object = new GameProfile(UUID.randomUUID(), headPluginName);
                    object.getProperties().put((Object)"textures", (Object)new Property("textures", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0="));
                    PROFILE_FIELD = skullMeta.getClass().getDeclaredField("profile");
                    PROFILE_FIELD.setAccessible(true);
                    PROFILE_FIELD.set(skullMeta, object);
                    skullMeta2.setItemMeta((ItemMeta)skullMeta);
                    gameProfileSupport = true;
                    if (gameProfileNoneNullRequired) {
                        LocalUtils.logp("GameProfile \"profile\" field available for heads (@NotNull name). Using it for heads..");
                    } else {
                        LocalUtils.logp("GameProfile \"profile\" field available for heads (@Nullable name). Using it for heads..");
                    }
                }
                catch (Throwable throwable2) {
                    PROFILE_FIELD = null;
                    if (nbtAPISupport) {
                        LocalUtils.logp("Using NBTAPI for custom textures head..");
                        break block39;
                    }
                    LocalUtils.logp("Custom texture heads are not available in this server. Skipping..");
                }
            }
        }
        try {
            ItemMeta.class.getDeclaredMethod("setUnbreakable", Boolean.TYPE);
            newSetUnbreakableMethod = true;
            setUnbreakableSupport = true;
            LocalUtils.logp("New setUnbreakable method found! Using it..");
        }
        catch (Throwable throwable) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                skullMeta2 = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                skullMeta = skullMeta2.getItemMeta();
                object = METHOD_ITEM_META_SPIGOT.invoke((Object)skullMeta, new Object[0]);
                METHOD_SET_UNBREAKABLE_OLD = object.getClass().getDeclaredMethod("setUnbreakable", Boolean.TYPE);
                skullMeta2.setItemMeta((ItemMeta)skullMeta);
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = true;
                LocalUtils.logp("New setUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable throwable3) {
                newSetUnbreakableMethod = false;
                setUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support setUnbreakable method. Consider using spigot/paper!");
            }
        }
        try {
            SkullMeta.class.getMethod("setOwningPlayer", OfflinePlayer.class);
            setOwningPlayerSupport = true;
            LocalUtils.logp("New setOwningPlayer method is available!");
        }
        catch (Throwable throwable) {
            setOwningPlayerSupport = false;
            LocalUtils.logp("New setOwningPlayer method is NOT available!");
            try {
                METHOD_SET_OWNER = SkullMeta.class.getMethod("setOwner", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            Bukkit.class.getMethod("getOfflinePlayer", String.class);
            getOfflinePlayerByNameSupport = true;
            LocalUtils.logp("Old Bukkit#getOfflinePlayer(String name) method is available!");
        }
        catch (Throwable throwable) {
            getOfflinePlayerByNameSupport = false;
            LocalUtils.logp("Old Bukkit#getOfflinePlayer(String name) method is NOT available!");
        }
        try {
            ItemMeta.class.getDeclaredMethod("isUnbreakable", new Class[0]);
            newIsUnbreakableMethod = true;
            isUnbreakableSupport = true;
            LocalUtils.logp("New isUnbreakable method found! Using it..");
        }
        catch (Throwable throwable) {
            try {
                METHOD_ITEM_META_SPIGOT = ItemMeta.class.getDeclaredMethod("spigot", new Class[0]);
                skullMeta2 = new ItemStack(LocalUtils.findMaterial("COBBLESTONE", "PLAYER_HEAD", "SKULL", "STONE"));
                skullMeta = skullMeta2.getItemMeta();
                object = METHOD_ITEM_META_SPIGOT.invoke((Object)skullMeta, new Object[0]);
                METHOD_IS_UNBREAKABLE_OLD = object.getClass().getDeclaredMethod("isUnbreakable", new Class[0]);
                skullMeta2.setItemMeta((ItemMeta)skullMeta);
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = true;
                LocalUtils.logp("New isUnbreakable method not found! Using the old one for spigot ONLY..");
            }
            catch (Throwable throwable4) {
                newIsUnbreakableMethod = false;
                isUnbreakableSupport = false;
                LocalUtils.logp("Server type/version does not support isUnbreakable method. Consider using spigot/paper!");
            }
        }
        try {
            Class.forName("org.bukkit.inventory.meta.Damageable");
            damageableSupport = true;
        }
        catch (Throwable throwable) {
            damageableSupport = false;
        }
        try {
            SET_DURABILITY_ITEM_STACK_METHOD = ItemStack.class.getMethod("setDurability", Short.TYPE);
            setDurabilityItemStackSupport = true;
        }
        catch (Throwable throwable) {
            setDurabilityItemStackSupport = false;
        }
        try {
            GET_DURABILITY_ITEM_STACK_METHOD = ItemStack.class.getMethod("getDurability", new Class[0]);
            getDurabilityItemStackSupport = true;
        }
        catch (Throwable throwable) {
            getDurabilityItemStackSupport = false;
        }
    }
}

