/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.jeff_media.angelchest.jefflib.PacketUtils;
import de.jeff_media.angelchest.jefflib.ai.goal.CustomGoal;
import de.jeff_media.angelchest.jefflib.ai.goal.PathfinderGoal;
import de.jeff_media.angelchest.jefflib.ai.navigation.JumpController;
import de.jeff_media.angelchest.jefflib.ai.navigation.LookController;
import de.jeff_media.angelchest.jefflib.ai.navigation.MoveController;
import de.jeff_media.angelchest.jefflib.ai.navigation.PathNavigation;
import de.jeff_media.angelchest.jefflib.data.ByteCounter;
import de.jeff_media.angelchest.jefflib.data.Hologram;
import de.jeff_media.angelchest.jefflib.data.OfflinePlayerPersistentDataContainer;
import de.jeff_media.angelchest.jefflib.data.SerializedEntity;
import de.jeff_media.angelchest.jefflib.data.tuples.Pair;
import de.jeff_media.angelchest.jefflib.internal.nms.AbstractNMSBlockHandler;
import de.jeff_media.angelchest.jefflib.internal.nms.AbstractNMSHandler;
import de.jeff_media.angelchest.jefflib.internal.nms.AbstractNMSMaterialHandler;
import de.jeff_media.angelchest.jefflib.internal.nms.BukkitUnsafe;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.BlockHandler;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.MaterialHandler;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.NMS;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.NMSBiomeUtils;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.NMSPacketUtils;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.CustomGoalExecutor;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedAvoidEntityGoal;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedJumpController;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedLookController;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedMoveController;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedMoveToBlockGoal;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedPathNavigation;
import de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.ai.HatchedTemptGoal;
import de.jeff_media.angelchest.thirdparty.com.google.gson.JsonElement;
import de.jeff_media.angelchest.thirdparty.com.google.gson.JsonObject;
import de.jeff_media.angelchest.thirdparty.org.jetbrains.annotations.NotNull;
import de.jeff_media.angelchest.thirdparty.org.jetbrains.annotations.Nullable;
import java.io.DataOutput;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_19_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.util.Vector;

public class NMSHandler
implements AbstractNMSHandler {
    private final MaterialHandler materialHandler = new MaterialHandler();
    private final BlockHandler blockHandler = new BlockHandler();

    @Override
    public AbstractNMSMaterialHandler getMaterialHandler() {
        return this.materialHandler;
    }

    @Override
    public AbstractNMSBlockHandler getBlockHandler() {
        return this.blockHandler;
    }

    @Override
    public void changeNMSEntityName(@NotNull Object object, @NotNull String string) {
        ((net.minecraft.world.entity.Entity)object).b(CraftChatMessage.fromString((String)string)[0]);
        for (Player player : Bukkit.getOnlinePlayers()) {
            DataWatcher dataWatcher = ((net.minecraft.world.entity.Entity)object).aj();
            this.sendPacket(player, new PacketPlayOutEntityMetadata(((net.minecraft.world.entity.Entity)object).af(), dataWatcher.c()));
        }
    }

    @Override
    public Object createHologram(@NotNull Location location, @NotNull String string, @NotNull Hologram.Type type) {
        EntityAreaEffectCloud entityAreaEffectCloud;
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = Objects.requireNonNull(craftWorld).getHandle();
        IChatBaseComponent iChatBaseComponent = CraftChatMessage.fromString((String)string)[0];
        switch (type) {
            case EFFECTCLOUD: {
                EntityAreaEffectCloud entityAreaEffectCloud2 = entityAreaEffectCloud = new EntityAreaEffectCloud((net.minecraft.world.level.World)worldServer, location.getX(), location.getY(), location.getZ());
                entityAreaEffectCloud2.a(0.0f);
                entityAreaEffectCloud2.d(0);
                entityAreaEffectCloud2.b(Integer.MAX_VALUE);
                break;
            }
            default: {
                entityAreaEffectCloud = new EntityArmorStand((net.minecraft.world.level.World)worldServer, location.getX(), location.getY(), location.getZ());
                EntityArmorStand entityArmorStand = (EntityArmorStand)entityAreaEffectCloud;
                entityArmorStand.e(true);
                entityArmorStand.j(true);
                entityArmorStand.u(true);
                entityArmorStand.t(true);
            }
        }
        entityAreaEffectCloud.m(true);
        entityAreaEffectCloud.d(true);
        entityAreaEffectCloud.b(iChatBaseComponent);
        entityAreaEffectCloud.n(true);
        return entityAreaEffectCloud;
    }

    @Override
    public void showEntityToPlayer(@NotNull Object object, @NotNull Player player) {
        PacketUtils.sendPacket((Player)player, (Object[])new Object[]{new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)object)});
        PacketUtils.sendPacket((Player)player, (Object[])new Object[]{new PacketPlayOutEntityMetadata(((net.minecraft.world.entity.Entity)object).af(), ((net.minecraft.world.entity.Entity)object).aj().c())});
    }

    @Override
    public void hideEntityFromPlayer(@NotNull Object object, @NotNull Player player) {
        PacketUtils.sendPacket((Player)player, (Object[])new Object[]{new PacketPlayOutEntityDestroy(new int[]{((net.minecraft.world.entity.Entity)object).af()})});
    }

    @Override
    public void sendPacket(@NotNull Player player, @NotNull Object object) {
        NMSPacketUtils.sendPacket(player, object);
    }

    @Override
    public Pair<String, String> getBiomeName(@NotNull Location location) {
        return NMSBiomeUtils.getBiomeName(location);
    }

    @Override
    public void playTotemAnimation(@NotNull Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PacketPlayOutEntityStatus packetPlayOutEntityStatus = new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)entityPlayer, 35);
        NMSPacketUtils.sendPacket(entityPlayer, packetPlayOutEntityStatus);
    }

    @Override
    public void setHeadTexture(@NotNull Block block, @NotNull GameProfile gameProfile) {
        WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
        BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntitySkull tileEntitySkull = (TileEntitySkull)worldServer.getBlockEntity(blockPosition, false);
        assert (tileEntitySkull != null);
        tileEntitySkull.a(gameProfile);
    }

    @Override
    public String itemStackToJson(@NotNull ItemStack itemStack) {
        net.minecraft.world.item.ItemStack itemStack2 = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        itemStack2.b(nBTTagCompound);
        return nBTTagCompound.f_();
    }

    @Override
    public ItemStack itemStackFromJson(@NotNull String string) {
        NBTTagCompound nBTTagCompound = MojangsonParser.a((String)string);
        net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.a((NBTTagCompound)nBTTagCompound);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    public void setFullTimeWithoutTimeSkipEvent(@NotNull World world, long l2, boolean bl) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        worldServer.b(l2);
        if (bl) {
            for (Player player : world.getPlayers()) {
                EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
                if (entityPlayer.b == null) continue;
                entityPlayer.b.a((Packet)new PacketPlayOutUpdateTime(entityPlayer.H.U(), entityPlayer.getPlayerTime(), entityPlayer.H.W().b(GameRules.k)));
            }
        }
    }

    @Override
    public double[] getTps() {
        return ((CraftServer)Bukkit.getServer()).getHandle().b().recentTps;
    }

    @Override
    public int getItemStackSizeInBytes(ItemStack itemStack) {
        ByteCounter byteCounter = new ByteCounter();
        NBTTagCompound nBTTagCompound = CraftItemStack.asNMSCopy((ItemStack)itemStack).u();
        if (nBTTagCompound == null) {
            return -1;
        }
        nBTTagCompound.a((DataOutput)byteCounter);
        return byteCounter.getBytes();
    }

    @Override
    public String getDefaultWorldName() {
        return ((CraftServer)Bukkit.getServer()).getServer().a().m;
    }

    @Override
    public PathfinderGoal createTemptGoal(Creature creature, Stream<Material> stream, double d2, boolean bl) {
        return new HatchedTemptGoal(creature, NMS.asPathfinder(creature), NMS.ingredient(stream), d2, bl);
    }

    @Override
    public PathfinderGoal createAvoidEntityGoal(Creature creature, Predicate<LivingEntity> predicate, float f2, double d2, double d3) {
        return new HatchedAvoidEntityGoal(creature, NMS.asPathfinder(creature), predicate, f2, d2, d3);
    }

    @Override
    public PathfinderGoal createMoveToBlockGoal(Creature creature, Set<Material> set, double d2, int n2, int n3) {
        return new HatchedMoveToBlockGoal.ByMaterialSet(creature, NMS.asPathfinder(creature), d2, n2, n3, set);
    }

    @Override
    public PathfinderGoal createMoveToBlockGoal(Creature creature, Predicate<Block> predicate, double d2, int n2, int n3) {
        return new HatchedMoveToBlockGoal.ByBlockPredicate(creature, NMS.asPathfinder(creature), d2, n2, n3, predicate);
    }

    @Override
    public void addGoal(Mob mob, PathfinderGoal pathfinderGoal, int n2) {
        NMS.asMob((Mob)mob).bN.a(n2, NMS.toNms(pathfinderGoal));
    }

    @Override
    public void removeGoal(Mob mob, PathfinderGoal pathfinderGoal) {
        NMS.asMob((Mob)mob).bN.a(NMS.toNms(pathfinderGoal));
    }

    @Override
    public void removeAllGoals(Mob mob) {
        NMS.asMob((Mob)mob).bN.a(pathfinderGoal -> true);
    }

    @Override
    public void addTargetGoal(Mob mob, PathfinderGoal pathfinderGoal, int n2) {
        NMS.asMob((Mob)mob).bO.a(n2, NMS.toNms(pathfinderGoal));
    }

    @Override
    public void removeTargetGoal(Mob mob, PathfinderGoal pathfinderGoal) {
        NMS.asMob((Mob)mob).bO.a(NMS.toNms(pathfinderGoal));
    }

    @Override
    public void removeAllTargetGoals(Mob mob) {
        NMS.asMob((Mob)mob).bO.a(pathfinderGoal -> true);
    }

    @Override
    public boolean moveTo(Mob mob, double d2, double d3, double d4, double d5) {
        EntityInsentient entityInsentient = NMS.asMob(mob);
        return entityInsentient.G().a(d2, d3, d4, d5);
    }

    @Override
    public boolean isServerRunnning() {
        return NMS.getDedicatedServer().v();
    }

    @Override
    public de.jeff_media.angelchest.jefflib.ai.goal.CustomGoalExecutor getCustomGoalExecutor(CustomGoal customGoal, Mob mob) {
        return new CustomGoalExecutor(customGoal, NMS.asMob(mob));
    }

    @Override
    @Nullable
    public Vector getRandomPos(Creature creature, int n2, int n3) {
        EntityCreature entityCreature = NMS.asPathfinder(creature);
        Vec3D vec3D = DefaultRandomPos.a((EntityCreature)entityCreature, (int)n2, (int)n3);
        return vec3D == null ? null : new Vector(vec3D.c, vec3D.d, vec3D.e);
    }

    @Override
    @Nullable
    public Vector getRandomPosAway(Creature creature, int n2, int n3, Vector vector) {
        EntityCreature entityCreature = NMS.asPathfinder(creature);
        Vec3D vec3D = DefaultRandomPos.a((EntityCreature)entityCreature, (int)n2, (int)n3, (Vec3D)NMS.toNms(vector));
        return vec3D == null ? null : NMS.toBukkit(vec3D);
    }

    @Override
    @Nullable
    public Vector getRandomPosTowards(Creature creature, int n2, int n3, Vector vector, double d2) {
        EntityCreature entityCreature = NMS.asPathfinder(creature);
        Vec3D vec3D = DefaultRandomPos.a((EntityCreature)entityCreature, (int)n2, (int)n3, (Vec3D)NMS.toNms(vector), (double)d2);
        return vec3D == null ? null : NMS.toBukkit(vec3D);
    }

    @Override
    @NotNull
    public MoveController getMoveControl(Mob mob) {
        return new HatchedMoveController(NMS.asMob(mob).D());
    }

    @Override
    @NotNull
    public JumpController getJumpControl(Mob mob) {
        return new HatchedJumpController(NMS.asMob(mob).E());
    }

    @Override
    @NotNull
    public LookController getLookControl(Mob mob) {
        return new HatchedLookController(NMS.asMob(mob).C());
    }

    @Override
    @NotNull
    public PathNavigation getPathNavigation(Mob mob) {
        EntityInsentient entityInsentient = NMS.asMob(mob);
        return new HatchedPathNavigation(entityInsentient.G());
    }

    @Override
    @Nullable
    public Advancement loadVolatileAdvancement(NamespacedKey namespacedKey, String string) {
        MinecraftKey minecraftKey = CraftNamespacedKey.toMinecraft((NamespacedKey)namespacedKey);
        JsonElement jsonElement = (JsonElement)AdvancementDataWorld.b.fromJson(string, JsonElement.class);
        JsonObject jsonObject = ChatDeserializer.m((JsonElement)jsonElement, (String)"advancement");
        Advancement.SerializedAdvancement serializedAdvancement = Advancement.SerializedAdvancement.a((JsonObject)jsonObject, (LootDeserializationContext)new LootDeserializationContext(minecraftKey, NMS.getServer().aI()));
        NMS.getServer().az().c.a((Map)Maps.newHashMap(Collections.singletonMap(minecraftKey, serializedAdvancement)));
        return Bukkit.getAdvancement((NamespacedKey)namespacedKey);
    }

    @Override
    @NotNull
    public BukkitUnsafe getUnsafe() {
        return de.jeff_media.angelchest.jefflib.internal.nms.v1_19_4_R1.BukkitUnsafe.INSTANCE;
    }

    @Override
    public String serializePdc(PersistentDataContainer persistentDataContainer) {
        return ((CraftPersistentDataContainer)persistentDataContainer).toTagCompound().f_();
    }

    @Override
    public void deserializePdc(String string, PersistentDataContainer persistentDataContainer) {
        NBTTagCompound nBTTagCompound = MojangsonParser.a((String)string);
        ((CraftPersistentDataContainer)persistentDataContainer).putAll(nBTTagCompound);
    }

    @Override
    public void respawnPlayer(Player player) {
        NMS.getServer().ac().a(NMS.toNms(player), true);
    }

    @Override
    public SerializedEntity serialize(Entity entity) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NMS.toNms(entity).f(nBTTagCompound);
        return new SerializedEntity(entity.getType(), nBTTagCompound.f_());
    }

    @Override
    public void applyNbt(Entity entity, String string) {
        NBTTagCompound nBTTagCompound = null;
        try {
            nBTTagCompound = MojangsonParser.a((String)string);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException(commandSyntaxException);
        }
        NMS.toNms(entity).g(nBTTagCompound);
    }

    @Override
    public OfflinePlayerPersistentDataContainer getPDCFromDatFile(File file) {
        CraftPersistentDataTypeRegistry craftPersistentDataTypeRegistry = new CraftPersistentDataTypeRegistry();
        CraftPersistentDataContainer craftPersistentDataContainer = new CraftPersistentDataContainer(craftPersistentDataTypeRegistry);
        NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a((File)file);
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.p("BukkitValues");
        craftPersistentDataContainer.putAll(nBTTagCompound2);
        return new OfflinePlayerPersistentDataContainer((PersistentDataContainer)craftPersistentDataContainer, file, (Object)nBTTagCompound);
    }

    @Override
    public void updatePdcInDatFile(OfflinePlayerPersistentDataContainer offlinePlayerPersistentDataContainer) {
        NBTTagCompound nBTTagCompound = ((CraftPersistentDataContainer)offlinePlayerPersistentDataContainer.getCraftPersistentDataContainer()).toTagCompound();
        NBTTagCompound nBTTagCompound2 = (NBTTagCompound)offlinePlayerPersistentDataContainer.getCompoundTag();
        nBTTagCompound2.a("BukkitValues", (NBTBase)nBTTagCompound);
        NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound2, (File)offlinePlayerPersistentDataContainer.getFile());
    }
}

