/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.angelchest.thirdparty.co.aikar.commands.lib.util;

import de.jeff_media.angelchest.thirdparty.co.aikar.commands.lib.util.DelegatingMap;
import de.jeff_media.angelchest.thirdparty.org.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Table<R, C, V>
implements Iterable<Entry<R, C, V>> {
    private final Map<R, Map<C, V>> rowMap;
    private final Function<R, Map<C, V>> colMapSupplier;

    public Table() {
        this(new HashMap(), HashMap::new);
    }

    public Table(Supplier<Map<C, V>> supplier) {
        this(new HashMap(), supplier);
    }

    public Table(Map<R, Map<C, V>> map, Supplier<Map<C, V>> supplier) {
        this(map, (R object) -> (Map)supplier.get());
    }

    public Table(Map<R, Map<C, V>> map, Function<R, Map<C, V>> function) {
        this.rowMap = map;
        this.colMapSupplier = function;
    }

    public V get(R r2, C c2) {
        return this.getIfExists(r2, c2);
    }

    public V getOrDefault(R r2, C c2, V v2) {
        Map<C, V> map = this.getColMapIfExists(r2);
        if (map == null) {
            return v2;
        }
        V v3 = map.get(c2);
        if (v3 != null || map.containsKey(c2)) {
            return v3;
        }
        return v2;
    }

    public boolean containsKey(R r2, C c2) {
        Map<C, V> map = this.getColMapIfExists(r2);
        if (map == null) {
            return false;
        }
        return map.containsKey(c2);
    }

    @Nullable
    public V put(R r2, C c2, V v2) {
        return this.getColMapForWrite(r2).put(c2, v2);
    }

    public void forEach(TableConsumer<R, C, V> tableConsumer) {
        for (Entry<R, C, V> entry : this) {
            tableConsumer.accept(entry.getRow(), entry.getCol(), entry.getValue());
        }
    }

    public void forEach(TablePredicate<R, C, V> tablePredicate) {
        for (Entry<R, C, V> entry : this) {
            if (tablePredicate.test(entry.getRow(), entry.getCol(), entry.getValue())) continue;
            return;
        }
    }

    public void removeIf(TablePredicate<R, C, V> tablePredicate) {
        Iterator<Entry<R, C, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry<R, C, V> entry = iterator.next();
            if (!tablePredicate.test(entry.getRow(), entry.getCol(), entry.getValue())) continue;
            iterator.remove();
        }
    }

    public Stream<Entry<R, C, V>> stream() {
        return this.stream(false);
    }

    public Stream<Entry<R, C, V>> stream(boolean bl) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), bl);
    }

    @Override
    public Iterator<Entry<R, C, V>> iterator() {
        return new Iterator<Entry<R, C, V>>(){
            Iterator<Map.Entry<R, Map<C, V>>> rowIter;
            Iterator<Map.Entry<C, V>> colIter;
            private Map.Entry<R, Map<C, V>> rowEntry;
            private Map.Entry<C, V> colEntry;
            private Entry<R, C, V> next;
            {
                this.rowIter = Table.this.rowMap.entrySet().iterator();
                this.colIter = null;
                this.next = this.getNext();
            }

            private Entry<R, C, V> getNext() {
                if (this.colIter == null || !this.colIter.hasNext()) {
                    if (!this.rowIter.hasNext()) {
                        return null;
                    }
                    this.rowEntry = this.rowIter.next();
                    this.colIter = this.rowEntry.getValue().entrySet().iterator();
                }
                if (!this.colIter.hasNext()) {
                    return null;
                }
                this.colEntry = this.colIter.next();
                return new Node(this.rowEntry, this.colEntry);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Entry<R, C, V> next() {
                Entry entry = this.next;
                this.next = this.getNext();
                return entry;
            }

            @Override
            public void remove() {
                this.colIter.remove();
            }
        };
    }

    public void replaceAll(TableFunction<R, C, V, V> tableFunction) {
        for (Entry<R, C, V> entry : this) {
            entry.setValue(tableFunction.compose(entry.getRow(), entry.getCol(), entry.getValue()));
        }
    }

    public V remove(R r2, C c2) {
        Map<C, V> map = this.rowMap.get(r2);
        if (map == null) {
            return null;
        }
        return map.remove(c2);
    }

    @Nullable
    public V replace(R r2, C c2, V v2) {
        Map<C, V> map = this.getColMapIfExists(r2);
        if (map == null) {
            return null;
        }
        if (map.get(c2) != null || map.containsKey(c2)) {
            return map.put(c2, v2);
        }
        return null;
    }

    @Nullable
    public boolean replace(R r2, C c2, V v2, V v3) {
        Map<C, V> map = this.getColMapIfExists(r2);
        if (map == null) {
            return false;
        }
        if (Objects.equals(map.get(c2), v2)) {
            map.put(c2, v3);
            return true;
        }
        return false;
    }

    public V computeIfAbsent(R r2, C c2, BiFunction<R, C, V> biFunction) {
        return (V)this.getColMapForWrite(r2).computeIfAbsent(c2, object3 -> biFunction.apply(r2, c2));
    }

    public V computeIfPresent(R r2, C c2, TableFunction<R, C, V, V> tableFunction) {
        Map<C, Object> map = this.getColMapForWrite(r2);
        Object object = map.computeIfPresent(c2, (object3, object4) -> tableFunction.compose(r2, c2, object4));
        this.removeIfEmpty(r2, map);
        return (V)object;
    }

    public V compute(R r2, C c2, TableFunction<R, C, V, V> tableFunction) {
        Map<C, Object> map = this.getColMapForWrite(r2);
        Object object = map.compute(c2, (object3, object4) -> tableFunction.compose(r2, c2, object4));
        this.removeIfEmpty(r2, map);
        return (V)object;
    }

    public V merge(R r2, C c2, V v2, TableFunction<R, C, V, V> tableFunction) {
        Map<C, Object> map = this.getColMapForWrite(r2);
        Object object = map.merge(c2, v2, (object3, object4) -> tableFunction.compose(r2, c2, object4));
        this.removeIfEmpty(r2, map);
        return (V)object;
    }

    public Map<C, V> row(final R r2) {
        final HashMap hashMap = new HashMap(0);
        return new DelegatingMap<C, V>(){

            @Override
            public Map<C, V> delegate(boolean bl) {
                if (bl) {
                    return Table.this.rowMap.getOrDefault(r2, hashMap);
                }
                return Table.this.getColMapForWrite(r2);
            }

            @Override
            public V remove(Object object) {
                Map map = this.delegate(false);
                Object v2 = map.remove(object);
                Table.this.removeIfEmpty(r2, map);
                return v2;
            }
        };
    }

    private V getIfExists(R r2, C c2) {
        Map<C, V> map = this.getColMapIfExists(r2);
        if (map == null) {
            return null;
        }
        return map.get(c2);
    }

    private Map<C, V> getColMapIfExists(R r2) {
        Map<C, V> map = this.rowMap.get(r2);
        if (map != null && map.isEmpty()) {
            this.rowMap.remove(r2);
            map = null;
        }
        return map;
    }

    private Map<C, V> getColMapForWrite(R r2) {
        return this.rowMap.computeIfAbsent(r2, this.colMapSupplier);
    }

    private void removeIfEmpty(R r2, Map<C, V> map) {
        if (map.isEmpty()) {
            this.rowMap.remove(r2);
        }
    }

    private class Node
    implements Entry<R, C, V> {
        private final Map.Entry<R, Map<C, V>> rowEntry;
        private final Map.Entry<C, V> colEntry;

        Node(Map.Entry<R, Map<C, V>> entry, Map.Entry<C, V> entry2) {
            this.rowEntry = entry;
            this.colEntry = entry2;
        }

        @Override
        public final R getRow() {
            return this.rowEntry.getKey();
        }

        @Override
        public final C getCol() {
            return this.colEntry.getKey();
        }

        @Override
        public final V getValue() {
            return this.colEntry.getValue();
        }

        @Override
        public final V setValue(V v2) {
            return this.colEntry.setValue(v2);
        }
    }

    public static interface Entry<R, C, V> {
        public R getRow();

        public C getCol();

        public V getValue();

        public V setValue(V var1);
    }

    public static interface TableConsumer<R, C, V> {
        public void accept(R var1, C var2, V var3);
    }

    public static interface TableFunction<R, C, V, RETURN> {
        public RETURN compose(R var1, C var2, V var3);
    }

    public static interface TablePredicate<R, C, V> {
        public boolean test(R var1, C var2, V var3);
    }
}

