/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation;

import cz.larkyy.playeremotes.spigotplugin.AquaticPlayerModel;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AnimationEmote {
    private final Location location;
    private final String animation;
    private final Map<Player, AquaticPlayerModel> emotes = new HashMap<Player, AquaticPlayerModel>();

    public AnimationEmote(Location location, String string) {
        this.location = location;
        this.animation = string;
    }

    private Entity spawnAs() {
        if (this.location == null) {
            return null;
        }
        return this.location.getWorld().spawn(this.location, ArmorStand.class, armorStand -> {
            armorStand.setPersistent(false);
            armorStand.setGravity(false);
            armorStand.setCollidable(false);
            armorStand.setInvisible(true);
        });
    }

    public void play(Player player) {
        if (this.animation == null) {
            return;
        }
        if (player == null) {
            return;
        }
        if (this.location == null) {
            return;
        }
        AquaticPlayerModel aquaticPlayerModel = this.emotes.get(player);
        if (aquaticPlayerModel == null) {
            aquaticPlayerModel = new AquaticPlayerModel(this.spawnAs(), player);
            this.emotes.put(player, aquaticPlayerModel);
        }
        aquaticPlayerModel.setViewer(player);
        aquaticPlayerModel.playAnimation(this.animation);
    }

    public void despawn(Player player) {
        AquaticPlayerModel aquaticPlayerModel = this.emotes.get(player);
        if (aquaticPlayerModel == null) {
            return;
        }
        aquaticPlayerModel.getBase().remove();
        aquaticPlayerModel.despawn();
        this.emotes.remove(player);
    }
}

