/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.animation.impl;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.Animation;
import cz.larkyy.aquaticcratestesting.animation.AnimationManager;
import cz.larkyy.aquaticcratestesting.animation.RewardItem;
import cz.larkyy.aquaticcratestesting.crate.PlacedCrate;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.model.Model;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlacedCrateAnimation
extends Animation {
    private final PlacedCrate placedCrate;
    private int i;
    private BukkitRunnable runnable;
    private RewardItem rewardItem = null;

    public PlacedCrateAnimation(AnimationManager animationManager, Player player, AtomicReference<Reward> atomicReference, Consumer<Animation> consumer, PlacedCrate placedCrate) {
        super(animationManager, player, atomicReference, consumer);
        this.placedCrate = placedCrate;
        if (placedCrate == null) {
            this.reroll();
        } else {
            this.begin();
        }
    }

    @Override
    public void begin() {
        this.start();
    }

    @Override
    public void start() {
        this.setStarted(true);
        this.getAnimationManager().showTitle(this.getAnimationManager().getOpeningTitle(), this.getPlayer());
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
            this.rewardItem = null;
        }
        if (this.placedCrate == null) {
            this.reroll();
            return;
        }
        this.placedCrate.getModel().playAnimation("open");
        this.i = 0;
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        this.runnable = new BukkitRunnable(){

            public void run() {
                PlacedCrateAnimation.this.getAnimationManager().playTask(PlacedCrateAnimation.this.i, PlacedCrateAnimation.this);
                if (PlacedCrateAnimation.this.getAnimationManager().shouldStopAnimation(PlacedCrateAnimation.this.i)) {
                    PlacedCrateAnimation.this.reroll();
                }
                ++PlacedCrateAnimation.this.i;
            }
        };
        this.runnable.runTaskTimer((Plugin)AquaticCratesTesting.instance(), 0L, 1L);
    }

    @Override
    public void reroll() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        this.getAnimationManager().hideTitle(this.getPlayer());
        super.reroll();
    }

    @Override
    public void end() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
            this.rewardItem = null;
        }
        this.getAnimationManager().hideTitle(this.getPlayer());
        if (this.placedCrate != null) {
            this.getModel().playAnimation("idle");
        }
    }

    @Override
    public void spawnReward(int n, int n2, int n3, Vector vector, boolean bl, Vector vector2) {
        if (this.rewardItem != null) {
            this.rewardItem.despawn();
        }
        this.rewardItem = new RewardItem(null, this, n, n2, n3, vector, bl, vector2);
        this.rewardItem.spawn();
    }

    @Override
    public Model getModel() {
        return this.placedCrate.getModel();
    }
}

