/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate.reroll;

import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.reroll.Reroll;
import cz.larkyy.aquaticcratestesting.crate.reroll.impl.InteractionReroll;
import cz.larkyy.aquaticcratestesting.crate.reroll.impl.MenuReroll;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class RerollManager {
    private final Map<String, Integer> groups;
    private final Crate crate;
    private final Type type;

    public RerollManager(Crate crate, Map<String, Integer> map, Type type) {
        this.crate = crate;
        this.groups = map.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n, n2) -> n, LinkedHashMap::new));
        this.type = type;
    }

    public int getPlayerLimit(Player player) {
        for (Map.Entry<String, Integer> entry : this.groups.entrySet()) {
            String string = entry.getKey();
            int n = entry.getValue();
            if (string.equalsIgnoreCase("default")) {
                return n;
            }
            if (!player.hasPermission("aquaticcrates.reroll." + this.crate.getIdentifier() + "." + string)) continue;
            return n;
        }
        return 0;
    }

    public void reroll(Player player) {
        Reroll reroll = Reroll.get(player);
        if (reroll == null) {
            return;
        }
        reroll.reroll();
    }

    public boolean setRerolling(Player player, AtomicReference<Reward> atomicReference, Consumer<Reward> consumer, Consumer<Reward> consumer2) {
        Reroll reroll = Reroll.get(player);
        if (reroll == null) {
            switch (this.type) {
                case GUI: {
                    reroll = new MenuReroll(this, player, atomicReference, consumer, consumer2);
                    break;
                }
                default: {
                    reroll = new InteractionReroll(this, player, atomicReference, consumer, consumer2);
                }
            }
            AquaticCratesAPI.getPlayerHandler().addRerollPlayer(reroll);
        }
        if (reroll.getReroll() < this.getPlayerLimit(player)) {
            reroll.setRerolling(true);
            reroll.open();
            return true;
        }
        consumer.accept(atomicReference.get());
        AquaticCratesAPI.getPlayerHandler().removeRerollPlayer(player);
        return false;
    }

    public void claim(Player player) {
        Reroll reroll = Reroll.get(player);
        reroll.claim();
        AquaticCratesAPI.getPlayerHandler().removeRerollPlayer(player);
    }

    public Crate getCrate() {
        return this.crate;
    }

    public static enum Type {
        INTERACTION,
        GUI;

    }
}

