/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.player;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.animation.Animation;
import cz.larkyy.aquaticcratestesting.crate.reroll.Reroll;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.util.Arrays;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataType;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        AquaticCratesTesting.getPlayerHandler().loadPlayer(player, cratePlayer -> {});
        AquaticCratesTesting.getCrateHandler().getLocations().values().forEach(placedCrate -> placedCrate.getHologram().spawn(Arrays.asList(player), list -> {}));
        if (player.getPersistentDataContainer().has(Animation.KEY, PersistentDataType.INTEGER)) {
            player.setInvisible(false);
            player.setGameMode(GameMode.SURVIVAL);
            player.getPersistentDataContainer().remove(Animation.KEY);
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        AquaticCratesTesting.getCrateHandler().getLocations().values().forEach(placedCrate -> {
            if (placedCrate.getLocation().getWorld().equals(playerChangedWorldEvent.getPlayer().getWorld())) {
                placedCrate.getHologram().spawn(Arrays.asList(player), list -> {});
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        AquaticCratesTesting.getPlayerHandler().savePlayer(CratePlayer.get(playerQuitEvent.getPlayer()));
        AquaticCratesTesting.getPlayerHandler().unloadPlayer((OfflinePlayer)playerQuitEvent.getPlayer());
        AquaticCratesTesting.getCrateHandler().forceSkipAnimation(playerQuitEvent.getPlayer());
        Reroll reroll = Reroll.get(playerQuitEvent.getPlayer());
        if (reroll != null && reroll.isRerolling()) {
            reroll.claim();
            return;
        }
    }
}

