/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.shaded.colorutils;

import cz.larkyy.aquaticcratestesting.shaded.colorutils.ClassicPattern;
import cz.larkyy.aquaticcratestesting.shaded.colorutils.GradientPattern;
import cz.larkyy.aquaticcratestesting.shaded.colorutils.IPattern;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;

public class Colors {
    private static final Map<Color, ChatColor> colors = new HashMap<Color, ChatColor>();
    private static final List<IPattern> patterns = Arrays.asList(new GradientPattern(), new ClassicPattern());
    private static final boolean SUPPORTSRGB = true;

    public static List<String> format(List<String> list) {
        return list.stream().map(Colors::format).collect(Collectors.toList());
    }

    public static String format(String string) {
        return string == null ? null : Colors.process(string);
    }

    private static ChatColor getClosestColor(Color color) {
        Color color2 = null;
        double d = 2.147483647E9;
        for (Color color3 : colors.keySet()) {
            double d2 = Math.pow(color.getRed() - color3.getRed(), 2.0) + Math.pow(color.getGreen() - color3.getGreen(), 2.0) + Math.pow(color.getBlue() - color3.getBlue(), 2.0);
            if (!(d > d2)) continue;
            color2 = color3;
            d = d2;
        }
        return colors.get(color2);
    }

    public static String process(String string) {
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        for (IPattern iPattern : patterns) {
            string = iPattern.process(string);
        }
        return string;
    }

    public static String color(String string, Color color, Color color2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        ChatColor[] chatColorArray = Colors.createGradient(color, color2, string.length());
        String[] stringArray = string.split("");
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(chatColorArray[i]).append(string2).append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static ChatColor getColor(String string) {
        return ChatColor.of((Color)new Color(Integer.parseInt(string, 16)));
    }

    private static ChatColor[] createGradient(Color color, Color color2, int n) {
        ChatColor[] chatColorArray = new ChatColor[n];
        int n2 = Math.abs(color.getRed() - color2.getRed()) / (n - 1);
        int n3 = Math.abs(color.getGreen() - color2.getGreen()) / (n - 1);
        int n4 = Math.abs(color.getBlue() - color2.getBlue()) / (n - 1);
        int[] nArray = new int[]{color.getRed() < color2.getRed() ? 1 : -1, color.getGreen() < color2.getGreen() ? 1 : -1, color.getBlue() < color2.getBlue() ? 1 : -1};
        for (int i = 0; i < n; ++i) {
            Color color3 = new Color(color.getRed() + n2 * i * nArray[0], color.getGreen() + n3 * i * nArray[1], color.getBlue() + n4 * i * nArray[2]);
            chatColorArray[i] = ChatColor.of((Color)color3);
        }
        return chatColorArray;
    }
}

