/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.shaded.itemlibrary;

import cz.larkyy.aquaticcratestesting.shaded.itemlibrary.CustomItemHandler;
import cz.larkyy.shaded.colorutils.Colors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class CustomItem {
    private static CustomItemHandler customItemHandler;
    private final String name;
    private final List<String> description;
    private final int amount;
    private final int modeldata;
    private final Map<Enchantment, Integer> enchantments;
    private final List<ItemFlag> flags;

    public CustomItem(String string, List<String> list, int n, int n2, Map<Enchantment, Integer> map, List<ItemFlag> list2) {
        this.name = string;
        this.description = list;
        this.amount = n;
        this.modeldata = n2;
        this.enchantments = map;
        this.flags = list2;
    }

    public void giveItem(Player player) {
        this.giveItem(player, this.amount);
    }

    public void giveItem(Player player, int n) {
        ItemStack itemStack = this.getItem();
        itemStack.setAmount(n);
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public ItemStack getItem() {
        ItemStack itemStack = this.getUnmodifiedItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        if (this.name != null) {
            itemMeta.setDisplayName(Colors.format(this.name));
        }
        if (this.description != null) {
            itemMeta.setLore(Colors.format(this.description));
        }
        if (this.modeldata > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(this.modeldata));
        }
        this.flags.forEach(itemFlag -> itemMeta.addItemFlags(new ItemFlag[]{itemFlag}));
        if (itemStack.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            this.enchantments.forEach((enchantment, n) -> enchantmentStorageMeta.addStoredEnchant(enchantment, n.intValue(), true));
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            itemStack.setItemMeta(itemMeta);
            itemStack.addUnsafeEnchantments(this.enchantments);
        }
        itemStack.setAmount(this.amount);
        return itemStack;
    }

    public abstract ItemStack getUnmodifiedItem();

    public static CustomItem create(String string, String string2, List<String> list, int n, int n2, Map<Enchantment, Integer> map, List<ItemFlag> list2) {
        if (customItemHandler == null) {
            customItemHandler = new CustomItemHandler();
        }
        return customItemHandler.getCustomItem(string, string2, list, n, n2, map, list2);
    }

    public static CustomItem loadFromYaml(FileConfiguration fileConfiguration, String string) {
        Enchantment enchantment;
        if (!fileConfiguration.contains(string)) {
            return null;
        }
        List list = null;
        if (fileConfiguration.contains(string + ".lore")) {
            list = fileConfiguration.getStringList(string + ".lore");
        }
        HashMap<Enchantment, Integer> hashMap = new HashMap<Enchantment, Integer>();
        if (fileConfiguration.contains(string + ".enchants")) {
            for (Object object : fileConfiguration.getStringList(string + ".enchants")) {
                Object object2 = ((String)object).split(":");
                if (((String[])object2).length < 2) continue;
                enchantment = CustomItem.getEnchantmentByString(object2[0]);
                int n = Integer.parseInt(object2[1]);
                hashMap.put(enchantment, n);
            }
        }
        ArrayList arrayList = new ArrayList();
        if (fileConfiguration.contains(string + ".flags")) {
            for (Object object2 : fileConfiguration.getStringList(string + ".flags")) {
                enchantment = ItemFlag.valueOf((String)((String)object2).toUpperCase());
                arrayList.add(enchantment);
            }
        }
        return CustomItem.create(fileConfiguration.getString(string + ".material", "STONE"), fileConfiguration.getString(string + ".display-name"), list, fileConfiguration.getInt(string + ".amount", 1), fileConfiguration.getInt(string + ".model-data"), hashMap, arrayList);
    }

    private static Enchantment getEnchantmentByString(String string) {
        return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)string.toLowerCase()));
    }

    public static CustomItemHandler getCustomItemHandler() {
        if (customItemHandler == null) {
            customItemHandler = new CustomItemHandler();
        }
        return customItemHandler;
    }
}

