/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate;

import cz.larkyy.aquaticcratestesting.api.AquaticCratesAPI;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.model.ModelAnimationHandler;
import cz.larkyy.aquaticcratestesting.hologram.Hologram;
import cz.larkyy.aquaticcratestesting.hologram.impl.AquaticHologram;
import cz.larkyy.aquaticcratestesting.model.Model;
import cz.larkyy.aquaticcratestesting.player.CratePlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PlacedCrate {
    private final Location location;
    private final Crate crate;
    private final Model model;
    private final Hologram hologram;
    private final ModelAnimationHandler modelAnimationHandler;

    public PlacedCrate(Crate crate, Location location) {
        this.location = location;
        this.crate = crate;
        this.hologram = new AquaticHologram(location.clone().add(0.0, crate.getHologramYOffset(), 0.0), crate.getHologram());
        this.hologram.spawn(new ArrayList<Player>(Bukkit.getOnlinePlayers()), list -> {});
        this.model = Model.create(crate.getModel(), location, null, null);
        this.modelAnimationHandler = new ModelAnimationHandler(this.model, crate);
    }

    public PlacedCrate(Crate crate, Location location, Model model, Hologram hologram) {
        this.location = location;
        this.crate = crate;
        this.hologram = hologram;
        this.model = model;
        this.modelAnimationHandler = new ModelAnimationHandler(model, crate);
    }

    public static PlacedCrate get(Location location) {
        if (location == null) {
            return null;
        }
        return AquaticCratesAPI.getCrateHandler().getPlacedCrate(location);
    }

    public Location getLocation() {
        return this.location;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public Model getModel() {
        return this.model;
    }

    public void destroy() {
        this.modelAnimationHandler.setCancelled(true);
        this.model.remove();
        for (Location location : this.getHitboxLocations()) {
            location.getBlock().setType(Material.AIR);
        }
        this.hologram.despawn();
    }

    public List<Location> getHitboxLocations() {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Location location = this.location.clone();
        for (int i = -(this.getCrate().getHitboxWidth() - 1); i < this.getCrate().getHitboxWidth(); ++i) {
            for (int j = -(this.getCrate().getHitboxWidth() - 1); j < this.getCrate().getHitboxWidth(); ++j) {
                for (int k = 0; k < this.getCrate().getHitboxHeight(); ++k) {
                    arrayList.add(location.clone().add((double)i, (double)k, (double)j).getBlock().getLocation());
                }
            }
        }
        return arrayList;
    }

    public void open(CratePlayer cratePlayer, boolean bl) {
        this.crate.open(cratePlayer, this, bl);
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

