/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.crate.model;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.CrateBase;
import cz.larkyy.aquaticcratestesting.crate.model.ModelAnimation;
import cz.larkyy.aquaticcratestesting.model.Model;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModelAnimationHandler {
    private final CrateBase crateBase;
    private final Model model;
    private boolean cancelled = false;

    public ModelAnimationHandler(Model model, CrateBase crateBase) {
        this.model = model;
        this.crateBase = crateBase;
        this.playNext();
    }

    public void playNext() {
        if (this.crateBase.getModelSettings().getModelAnimations().getPeriod() < 0) {
            return;
        }
        ModelAnimation modelAnimation = this.crateBase.getModelSettings().getModelAnimations().getRandomAnimation();
        if (modelAnimation == null) {
            return;
        }
        int n = this.crateBase.getModelSettings().getModelAnimations().getPeriod();
        CrateBase crateBase = this.crateBase;
        if (crateBase instanceof Crate) {
            Crate crate = (Crate)crateBase;
            if (!crate.getAnimationManager().get().isAnyoneOpening()) {
                this.model.playAnimation(modelAnimation.getAnimationId());
            }
        } else {
            this.model.playAnimation(modelAnimation.getAnimationId());
        }
        new BukkitRunnable(){

            public void run() {
                if (ModelAnimationHandler.this.cancelled) {
                    return;
                }
                ModelAnimationHandler.this.playNext();
            }
        }.runTaskLater((Plugin)AquaticCratesTesting.instance(), (long)(n + modelAnimation.getAnimationLength()));
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

