/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.item;

import cz.larkyy.aquaticcratestesting.AquaticCratesTesting;
import cz.larkyy.aquaticcratestesting.config.Config;
import cz.larkyy.aquaticcratestesting.item.AquaticItemFactory;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.larkyy.itemlibrary.CustomItem;

public class ItemHandler {
    private final Config databaseCfg = new Config((JavaPlugin)AquaticCratesTesting.instance(), "itemdatabase.yml");
    private final Map<String, ItemStack> database = new HashMap<String, ItemStack>();

    public void load() {
        CustomItem.getCustomItemHandler().addItemFactory("aquatic", new AquaticItemFactory());
        this.database.clear();
        this.databaseCfg.load();
        this.loadItems();
    }

    private void loadItems() {
        if (!this.cfg().contains("items")) {
            return;
        }
        for (String string : this.cfg().getConfigurationSection("items").getKeys(false)) {
            ItemStack itemStack = this.cfg().getItemStack("items." + string);
            this.database.put(string, itemStack);
        }
    }

    private FileConfiguration cfg() {
        return this.databaseCfg.getConfiguration();
    }

    public ItemStack getItem(String string) {
        ItemStack itemStack = this.database.get(string);
        if (itemStack == null) {
            return itemStack;
        }
        return itemStack.clone();
    }

    public void addItem(String string, ItemStack itemStack) {
        this.database.put(string, itemStack);
        this.saveItem(string, itemStack);
    }

    private void saveItem(final String string, final ItemStack itemStack) {
        new BukkitRunnable(){

            public void run() {
                ItemHandler.this.cfg().set("items." + string, (Object)itemStack);
                ItemHandler.this.databaseCfg.save();
            }
        }.runTaskAsynchronously((Plugin)AquaticCratesTesting.instance());
    }

    public Map<String, ItemStack> getItems() {
        return this.database;
    }
}

