/*
 * Decompiled with CFR 0.152.
 */
package cz.larkyy.aquaticcratestesting.utils;

import cz.larkyy.aquaticcratestesting.crate.Crate;
import cz.larkyy.aquaticcratestesting.crate.reward.Reward;
import cz.larkyy.aquaticcratestesting.utils.IReward;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class RewardUtils {
    public static IReward getRandomReward(List<IReward> list, IReward iReward) {
        if (iReward != null) {
            list.remove(iReward);
            if (list.isEmpty()) {
                return iReward;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        if (RewardUtils.getTotalPercentage(list) > 0.0) {
            double d = 0.0;
            for (IReward iReward2 : list) {
                d += iReward2.getChance();
            }
            int n = -1;
            double d2 = Math.random() * d;
            for (int i = 0; i < list.size(); ++i) {
                if (!((d2 -= list.get(i).getChance()) <= 0.0)) continue;
                n = i;
                break;
            }
            return list.get(n);
        }
        return null;
    }

    public static List<IReward> getPossibleRewards(Player player, List<Reward> list, Crate crate) {
        ArrayList<IReward> arrayList = new ArrayList<IReward>();
        for (Reward reward : list) {
            if (reward.getWinConditions().isEmpty()) {
                arrayList.add(reward);
                continue;
            }
            if (!reward.getWinConditions().stream().allMatch(configuredRewardCondition -> configuredRewardCondition.check(player, crate))) continue;
            arrayList.add(reward);
        }
        return arrayList;
    }

    private static double getTotalPercentage(List<IReward> list) {
        return list.stream().mapToDouble(IReward::getChance).sum();
    }
}

