/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.library.kether;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.serverct.ersha.taboolib.library.kether.ActionProperties;
import org.serverct.ersha.taboolib.library.kether.ExitStatus;
import org.serverct.ersha.taboolib.library.kether.ParsedAction;
import org.serverct.ersha.taboolib.library.kether.Quest;
import org.serverct.ersha.taboolib.library.kether.QuestCloseException;
import org.serverct.ersha.taboolib.library.kether.QuestContext;
import org.serverct.ersha.taboolib.library.kether.QuestFuture;
import org.serverct.ersha.taboolib.library.kether.QuestService;

public abstract class AbstractQuestContext<T extends AbstractQuestContext<T>>
implements QuestContext {
    protected final QuestService<T> service;
    protected final QuestContext.Frame rootFrame;
    protected final Quest quest;
    protected final QuestExecutor executor;
    protected ExitStatus exitStatus;
    protected CompletableFuture<Object> future;

    protected AbstractQuestContext(QuestService<T> service, Quest quest, String playerIdentifier) {
        this.service = service;
        this.quest = quest;
        this.rootFrame = this.createRootFrame();
        this.executor = new QuestExecutor(this);
    }

    protected abstract Executor createExecutor();

    protected QuestContext.Frame createRootFrame() {
        return new SimpleNamedFrame(null, new LinkedList<QuestContext.Frame>(), new SimpleVarTable(null), "main", this);
    }

    public QuestService<T> getService() {
        return this.service;
    }

    @Override
    public Quest getQuest() {
        return this.quest;
    }

    @Override
    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    @Override
    public Optional<ExitStatus> getExitStatus() {
        return Optional.ofNullable(this.exitStatus);
    }

    @Override
    public QuestExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public QuestContext.Frame rootFrame() {
        return this.rootFrame;
    }

    @Override
    public CompletableFuture<Object> runActions() {
        Preconditions.checkState((this.future == null ? 1 : 0) != 0, (Object)"already running");
        this.future = this.rootFrame.run().thenApply(o -> {
            if (this.exitStatus == null) {
                this.exitStatus = ExitStatus.success();
            }
            return o;
        });
        return this.future;
    }

    @Override
    public void terminate() {
        this.rootFrame.close();
        if (this.future != null) {
            this.future.completeExceptionally(new QuestCloseException());
            this.future = null;
        }
    }

    public static class SimpleVarTable
    implements QuestContext.VarTable {
        private final QuestContext.Frame parent;
        private final Map<String, Object> map;

        public SimpleVarTable(QuestContext.Frame parent) {
            this(parent, new HashMap<String, Object>());
        }

        public SimpleVarTable(QuestContext.Frame parent, Map<String, Object> map2) {
            this.parent = parent;
            this.map = map2;
        }

        @Override
        public QuestContext.VarTable parent() {
            return this.parent != null ? this.parent.variables() : null;
        }

        @Override
        public <T> Optional<T> get(@NotNull String name2) throws CompletionException {
            Object o = this.map.get(name2);
            if (o == null && this.parent != null) {
                return this.parent.variables().get(name2);
            }
            if (o instanceof QuestFuture) {
                o = ((QuestFuture)o).getFuture().join();
            }
            return Optional.ofNullable(o);
        }

        @Override
        public <T> Optional<QuestFuture<T>> getFuture(@NotNull String name2) {
            Object o = this.map.get(name2);
            if (o == null && this.parent != null) {
                return this.parent.variables().getFuture(name2);
            }
            if (o instanceof QuestFuture) {
                return Optional.of((QuestFuture)o);
            }
            return Optional.empty();
        }

        @Override
        public void set(@NotNull String name2, Object value) {
            if (name2.startsWith("~") || this.parent() == null) {
                this.map.put(name2, value);
            } else {
                this.parent().set(name2, value);
            }
        }

        @Override
        public <T> void set(@NotNull String name2, @NotNull ParsedAction<T> owner, @NotNull CompletableFuture<T> future) {
            this.map.put(name2, new QuestFuture<T>(owner, future));
        }

        @Override
        public void remove(@NotNull String name2) {
            this.map.remove(name2);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<String> keys() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public Collection<Map.Entry<String, Object>> values() {
            return Collections.unmodifiableCollection(this.map.entrySet());
        }

        @Override
        public void initialize(@NotNull QuestContext.Frame frame) {
            for (Object o : this.map.values()) {
                if (!(o instanceof QuestFuture)) continue;
                ((QuestFuture)o).run(frame);
            }
        }

        @Override
        public void close() {
            for (Object o : this.map.values()) {
                if (!(o instanceof QuestFuture)) continue;
                ((QuestFuture)o).close();
            }
        }
    }

    public static class SimpleActionFrame
    extends AbstractFrame {
        protected final ParsedAction<?> action;

        public SimpleActionFrame(QuestContext.Frame parent, List<QuestContext.Frame> frames, QuestContext.VarTable varTable, ParsedAction<?> action, QuestContext questContext) {
            super(parent, frames, varTable, questContext);
            this.action = action;
        }

        @Override
        public String name() {
            return this.action.toString();
        }

        @Override
        public Optional<ParsedAction<?>> currentAction() {
            return Optional.of(this.action);
        }

        @Override
        public void setNext(@NotNull ParsedAction<?> action) {
            if (this.parent != null) {
                this.parent.setNext(action);
            }
        }

        @Override
        public void setNext(@NotNull Quest.Block block) {
            if (this.parent != null) {
                this.parent.setNext(block);
            }
        }

        @Override
        public <T> CompletableFuture<T> run() {
            Preconditions.checkState((this.future == null ? 1 : 0) != 0, (Object)"already running");
            this.varTable.initialize(this);
            this.future = this.action.process(this);
            return this.future;
        }
    }

    public static class SimpleNamedFrame
    extends AbstractFrame {
        private final String name;
        private Quest.Block block;
        private Quest.Block next;
        private int sp = -1;
        private int np = -1;

        public SimpleNamedFrame(QuestContext.Frame parent, List<QuestContext.Frame> frames, QuestContext.VarTable varTable, String name2, QuestContext questContext) {
            super(parent, frames, varTable, questContext);
            this.name = name2;
            this.context().getQuest().getBlock(name2).ifPresent(this::setNext);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Optional<ParsedAction<?>> currentAction() {
            if (this.block == null || this.sp == -1) {
                return Optional.empty();
            }
            return this.block.get(this.sp);
        }

        @Override
        public void setNext(@NotNull ParsedAction<?> action) {
            if (this.block != null) {
                this.np = this.block.indexOf(action);
                if (this.np == -1) {
                    this.next = null;
                }
            }
            if (this.next == null) {
                Optional<Quest.Block> optional = this.context().getQuest().blockOf(action);
                if (optional.isPresent()) {
                    this.next = optional.get();
                    this.np = this.next.indexOf(action);
                } else {
                    throw new IllegalArgumentException(action + " is not in quest");
                }
            }
        }

        @Override
        public void setNext(@NotNull Quest.Block block) {
            this.next = block;
            this.np = 0;
        }

        @Override
        public <T> CompletableFuture<T> run() {
            Preconditions.checkState((this.future == null ? 1 : 0) != 0, (Object)"already running");
            this.varTable.initialize(this);
            this.future = new CompletableFuture();
            this.process(this.future);
            return this.future;
        }

        private void process(CompletableFuture<?> future) {
            while (!this.context().getExitStatus().isPresent()) {
                this.cleanup();
                this.frames.removeIf(QuestContext.Frame::isDone);
                Optional<ParsedAction<?>> optional = this.nextAction();
                if (optional.isPresent()) {
                    ParsedAction<?> action = optional.get();
                    CompletableFuture<?> newFuture = action.process(this);
                    if (!newFuture.isDone()) {
                        newFuture.thenRun(() -> this.process(newFuture));
                        return;
                    }
                    future = newFuture;
                    continue;
                }
                this.future.complete(future != null && future.isDone() ? (Object)future.join() : null);
                return;
            }
        }

        private Optional<? extends ParsedAction<?>> nextAction() {
            if (this.next != null && this.np != -1) {
                this.block = this.next;
                this.sp = this.np++;
                return this.block.get(this.sp);
            }
            return Optional.empty();
        }
    }

    public static abstract class AbstractFrame
    implements QuestContext.Frame {
        protected final QuestContext.Frame parent;
        protected final List<QuestContext.Frame> frames;
        protected final QuestContext.VarTable varTable;
        protected final QuestContext questContext;
        protected CompletableFuture<?> future;
        protected final Deque<AutoCloseable> closeables = new LinkedBlockingDeque<AutoCloseable>();

        public AbstractFrame(QuestContext.Frame parent, List<QuestContext.Frame> frames, QuestContext.VarTable varTable, QuestContext questContext) {
            this.parent = parent;
            this.frames = frames;
            this.varTable = varTable;
            this.questContext = questContext;
        }

        @Override
        public QuestContext context() {
            return this.questContext;
        }

        @Override
        public List<QuestContext.Frame> children() {
            return this.frames;
        }

        @Override
        public Optional<QuestContext.Frame> parent() {
            return Optional.ofNullable(this.parent);
        }

        @Override
        public QuestContext.Frame newFrame(@NotNull String name2) {
            SimpleNamedFrame frame = new SimpleNamedFrame(this, new LinkedList<QuestContext.Frame>(), new SimpleVarTable(this), name2, this.context());
            this.frames.add(frame);
            return frame;
        }

        @Override
        public QuestContext.Frame newFrame(@NotNull ParsedAction<?> action) {
            AbstractFrame frame;
            if (action.get(ActionProperties.REQUIRE_FRAME, false).booleanValue()) {
                frame = new SimpleNamedFrame(this, new LinkedList<QuestContext.Frame>(), new SimpleVarTable(this), "__anon__" + System.nanoTime(), this.context());
                frame.setNext(action);
            } else {
                frame = new SimpleActionFrame(this, new LinkedList<QuestContext.Frame>(), new SimpleVarTable(this), action, this.context());
            }
            this.frames.add(frame);
            return frame;
        }

        @Override
        public QuestContext.VarTable variables() {
            return this.varTable;
        }

        @Override
        public <T extends AutoCloseable> T addClosable(T closeable) {
            this.closeables.addFirst(closeable);
            return closeable;
        }

        @Override
        public void close() {
            if (this.future == null) {
                return;
            }
            for (QuestContext.Frame frame : this.frames) {
                frame.close();
            }
            this.cleanup();
            this.future = null;
        }

        @Override
        public boolean isDone() {
            return this.future == null || this.future.isDone();
        }

        void cleanup() {
            while (!this.closeables.isEmpty()) {
                try {
                    this.closeables.pollFirst().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class QuestExecutor
    implements Executor {
        private final AbstractQuestContext<?> questContext;
        private final Executor actual;

        public QuestExecutor(AbstractQuestContext<?> questContext) {
            this.questContext = questContext;
            this.actual = questContext.createExecutor();
        }

        @Override
        public void execute(@NotNull Runnable command2) {
            if (!this.questContext.getExitStatus().isPresent()) {
                this.actual.execute(command2);
            }
        }
    }
}

