/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.library.kether;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.serverct.ersha.taboolib.library.kether.ParsedAction;
import org.serverct.ersha.taboolib.library.kether.QuestContext;

public class QuestFuture<T> {
    private final ParsedAction<T> action;
    private CompletableFuture<T> future;

    public QuestFuture(ParsedAction<T> action) {
        this(action, null);
    }

    public QuestFuture(ParsedAction<T> action, CompletableFuture<T> future) {
        this.action = action;
        this.future = future;
    }

    public ParsedAction<T> getAction() {
        return this.action;
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    public void run(QuestContext.Frame frame) {
        Preconditions.checkState((this.future == null ? 1 : 0) != 0, (Object)"already running");
        this.future = frame.newFrame(this.action).run();
    }

    public void close() {
        Preconditions.checkState((this.future != null ? 1 : 0) != 0, (Object)"not running");
        this.future = null;
    }

    public static <T> Consumer<T> complete(CompletableFuture<T> future) {
        return it -> {
            if (it instanceof QuestFuture) {
                ((QuestFuture)it).getFuture().thenAccept(future::complete);
            } else {
                future.complete(it);
            }
        };
    }
}

