/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.library.kether;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.serverct.ersha.taboolib.library.kether.ActionProperties;
import org.serverct.ersha.taboolib.library.kether.ParsedAction;
import org.serverct.ersha.taboolib.library.kether.Quest;

public class SimpleQuest
implements Quest {
    private final char[] content;
    private final String id;
    private final Map<String, Quest.Block> map = Maps.newHashMap();

    public SimpleQuest(char[] content, Map<String, Quest.Block> map2, String id2) {
        this.content = content;
        this.id = id2;
        this.map.putAll(map2);
    }

    public char[] getContent() {
        return this.content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<Quest.Block> getBlock(@NotNull String label) {
        return Optional.ofNullable(this.map.get(label));
    }

    @Override
    public Map<String, Quest.Block> getBlocks() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Optional<Quest.Block> blockOf(@NotNull ParsedAction<?> action) {
        if (action.has(ActionProperties.BLOCK)) {
            String s = action.get(ActionProperties.BLOCK);
            Quest.Block block = this.map.get(s);
            if (block.getActions().contains(action)) {
                return Optional.of(block);
            }
            return Optional.empty();
        }
        for (Quest.Block block : this.map.values()) {
            if (!block.getActions().contains(action)) continue;
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public String toString() {
        return "SimpleQuest{id='" + this.id + '\'' + ", map=" + this.map + '}';
    }

    public static class SimpleBlock
    implements Quest.Block {
        private final String label;
        private final List<ParsedAction<?>> actions;

        public SimpleBlock(String label, List<ParsedAction<?>> actions) {
            this.label = label;
            this.actions = actions;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public List<ParsedAction<?>> getActions() {
            return this.actions;
        }

        @Override
        public int indexOf(@NotNull ParsedAction<?> action) {
            return this.actions.indexOf(action);
        }

        @Override
        public Optional<ParsedAction<?>> get(int i) {
            if (i >= 0 && i < this.actions.size()) {
                return Optional.of(this.actions.get(i));
            }
            return Optional.empty();
        }

        public String toString() {
            return "SimpleBlock{label='" + this.label + '\'' + ", actions=" + this.actions + '}';
        }
    }
}

