/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.library.reflex.asm;

import java.lang.reflect.Modifier;
import java.util.List;
import kotlin1520.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.serverct.ersha.taboolib.library.asm.signature.SignatureReader;
import org.serverct.ersha.taboolib.library.asm.signature.SignatureWriter;
import org.serverct.ersha.taboolib.library.reflex.ClassAnnotation;
import org.serverct.ersha.taboolib.library.reflex.JavaClassField;
import org.serverct.ersha.taboolib.library.reflex.LazyClass;
import org.serverct.ersha.taboolib.library.reflex.Reflection;
import org.serverct.ersha.taboolib.library.reflex.reflection.InstantClass;

public final class AsmClassField
extends JavaClassField {
    @NotNull
    private final String descriptor;
    private final int access;
    @NotNull
    private final List<ClassAnnotation> annotations;
    public LazyClass localType;

    public AsmClassField(@NotNull String name2, @NotNull Class<?> owner, @NotNull String descriptor, int access, @NotNull List<? extends ClassAnnotation> annotations) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        super(name2, owner);
        this.descriptor = descriptor;
        this.access = access;
        this.annotations = annotations;
        new SignatureReader(this.descriptor).accept(new SignatureWriter(){

            @Override
            public void visitClassType(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.setLocalType(new LazyClass(name2));
                super.visitClassType(name2);
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.setLocalType(new InstantClass(Reflection.INSTANCE.getPrimitiveType(descriptor)));
                super.visitBaseType(descriptor);
            }
        });
    }

    @NotNull
    public final String getDescriptor() {
        return this.descriptor;
    }

    public final int getAccess() {
        return this.access;
    }

    @Override
    @NotNull
    public List<ClassAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final LazyClass getLocalType() {
        LazyClass lazyClass = this.localType;
        if (lazyClass != null) {
            return lazyClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"localType");
        throw null;
    }

    public final void setLocalType(@NotNull LazyClass lazyClass) {
        Intrinsics.checkNotNullParameter((Object)lazyClass, (String)"<set-?>");
        this.localType = lazyClass;
    }

    @Override
    @NotNull
    public LazyClass getType() {
        return this.getLocalType();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.access);
    }

    @Override
    @NotNull
    public String toString() {
        return "AsmClassField(descriptor='" + this.descriptor + "', access=" + this.access + ") " + super.toString();
    }
}

