/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.listener;

import java.util.UUID;
import kotlin.Metadata;
import kotlin1520.Unit;
import kotlin1520.jvm.functions.Function1;
import kotlin1520.jvm.internal.Intrinsics;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.serverct.ersha.AttributePlus;
import org.serverct.ersha.api.enums.AttributeName;
import org.serverct.ersha.attribute.data.AttributeData;
import org.serverct.ersha.attribute.data.AttributeVariableData;
import org.serverct.ersha.command.stats.GuiStats;
import org.serverct.ersha.manager.AttributeManager;
import org.serverct.ersha.manager.database.DataStore;
import org.serverct.ersha.manager.database.FunctionKt;
import org.serverct.ersha.taboolib.common.platform.event.EventPriority;
import org.serverct.ersha.taboolib.common.platform.event.SubscribeEvent;
import org.serverct.ersha.taboolib.common.platform.function.ExecutorKt;
import org.serverct.ersha.taboolib.common.platform.service.PlatformExecutor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/serverct/ersha/listener/PlayerListener;", "", "()V", "exp", "", "evt", "Lorg/bukkit/event/player/PlayerExpChangeEvent;", "join", "Lorg/bukkit/event/player/PlayerJoinEvent;", "quit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "stats", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "syncHealth", "AttributePlus"})
public final class PlayerListener {
    @NotNull
    public static final PlayerListener INSTANCE = new PlayerListener();

    private PlayerListener() {
    }

    @SubscribeEvent
    public final void exp(@NotNull PlayerExpChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Player player = evt.getPlayer();
        AttributeManager attributeManager = AttributePlus.INSTANCE.getAttributeManager();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        AttributeData data = attributeManager.getAttributeData(uUID, (LivingEntity)player);
        double exp = (double)evt.getAmount() * data.getRandomValue(AttributeName.EXP_ADDITION.toServerName()).doubleValue() / (double)100;
        evt.setAmount((int)((double)evt.getAmount() + exp));
    }

    @SubscribeEvent
    public final void stats(@NotNull InventoryClickEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getInventory().getHolder() instanceof GuiStats) {
            evt.setCancelled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public final void quit(@NotNull PlayerQuitEvent evt) {
        AttributeVariableData attributeVariableData;
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Player player = evt.getPlayer();
        AttributeManager attributeManager = AttributePlus.INSTANCE.getAttributeManager();
        Object object = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"player.uniqueId");
        AttributeData data = attributeManager.remove((UUID)object);
        object = data;
        if (object != null && (attributeVariableData = ((AttributeData)object).getVariable()) != null) {
            attributeVariableData.saveToDatabase();
        }
        DataStore dataStore = FunctionKt.getDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        dataStore.saveToHealth(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public final void join(@NotNull PlayerJoinEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Player player = evt.getPlayer();
        AttributeManager attributeManager = AttributePlus.INSTANCE.getAttributeManager();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        attributeManager.updateAttribute((LivingEntity)player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void syncHealth(@NotNull PlayerJoinEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Player player = evt.getPlayer();
        ExecutorKt.submitAsync$default(false, 30L, 0L, null, (Function1)new Function1<PlatformExecutor.PlatformTask, Unit>(player){
            final /* synthetic */ Player $player;
            {
                this.$player = $player;
                super(1);
            }

            public final void invoke(@NotNull PlatformExecutor.PlatformTask $this$submitAsync) {
                Intrinsics.checkNotNullParameter((Object)$this$submitAsync, (String)"$this$submitAsync");
                DataStore dataStore = FunctionKt.getDatabase();
                Player player = this.$player;
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                double health2 = dataStore.getPlayerHealth(player);
                if (health2 > this.$player.getMaxHealth()) {
                    this.$player.setMaxHealth(health2);
                }
                this.$player.setHealth(health2);
            }
        }, 13, null);
    }
}

