/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.common;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.serverct.ersha.taboolib.common.LifeCycle;
import org.serverct.ersha.taboolib.common.env.RuntimeDependency;
import org.serverct.ersha.taboolib.common.env.RuntimeEnv;
import org.serverct.ersha.taboolib.common.inject.VisitorHandler;
import org.serverct.ersha.taboolib.common.platform.Platform;
import org.serverct.ersha.taboolib.common.platform.PlatformFactory;

@RuntimeDependency(value="!com.google.code.gson:gson:2.8.7", test="!com.google.gson.JsonElement")
public class TabooLibCommon {
    private static String runningFileName = "TabooLib";
    private static Platform runningPlatform = Platform.APPLICATION;
    private static LifeCycle currentLifeCycle = LifeCycle.CONST;
    private static boolean isDevelopmentMode = false;
    private static boolean isStopped = false;
    private static boolean isKotlinLoaded = false;
    private static boolean isSysoutCatcherFound = false;
    private static final Map<LifeCycle, List<Runnable>> postponeExecutor = new ConcurrentHashMap<LifeCycle, List<Runnable>>();

    public static void testSetup() {
        TabooLibCommon.lifeCycle(LifeCycle.CONST);
        TabooLibCommon.lifeCycle(LifeCycle.INIT);
        TabooLibCommon.lifeCycle(LifeCycle.LOAD);
        TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
    }

    public static void testCancel() {
        TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
    }

    public static void postpone(LifeCycle lifeCycle, Runnable runnable) {
        if (currentLifeCycle.ordinal() >= lifeCycle.ordinal()) {
            runnable.run();
        } else {
            postponeExecutor.computeIfAbsent(lifeCycle, k -> new ArrayList()).add(runnable);
        }
    }

    public static void lifeCycle(LifeCycle lifeCycle) {
        TabooLibCommon.lifeCycle(lifeCycle, null);
    }

    /*
     * Unable to fully structure code
     */
    public static void lifeCycle(LifeCycle lifeCycle, @Nullable Platform platform) {
        if (TabooLibCommon.isStopped) {
            return;
        }
        if (platform != null) {
            TabooLibCommon.runningPlatform = platform;
        }
        TabooLibCommon.currentLifeCycle = lifeCycle;
        TabooLibCommon.postponeExecutor.forEach((BiConsumer<LifeCycle, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$lifeCycle$2(org.serverct.ersha.taboolib.common.LifeCycle org.serverct.ersha.taboolib.common.LifeCycle java.util.List ), (Lorg/serverct/ersha/taboolib/common/LifeCycle;Ljava/util/List;)V)((LifeCycle)lifeCycle));
        if (TabooLibCommon.isDevelopmentMode()) {
            TabooLibCommon.print("LifeCycle: " + (Object)lifeCycle);
        }
        switch (1.$SwitchMap$taboolib$common$LifeCycle[lifeCycle.ordinal()]) {
            case 1: {
                TabooLibCommon.isDevelopmentMode = new File("dev").exists() != false || new File(TabooLibCommon.runningFileName + ".dev").exists() != false;
                try {
                    if (TabooLibCommon.isDevelopmentMode()) {
                        TabooLibCommon.print("RuntimeEnv setup...");
                    }
                    RuntimeEnv.ENV.setup();
                }
                catch (NoClassDefFoundError ignored) {
                    if (!TabooLibCommon.isDevelopmentMode()) ** GOTO lbl20
                    TabooLibCommon.print("RuntimeEnv not found.");
                }
lbl20:
                // 3 sources

                if (!TabooLibCommon.isKotlinEnvironment()) break;
                TabooLibCommon.isKotlinLoaded = true;
                PlatformFactory.INSTANCE.init();
                VisitorHandler.injectAll(LifeCycle.CONST);
                break;
            }
            case 2: {
                if (!TabooLibCommon.isKotlinLoaded) break;
                VisitorHandler.injectAll(LifeCycle.INIT);
                break;
            }
            case 3: {
                if (!TabooLibCommon.isKotlinLoaded) {
                    if (TabooLibCommon.isKotlinEnvironment()) {
                        TabooLibCommon.isKotlinLoaded = true;
                        PlatformFactory.INSTANCE.init();
                        VisitorHandler.injectAll(LifeCycle.CONST);
                        VisitorHandler.injectAll(LifeCycle.INIT);
                    } else {
                        TabooLibCommon.isStopped = true;
                        testClass = "kotlin1520.Lazy";
                        throw new RuntimeException("Runtime environment setup failed, please feedback! (test: " + testClass + ", classloader: " + TabooLibCommon.class.getClassLoader() + ")");
                    }
                }
                VisitorHandler.injectAll(LifeCycle.LOAD);
                break;
            }
            case 4: {
                VisitorHandler.injectAll(LifeCycle.ENABLE);
                break;
            }
            case 5: {
                VisitorHandler.injectAll(LifeCycle.ACTIVE);
                break;
            }
            case 6: {
                VisitorHandler.injectAll(LifeCycle.DISABLE);
                PlatformFactory.INSTANCE.cancel();
            }
        }
    }

    public static boolean isKotlinEnvironment() {
        try {
            Class.forName("kotlin1520.Lazy", false, TabooLibCommon.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static boolean isDevelopmentMode() {
        return isDevelopmentMode;
    }

    @NotNull
    public static Platform getRunningPlatform() {
        return runningPlatform;
    }

    @NotNull
    public static LifeCycle getLifeCycle() {
        return currentLifeCycle;
    }

    public static boolean isSysoutCatcherFound() {
        return isSysoutCatcherFound;
    }

    public static boolean isStopped() {
        return isStopped;
    }

    public static void setStopped(boolean value2) {
        isStopped = value2;
    }

    public static void print(Object message) {
        if (TabooLibCommon.isSysoutCatcherFound()) {
            Logger.getLogger(runningFileName).info(Objects.toString(message));
        } else {
            System.out.println(message);
        }
    }

    private static /* synthetic */ void lambda$lifeCycle$2(LifeCycle lifeCycle, LifeCycle cycle, List list) {
        if (cycle == lifeCycle) {
            list.forEach(runnable -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
            postponeExecutor.remove((Object)cycle);
        }
    }

    static {
        try {
            runningFileName = new File(TabooLibCommon.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("io.papermc.paper.logging.SysoutCatcher");
            isSysoutCatcherFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

