/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.common.env;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.Nullable;
import org.serverct.ersha.taboolib.common.TabooLibCommon;
import org.serverct.ersha.taboolib.common.env.AbstractXmlParser;
import org.serverct.ersha.taboolib.common.env.ClassAppender;
import org.serverct.ersha.taboolib.common.env.Dependency;
import org.serverct.ersha.taboolib.common.env.DependencyScope;
import org.serverct.ersha.taboolib.common.env.IO;
import org.serverct.ersha.taboolib.common.env.JarRelocation;
import org.serverct.ersha.taboolib.common.env.Repository;
import org.serverct.ersha.taboolib.library.jarrelocator.JarRelocator;
import org.serverct.ersha.taboolib.library.jarrelocator.Relocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DependencyDownloader
extends AbstractXmlParser {
    private static final Map<Dependency, Set<ClassLoader>> injectedDependencies = new HashMap<Dependency, Set<ClassLoader>>();
    private static final Set<Dependency> downloadedDependencies = new HashSet<Dependency>();
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final Set<JarRelocation> relocation = new HashSet<JarRelocation>();
    private final File baseDir;
    private DependencyScope[] dependencyScopes = new DependencyScope[]{DependencyScope.RUNTIME, DependencyScope.COMPILE};
    private boolean ignoreOptional = true;
    private boolean ignoreException = false;
    private boolean isTransitive = true;
    private boolean isIsolated = false;
    private boolean isInitiative = false;

    public DependencyDownloader(@Nullable File baseDir) {
        this.baseDir = baseDir;
    }

    public DependencyDownloader(@Nullable File baseDir, @Nullable List<JarRelocation> relocation) {
        this.baseDir = baseDir;
        if (relocation != null) {
            for (JarRelocation rel : relocation) {
                if (rel == null) continue;
                this.relocation.add(rel);
            }
        }
    }

    private void createBaseDir() {
        this.baseDir.mkdirs();
    }

    public void injectClasspath(Set<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            Set<ClassLoader> injectedDependencyClassLoaders = injectedDependencies.get(dep);
            if (injectedDependencyClassLoaders != null && injectedDependencyClassLoaders.contains(ClassAppender.judgeAddPathClassLoader(this.isIsolated, this.isInitiative))) continue;
            File file = dep.findFile(this.baseDir, "jar");
            if (file.exists()) {
                ClassLoader loader;
                TabooLibCommon.print(String.format("Loading library %s:%s:%s", dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
                if (this.relocation.isEmpty()) {
                    ClassLoader loader2 = ClassAppender.addPath(file.toPath(), this.isIsolated, this.isInitiative);
                    if (loader2 == null) continue;
                    injectedDependencies.computeIfAbsent(dep, dependency -> new HashSet()).add(loader2);
                    continue;
                }
                String name2 = file.getName().substring(0, file.getName().lastIndexOf(46));
                File rel = new File(file.getParentFile(), name2 + "_r_" + Math.abs(this.relocation.hashCode()) + ".jar");
                if (!rel.exists() || rel.length() == 0L) {
                    try {
                        TabooLibCommon.print("Relocating ...");
                        List<Relocation> rules = this.relocation.stream().map(JarRelocation::toRelocation).collect(Collectors.toList());
                        File tempSourceFile = IO.copyFile(file, File.createTempFile(file.getName(), ".jar"));
                        new JarRelocator(tempSourceFile, rel, rules).run();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Unable to relocate %s%n", dep), e);
                    }
                }
                if ((loader = ClassAppender.addPath(rel.toPath(), this.isIsolated, this.isInitiative)) == null) continue;
                injectedDependencies.computeIfAbsent(dep, dependency -> new HashSet()).add(loader);
                continue;
            }
            try {
                this.loadDependency(this.repositories, dep);
                this.injectClasspath(Collections.singleton(dep));
            }
            catch (IOException e) {
                TabooLibCommon.setStopped(true);
                throw new IllegalStateException("Unable to load dependency: " + dep, e);
            }
        }
    }

    public Set<Dependency> loadDependency(Collection<Repository> repositories, Dependency dependency) throws IOException {
        if (repositories.isEmpty()) {
            throw new IllegalArgumentException("No repositories specified");
        }
        dependency.checkVersion(repositories, this.baseDir);
        if (downloadedDependencies.contains(dependency)) {
            HashSet<Dependency> singleton = new HashSet<Dependency>();
            singleton.add(dependency);
            return singleton;
        }
        File pom = dependency.findFile(this.baseDir, "pom");
        File pom1 = new File(pom.getPath() + ".sha1");
        File jar = dependency.findFile(this.baseDir, "jar");
        File jar1 = new File(jar.getPath() + ".sha1");
        HashSet<Dependency> downloaded = new HashSet<Dependency>();
        downloaded.add(dependency);
        if (IO.validation(pom, pom1) && IO.validation(jar, jar1)) {
            downloadedDependencies.add(dependency);
            if (pom.exists()) {
                downloaded.addAll(this.loadDependencyFromInputStream(pom.toURI().toURL().openStream()));
            }
            return downloaded;
        }
        pom.getParentFile().mkdirs();
        IOException e = null;
        for (Repository repo : repositories) {
            try {
                repo.downloadFile(dependency, pom);
                repo.downloadFile(dependency, jar);
                e = null;
                break;
            }
            catch (Exception ex) {
                e = new IOException(String.format("Unable to find download for %s (%s)", dependency, repo.getUrl()), ex);
            }
        }
        if (e != null) {
            throw e;
        }
        return downloaded;
    }

    public Set<Dependency> loadDependency(List<Repository> repositories, List<Dependency> dependencies) throws IOException {
        this.createBaseDir();
        HashSet<Dependency> downloaded = new HashSet<Dependency>();
        for (Dependency dep : dependencies) {
            downloaded.addAll(this.loadDependency(repositories, dep));
        }
        return downloaded;
    }

    public Set<Dependency> loadDependencyFromPom(Document pom, DependencyScope ... scopes) throws IOException {
        ArrayList<Repository> repos;
        ArrayList<Dependency> dependencies;
        block10: {
            int i;
            dependencies = new ArrayList<Dependency>();
            HashSet<DependencyScope> scopeSet = new HashSet<DependencyScope>(Arrays.asList(scopes));
            NodeList nodes = pom.getDocumentElement().getChildNodes();
            repos = new ArrayList<Repository>(this.repositories);
            if (repos.isEmpty()) {
                repos.add(new Repository());
            }
            try {
                for (i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!node.getNodeName().equals("repositories")) continue;
                    nodes = ((Element)node).getElementsByTagName("repository");
                    for (i = 0; i < nodes.getLength(); ++i) {
                        Element e = (Element)nodes.item(i);
                        repos.add(new Repository(e));
                    }
                    break;
                }
            }
            catch (ParseException ex) {
                throw new IOException("Unable to parse repositories", ex);
            }
            if (this.isTransitive) {
                nodes = pom.getElementsByTagName("dependency");
                try {
                    for (i = 0; i < nodes.getLength(); ++i) {
                        Dependency dep;
                        if (this.ignoreOptional && DependencyDownloader.find("optional", (Element)nodes.item(i), "false").equals("true") || !scopeSet.contains((Object)(dep = new Dependency((Element)nodes.item(i))).getScope())) continue;
                        dependencies.add(dep);
                    }
                }
                catch (ParseException ex) {
                    if (this.ignoreException) break block10;
                    throw new IOException("Unable to parse dependencies", ex);
                }
            }
        }
        return this.loadDependency(repos, dependencies);
    }

    public Set<Dependency> loadDependencyFromInputStream(InputStream pom) throws IOException {
        return this.loadDependencyFromInputStream(pom, this.dependencyScopes);
    }

    public Set<Dependency> loadDependencyFromInputStream(InputStream pom, DependencyScope ... scopes) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xml = builder.parse(pom);
            return this.loadDependencyFromPom(xml, scopes);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Unable to load pom.xml parser", ex);
        }
        catch (SAXException ex) {
            throw new IOException("Unable to parse pom.xml", ex);
        }
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public DependencyScope[] getDependencyScopes() {
        return this.dependencyScopes;
    }

    public DependencyDownloader setDependencyScopes(DependencyScope[] dependencyScopes) {
        this.dependencyScopes = dependencyScopes;
        return this;
    }

    public Map<Dependency, Set<ClassLoader>> getInjectedDependencies() {
        return injectedDependencies;
    }

    public Set<Repository> getRepositories() {
        return this.repositories;
    }

    public boolean isIgnoreOptional() {
        return this.ignoreOptional;
    }

    public DependencyDownloader setIgnoreOptional(boolean ignoreOptional) {
        this.ignoreOptional = ignoreOptional;
        return this;
    }

    public DependencyDownloader setIgnoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
        return this;
    }

    public Set<JarRelocation> getRelocation() {
        return this.relocation;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public void setTransitive(boolean transitive) {
        this.isTransitive = transitive;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void setIsolated(boolean isolated) {
        this.isIsolated = isolated;
    }

    public boolean isInitiative() {
        return this.isInitiative;
    }

    public void setInitiative(boolean initiative) {
        this.isInitiative = initiative;
    }
}

