/*
 * Decompiled with CFR 0.152.
 */
package org.serverct.ersha.taboolib.common.env;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class IO {
    public static boolean validation(File file, File hashFile) {
        return file.exists() && hashFile.exists() && IO.readFile(hashFile).startsWith(IO.getHash(file));
    }

    @NotNull
    public static String getHash(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("sha-1");
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                int total;
                byte[] buffer = new byte[1024];
                while ((total = inputStream.read(buffer)) != -1) {
                    digest.update(buffer, 0, total);
                }
            }
            return IO.getHash(digest);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return "null (" + UUID.randomUUID() + ")";
        }
    }

    @NotNull
    public static String getHash(MessageDigest digest) {
        StringBuilder result = new StringBuilder();
        for (byte b : digest.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String readFile(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = IO.readFully(fileInputStream, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "null (" + UUID.randomUUID() + ")";
        }
    }

    @NotNull
    public static String readFully(InputStream inputStream, Charset charset) throws IOException {
        return new String(IO.readFully(inputStream), charset);
    }

    @NotNull
    public static byte[] readFully(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            stream.write(buf, 0, len);
        }
        return stream.toByteArray();
    }

    @NotNull
    public static File copyFile(File file1, File file2) {
        try (FileInputStream fileIn = new FileInputStream(file1);
             FileOutputStream fileOut = new FileOutputStream(file2);
             FileChannel channelIn = fileIn.getChannel();
             FileChannel channelOut = fileOut.getChannel();){
            channelIn.transferTo(0L, channelIn.size(), channelOut);
        }
        catch (IOException t) {
            t.printStackTrace();
        }
        return file2;
    }

    public static void downloadFile(URL url, File out) throws IOException {
        int len;
        InputStream ins = url.openStream();
        OutputStream outs = Files.newOutputStream(out.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[4096];
        while ((len = ins.read(buffer)) > 0) {
            outs.write(buffer, 0, len);
        }
        outs.close();
        ins.close();
    }
}

