/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.addons;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.Utils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class HolographicDisplays {
    private Auctioneer auctioneer = Auctioneer.getInstance();
    private AuctionData auctionData = new AuctionData();
    public static Hologram hologram;

    public void registerHologramPlaceholders() {
        HologramsAPI.registerPlaceholder((Plugin)Auctioneer.getInstance(), (String)"%item%", (double)1.0, () -> {
            if (AuctionHandler.itemName != null) {
                return AuctionHandler.itemName;
            }
            return Utils.colorize(ConfigValues.placeholders_none);
        });
        HologramsAPI.registerPlaceholder((Plugin)Auctioneer.getInstance(), (String)"%starting_bid%", (double)1.0, () -> {
            if (AuctionHandler.baseCost != 0.0) {
                return Utils.colorize(Utils.formatDouble(AuctionHandler.baseCost));
            }
            return Utils.colorize(ConfigValues.placeholders_none);
        });
        HologramsAPI.registerPlaceholder((Plugin)Auctioneer.getInstance(), (String)"%highest_bid%", (double)0.5, () -> {
            if (AuctionHandler.lastBidder != null && AuctionHandler.currentCost != 0.0) {
                return Utils.colorize(Utils.formatDouble(AuctionHandler.currentCost));
            }
            return Utils.colorize(ConfigValues.placeholders_none);
        });
        HologramsAPI.registerPlaceholder((Plugin)Auctioneer.getInstance(), (String)"%highest_bidder%", (double)0.5, () -> {
            if (AuctionHandler.lastBidder != null) {
                if (Bukkit.getPlayer((UUID)AuctionHandler.lastBidder) != null) {
                    return Utils.colorize(Bukkit.getPlayer((UUID)AuctionHandler.lastBidder).getDisplayName() + "&r");
                }
                return Utils.colorize(Bukkit.getOfflinePlayer((UUID)AuctionHandler.lastBidder).getName());
            }
            return Utils.colorize(ConfigValues.placeholders_none);
        });
        HologramsAPI.registerPlaceholder((Plugin)Auctioneer.getInstance(), (String)"%ending%", (double)0.2, () -> {
            int n = AuctionHandler.timer.get();
            if (n <= 0) {
                return Utils.colorize(ConfigValues.placeholders_ended);
            }
            return Utils.colorize(String.valueOf(n));
        });
    }

    public void createInitialHologram() {
        Location location = this.auctionData.getDisplayLocation().add(0.5, 0.0, 0.5);
        if (hologram == null) {
            hologram = HologramsAPI.createHologram((Plugin)this.auctioneer, (Location)location.clone().add(0.0, 1.0, 0.0).add(0.0, 0.25 * (double)ConfigValues.started_hologram.size(), 0.0));
            ConfigValues.started_hologram.forEach(string -> hologram.appendTextLine(Utils.colorize(string)));
            hologram.setAllowPlaceholders(true);
        }
    }

    public void createBidHologram() {
        Location location = this.auctionData.getDisplayLocation().add(0.5, 0.0, 0.5);
        this.deleteHologram();
        hologram = HologramsAPI.createHologram((Plugin)Auctioneer.getInstance(), (Location)location.clone().add(0.0, 1.0, 0.0).add(0.0, 0.25 * (double)ConfigValues.bid_hologram.size(), 0.0));
        ConfigValues.bid_hologram.forEach(string -> hologram.appendTextLine(Utils.colorize(string)));
        hologram.setAllowPlaceholders(true);
    }

    public void createNoBiddersHologram() {
        Location location = this.auctionData.getDisplayLocation().add(0.5, 0.0, 0.5);
        this.deleteHologram();
        hologram = HologramsAPI.createHologram((Plugin)this.auctioneer, (Location)location.clone().add(0.0, 1.0, 0.0).add(0.0, 0.25 * (double)ConfigValues.no_bidders_hologram.size(), 0.0));
        ConfigValues.no_bidders_hologram.forEach(string -> hologram.appendTextLine(Utils.colorize(string)));
        hologram.setAllowPlaceholders(true);
    }

    public void createSoldHologram() {
        Location location = this.auctionData.getDisplayLocation().add(0.5, 0.0, 0.5);
        this.deleteHologram();
        hologram = HologramsAPI.createHologram((Plugin)this.auctioneer, (Location)location.clone().add(0.0, 1.0, 0.0).add(0.0, 0.25 * (double)ConfigValues.sold_hologram.size(), 0.0));
        ConfigValues.sold_hologram.forEach(string -> hologram.appendTextLine(Utils.colorize(string)));
        hologram.setAllowPlaceholders(true);
    }

    public void deleteHologram() {
        if (hologram != null) {
            hologram.delete();
            hologram = null;
        }
    }
}

