/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.auction.menus;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.auction.items.AuctionItem;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BidUI
implements Listener {
    private Auctioneer auctioneer;
    private FileConfiguration config;
    private Inventory inv;
    private AuctionItem auctionItem;
    private AtomicInteger page = new AtomicInteger(0);
    private ItemBuilder placeBidItem;
    private LinkedHashMap<Integer, Double> bidSlots = new LinkedHashMap();
    private HashMap<Integer, ItemStack> bidItems = new HashMap();
    private int lastBidSlot;

    public BidUI(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.config = auctioneer.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)auctioneer);
        this.getPlaceBidItem();
        this.nextPage();
    }

    public void nextPage() {
        ArrayList arrayList = new ArrayList();
        if (this.inv != null) {
            arrayList.addAll(this.inv.getViewers());
        }
        arrayList.forEach(humanEntity -> humanEntity.closeInventory());
        this.inv = Bukkit.createInventory(null, (int)(9 * ConfigValues.bid_menu_rows), (String)Utils.colorize(ConfigValues.bid_menu_title));
        this.page.set(this.page.get() + 1);
        this.auctionItem = AuctionHandler.currentItem;
        ConfigValues.bid_menu_background_slots.forEach(n -> this.inv.setItem(n.intValue(), ConfigValues.bid_menu_background));
        if (this.auctionItem != null) {
            this.inv.setItem(ConfigValues.bid_menu_display_item_slot, this.auctionItem.getItemStack(true));
        }
        for (int n2 : ConfigValues.bid_menu_bid_slots) {
            double d = AuctionHandler.increaseCostAndGet();
            ItemBuilder itemBuilder = this.placeBidItem.clone();
            itemBuilder.setName(Utils.colorize(this.config.getString("bid-menu.place-bid.name").replace("%amount%", Utils.formatDouble(d))));
            itemBuilder.setLore(new ArrayList<String>());
            this.config.getStringList("bid-menu.place-bid.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string.replace("%amount%", Utils.formatDouble(d)))));
            this.bidSlots.put(n2, d);
            this.bidItems.put(n2, new ItemStack(itemBuilder.toItemStack()));
            this.inv.setItem(n2, itemBuilder.clone().toItemStack());
            this.lastBidSlot = n2;
        }
        arrayList.forEach(humanEntity -> humanEntity.openInventory(this.inv));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!inventoryClickEvent.getInventory().equals(this.inv)) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (this.bidItems.containsValue(inventoryClickEvent.getCurrentItem()) && this.bidSlots.containsKey(inventoryClickEvent.getSlot())) {
            double d = this.bidSlots.get(inventoryClickEvent.getSlot());
            BidUI bidUI = this;
            if (bidUI.auctioneer.getEconomy().getBalance((OfflinePlayer)player) < d) {
                player.sendMessage(Utils.colorize(ConfigValues.not_enough_money));
                if (ConfigValues.not_enough_money_sound_enabled) {
                    player.playSound(player.getLocation(), ConfigValues.not_enough_money_sound, 1.0f, 1.0f);
                }
                return;
            }
            if (ConfigValues.outbidding_self_enabled && AuctionHandler.lastBidder == player.getUniqueId()) {
                player.sendMessage(Utils.colorize(ConfigValues.outbidding_self));
                return;
            }
            ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("bid-menu.bid-placed.material")));
            if (this.config.getString("bid-menu.bid-placed.material").equalsIgnoreCase("PLAYER_HEAD") && this.config.getBoolean("bid-menu.bid-placed.use-bidders-head")) {
                itemBuilder.setSkullOwner(player.getName());
            }
            if (this.config.getBoolean("bid-menu.bid-placed.glowing")) {
                itemBuilder.setGlowing();
            }
            itemBuilder.setName(Utils.colorize(this.config.getString("bid-menu.bid-placed.name").replace("%player_display%", player.getDisplayName()).replace("%player_name%", player.getName()).replace("%amount%", Utils.formatDouble(d))));
            this.config.getStringList("bid-menu.bid-placed.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string.replace("%player_display%", player.getDisplayName()).replace("%player_name%", player.getName()).replace("%amount%", Utils.formatDouble(d)))));
            AuctionHandler.placeMenuBid(player, d);
            this.inv.setItem(inventoryClickEvent.getSlot(), itemBuilder.toItemStack());
            if (inventoryClickEvent.getSlot() == this.lastBidSlot) {
                this.nextPage();
            } else {
                int n;
                Iterator<Integer> iterator = this.bidSlots.keySet().iterator();
                while (iterator.hasNext() && (n = iterator.next().intValue()) != inventoryClickEvent.getSlot()) {
                    if (!this.inv.getItem(n).equals((Object)this.bidItems.get(n))) continue;
                    this.inv.setItem(n, ConfigValues.bid_menu_bid_skipped);
                }
            }
            return;
        }
    }

    public void getPlaceBidItem() {
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(this.config.getString("bid-menu.place-bid.material")));
        if (this.config.getBoolean("bid-menu.place-bid.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(this.config.getString("bid-menu.place-bid.name")));
        this.config.getStringList("bid-menu.place-bid.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
        this.placeBidItem = itemBuilder;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public AtomicInteger getPage() {
        return this.page;
    }
}

