/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.data;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.enums.BidType;
import com.github.rossrao.auctioneer.enums.JoiningType;
import com.github.rossrao.auctioneer.utils.ItemBuilder;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import com.github.rossrao.auctioneer.utils.xseries.XSound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class ConfigValues {
    public static BidType bidding_type;
    public static JoiningType joining_type;
    public static String days;
    public static String hours;
    public static String minutes;
    public static String seconds;
    public static String soon;
    public static boolean automatic_auctions_enabled;
    public static List<String> start_times;
    public static int join_time;
    public static String no_auction;
    public static int max_items;
    public static int bid_end;
    public static List<String> bidding_words;
    public static int increment;
    public static boolean exponential_increment_enabled;
    public static int default_exponential_increment;
    public static boolean distribute_enabled;
    public static int distribute_fee;
    public static String distribute_message;
    public static boolean reminder_enabled;
    public static int reminder_minutes;
    public static String reminder;
    public static String admin_command_permission;
    public static List<String> admin_help;
    public static String auctioneer_command_permission;
    public static List<String> auctioneer_help;
    public static int max_players;
    public static int min_players;
    public static String min_players_message;
    public static String max_players_message;
    public static boolean music_enabled;
    public static Sound music;
    public static boolean npc_enabled;
    public static String npc_name;
    public static String npc_skin;
    public static boolean npc_look_nearby;
    public static String not_enough_money;
    public static boolean not_enough_money_sound_enabled;
    public static Sound not_enough_money_sound;
    public static double join_money_requirement;
    public static String not_enough_requirement_money;
    public static boolean not_enough_requirement_money_sound_enabled;
    public static Sound not_enough_requirement_money_sound;
    public static String not_enough_inventory_space;
    public static List<String> auction_starting;
    public static boolean auction_starting_sound_enabled;
    public static Sound auction_starting_sound;
    public static List<String> auction_welcome;
    public static boolean auction_welcome_sound_enabled;
    public static Sound auction_welcome_sound;
    public static boolean auction_instructions_enabled;
    public static List<String> auction_instructions;
    public static String joined_auction;
    public static boolean joined_sound_enabled;
    public static Sound joined_sound;
    public static String already_at_auction;
    public static boolean participants_invisible;
    public static String auction_ended;
    public static boolean auction_ended_sound_enabled;
    public static Sound auction_ended_sound;
    public static String first_auction;
    public static String next_auction;
    public static boolean new_auction_sound_enabled;
    public static Sound new_auction_sound;
    public static String auction_bid;
    public static boolean auction_bid_sound_enabled;
    public static Sound auction_bid_sound;
    public static String no_time_left;
    public static String someone_already_bid;
    public static boolean outbidding_self_enabled;
    public static String outbidding_self;
    public static String new_offer;
    public static boolean new_offer_sound_enabled;
    public static Sound new_offer_sound;
    public static String no_offers;
    public static String countdown_going_once;
    public static String countdown_going_twice;
    public static boolean countdown_sound_enabled;
    public static Sound countdown_sound;
    public static String no_bids;
    public static String sold;
    public static boolean sold_sound_enabled;
    public static Sound sold_sound;
    public static boolean holograms_enabled;
    public static List<String> started_hologram;
    public static List<String> bid_hologram;
    public static List<String> no_bidders_hologram;
    public static List<String> sold_hologram;
    public static int new_item_time;
    public static int new_offer_time;
    public static int auction_start_time;
    public static boolean join_permission_enabled;
    public static String join_permission;
    public static String no_join_permission;
    public static String no_permission_message;
    public static String placeholders_none;
    public static String placeholders_ended;
    public static boolean animations_disco_ball_enabled;
    public static boolean animations_fireworks_enabled;
    public static boolean display_menu_enabled;
    public static String display_menu_title;
    public static int display_menu_rows;
    public static ItemStack display_menu_background;
    public static List<Integer> display_menu_background_slots;
    public static ItemStack display_menu_close;
    public static int display_menu_close_slot;
    public static int display_menu_display_item_slot;
    public static String reward_claimed;
    public static String reward_menu_title;
    public static int reward_menu_rows;
    public static ItemStack reward_menu_background;
    public static List<Integer> reward_menu_background_slots;
    public static ItemStack reward_menu_close;
    public static int reward_menu_close_slot;
    public static ItemStack reward_menu_claim_all;
    public static int reward_menu_claim_all_slot;
    public static List<String> reward_menu_collect_item_lore_addon;
    public static String bid_menu_title;
    public static int bid_menu_rows;
    public static List<Integer> bid_menu_bid_slots;
    public static ItemStack bid_menu_background;
    public static List<Integer> bid_menu_background_slots;
    public static ItemStack bid_menu_bid_skipped;
    public static int bid_menu_timer_slot;
    public static int bid_menu_display_item_slot;
    public static String joining_menu_title;
    public static int joining_menu_rows;
    public static int joining_menu_join_item_slot;
    public static List<Integer> joining_menu_background_slots;
    public static int joining_menu_close_slot;
    public static int joining_menu_information_slot;
    public static double config_version;

    public ConfigValues() {
        FileConfiguration fileConfiguration = Auctioneer.getInstance().getConfig();
        config_version = fileConfiguration.getDouble("config-version");
        this.updateConfig();
        bidding_type = BidType.valueOf(fileConfiguration.getString("bidding-type").toUpperCase());
        joining_type = JoiningType.valueOf(fileConfiguration.getString("joining-type").toUpperCase());
        days = fileConfiguration.getString("time-units.days");
        hours = fileConfiguration.getString("time-units.hours");
        minutes = fileConfiguration.getString("time-units.minutes");
        seconds = fileConfiguration.getString("time-units.seconds");
        soon = fileConfiguration.getString("time-units.soon");
        automatic_auctions_enabled = fileConfiguration.getBoolean("automatic-auctions-enabled");
        start_times = fileConfiguration.getStringList("start-times");
        join_time = fileConfiguration.getInt("join-time");
        no_auction = fileConfiguration.getString("no-auction");
        max_items = fileConfiguration.getInt("max-items");
        bid_end = fileConfiguration.getInt("bid-end");
        bidding_words = fileConfiguration.getStringList("bidding-words");
        increment = fileConfiguration.getInt("increment");
        exponential_increment_enabled = fileConfiguration.getBoolean("exponential-increment-enabled");
        default_exponential_increment = fileConfiguration.getInt("default-exponential-increment");
        distribute_enabled = fileConfiguration.getBoolean("distribute-enabled");
        distribute_fee = fileConfiguration.getInt("distribute-fee");
        distribute_message = fileConfiguration.getString("distribute-message");
        reminder_enabled = fileConfiguration.getBoolean("reminder-enabled");
        reminder_minutes = fileConfiguration.getInt("reminder-minutes");
        reminder = fileConfiguration.getString("reminder");
        admin_command_permission = fileConfiguration.getString("admin-command-permission");
        admin_help = fileConfiguration.getStringList("admin-help");
        auctioneer_command_permission = fileConfiguration.getString("auctioneer-command-permission");
        auctioneer_help = fileConfiguration.getStringList("auctioneer-help");
        max_players = fileConfiguration.getInt("max-players");
        min_players = fileConfiguration.getInt("min-players");
        min_players_message = fileConfiguration.getString("min-players-message");
        max_players_message = fileConfiguration.getString("max-players-message");
        music_enabled = fileConfiguration.getBoolean("music-enabled");
        music = XSound.valueOf(fileConfiguration.getString("music")).parseSound();
        npc_enabled = fileConfiguration.getBoolean("npc.enabled");
        npc_name = fileConfiguration.getString("npc.name");
        npc_skin = fileConfiguration.getString("npc.skin");
        npc_look_nearby = fileConfiguration.getBoolean("npc.look-nearby");
        not_enough_money = fileConfiguration.getString("not-enough-money");
        not_enough_money_sound_enabled = fileConfiguration.getBoolean("not-enough-money-sound-enabled");
        not_enough_money_sound = XSound.valueOf(fileConfiguration.getString("not-enough-money-sound")).parseSound();
        join_money_requirement = fileConfiguration.getDouble("join-money-requirement");
        not_enough_requirement_money = fileConfiguration.getString("not-enough-requirement-money");
        not_enough_requirement_money_sound_enabled = fileConfiguration.getBoolean("not-enough-requirement-money-sound-enabled");
        not_enough_money_sound = XSound.valueOf(fileConfiguration.getString("not-enough-requirement-money-sound")).parseSound();
        not_enough_inventory_space = fileConfiguration.getString("not-enough-inventory-space");
        auction_starting = fileConfiguration.getStringList("auction-starting");
        auction_starting_sound_enabled = fileConfiguration.getBoolean("auction-starting-sound-enabled");
        auction_starting_sound = XSound.valueOf(fileConfiguration.getString("auction-starting-sound")).parseSound();
        auction_welcome = fileConfiguration.getStringList("auction-welcome");
        auction_welcome_sound_enabled = fileConfiguration.getBoolean("auction-welcome-sound-enabled");
        auction_welcome_sound = XSound.valueOf(fileConfiguration.getString("auction-welcome-sound")).parseSound();
        auction_instructions_enabled = fileConfiguration.getBoolean("auction-instructions-enabled");
        auction_instructions = fileConfiguration.getStringList("auction-instructions");
        joined_auction = fileConfiguration.getString("joined-auction");
        joined_sound_enabled = fileConfiguration.getBoolean("joined-sound-enabled");
        joined_sound = XSound.valueOf(fileConfiguration.getString("joined-sound")).parseSound();
        already_at_auction = fileConfiguration.getString("already-at-auction");
        participants_invisible = fileConfiguration.getBoolean("participants-invisible");
        auction_ended = fileConfiguration.getString("auction-ended");
        auction_ended_sound_enabled = fileConfiguration.getBoolean("auction-ended-sound-enabled");
        auction_ended_sound = XSound.valueOf(fileConfiguration.getString("auction-ended-sound")).parseSound();
        first_auction = fileConfiguration.getString("first-auction");
        next_auction = fileConfiguration.getString("next-auction");
        new_auction_sound_enabled = fileConfiguration.getBoolean("new-auction-sound-enabled");
        new_auction_sound = XSound.valueOf(fileConfiguration.getString("new-auction-sound")).parseSound();
        auction_bid = fileConfiguration.getString("auction-bid");
        auction_bid_sound_enabled = fileConfiguration.getBoolean("auction-bid-sound-enabled");
        auction_bid_sound = XSound.valueOf(fileConfiguration.getString("auction-bid-sound")).parseSound();
        no_time_left = fileConfiguration.getString("no-time-left");
        someone_already_bid = fileConfiguration.getString("someone-already-bid");
        outbidding_self_enabled = fileConfiguration.getBoolean("outbidding-self-enabled");
        outbidding_self = fileConfiguration.getString("outbidding-self");
        new_offer = fileConfiguration.getString("new-offer");
        new_offer_sound_enabled = fileConfiguration.getBoolean("new-offer-sound-enabled");
        new_offer_sound = XSound.valueOf(fileConfiguration.getString("new-offer-sound")).parseSound();
        no_offers = fileConfiguration.getString("no-offers");
        countdown_going_once = fileConfiguration.getString("countdown.going-once");
        countdown_going_twice = fileConfiguration.getString("countdown.going-twice");
        countdown_sound_enabled = fileConfiguration.getBoolean("countdown.sound-enabled");
        countdown_sound = XSound.valueOf(fileConfiguration.getString("countdown.sound")).parseSound();
        no_bids = fileConfiguration.getString("no-bids");
        sold = fileConfiguration.getString("sold");
        sold_sound_enabled = fileConfiguration.getBoolean("sold-sound-enabled");
        sold_sound = XSound.valueOf(fileConfiguration.getString("sold-sound")).parseSound();
        holograms_enabled = fileConfiguration.getBoolean("holograms-enabled");
        started_hologram = fileConfiguration.getStringList("started-hologram");
        bid_hologram = fileConfiguration.getStringList("bid-hologram");
        no_bidders_hologram = fileConfiguration.getStringList("no-bidders-hologram");
        sold_hologram = fileConfiguration.getStringList("sold-hologram");
        new_item_time = fileConfiguration.getInt("new-item-time");
        new_offer_time = fileConfiguration.getInt("new-offer-time");
        auction_start_time = fileConfiguration.getInt("auction-start-time");
        join_permission_enabled = fileConfiguration.getBoolean("join-permission-enabled");
        join_permission = fileConfiguration.getString("join-permission");
        no_join_permission = fileConfiguration.getString("no-join-permission");
        no_permission_message = fileConfiguration.getString("no-permission-message");
        placeholders_none = fileConfiguration.getString("placeholders.none");
        placeholders_ended = fileConfiguration.getString("placeholders.ended");
        animations_disco_ball_enabled = fileConfiguration.getBoolean("animations.disco-ball-enabled");
        animations_fireworks_enabled = fileConfiguration.getBoolean("animations.fireworks-enabled");
        display_menu_enabled = fileConfiguration.getBoolean("display-menu-enabled");
        display_menu_title = fileConfiguration.getString("display-menu.title");
        display_menu_rows = fileConfiguration.getInt("display-menu.rows");
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("display-menu.background.material")));
        if (fileConfiguration.getBoolean("display-menu.background.glowing")) {
            itemBuilder.setGlowing();
        }
        itemBuilder.setName(Utils.colorize(fileConfiguration.getString("display-menu.background.name")));
        fileConfiguration.getStringList("display-menu.background.lore").forEach(string -> itemBuilder.addLoreLine(Utils.colorize(string)));
        display_menu_background = itemBuilder.toItemStack();
        display_menu_background_slots = fileConfiguration.getIntegerList("display-menu.background.slots");
        ItemBuilder itemBuilder2 = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("display-menu.close.material")));
        if (fileConfiguration.getBoolean("display-menu.close.glowing")) {
            itemBuilder2.setGlowing();
        }
        itemBuilder2.setName(Utils.colorize(fileConfiguration.getString("display-menu.close.name")));
        fileConfiguration.getStringList("display-menu.close.lore").forEach(string -> itemBuilder2.addLoreLine(Utils.colorize(string)));
        display_menu_close = itemBuilder2.toItemStack();
        display_menu_close_slot = fileConfiguration.getInt("display-menu.close.slot");
        display_menu_display_item_slot = fileConfiguration.getInt("display-menu.display-item.slot");
        reward_claimed = fileConfiguration.getString("reward-claimed");
        reward_menu_title = fileConfiguration.getString("reward-menu.title");
        reward_menu_rows = fileConfiguration.getInt("reward-menu.rows");
        ItemBuilder itemBuilder3 = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("reward-menu.background.material")));
        if (fileConfiguration.getBoolean("reward-menu.background.glowing")) {
            itemBuilder3.setGlowing();
        }
        itemBuilder3.setName(Utils.colorize(fileConfiguration.getString("reward-menu.background.name")));
        fileConfiguration.getStringList("reward-menu.background.lore").forEach(string -> itemBuilder3.addLoreLine(Utils.colorize(string)));
        reward_menu_background = itemBuilder3.toItemStack();
        reward_menu_background_slots = fileConfiguration.getIntegerList("reward-menu.background.slots");
        ItemBuilder itemBuilder4 = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("reward-menu.close.material")));
        if (fileConfiguration.getBoolean("reward-menu.close.glowing")) {
            itemBuilder4.setGlowing();
        }
        itemBuilder4.setName(Utils.colorize(fileConfiguration.getString("reward-menu.close.name")));
        fileConfiguration.getStringList("reward-menu.close.lore").forEach(string -> itemBuilder4.addLoreLine(Utils.colorize(string)));
        reward_menu_close = itemBuilder4.toItemStack();
        reward_menu_close_slot = fileConfiguration.getInt("reward-menu.close.slot");
        ItemBuilder itemBuilder5 = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("reward-menu.claim-all.material")));
        if (fileConfiguration.getBoolean("reward-menu.claim-all.glowing")) {
            itemBuilder5.setGlowing();
        }
        itemBuilder5.setName(Utils.colorize(fileConfiguration.getString("reward-menu.claim-all.name")));
        fileConfiguration.getStringList("reward-menu.claim-all.lore").forEach(string -> itemBuilder5.addLoreLine(Utils.colorize(string)));
        reward_menu_claim_all = itemBuilder5.toItemStack();
        reward_menu_claim_all_slot = fileConfiguration.getInt("reward-menu.claim-all.slot");
        reward_menu_collect_item_lore_addon = fileConfiguration.getStringList("reward-menu.collect-item.lore-addon");
        bid_menu_title = fileConfiguration.getString("bid-menu.title");
        bid_menu_rows = fileConfiguration.getInt("bid-menu.rows");
        bid_menu_bid_slots = fileConfiguration.getIntegerList("bid-menu.bid-slots");
        ItemBuilder itemBuilder6 = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("bid-menu.background.material")));
        if (fileConfiguration.getBoolean("bid-menu.background.glowing")) {
            itemBuilder6.setGlowing();
        }
        itemBuilder6.setName(Utils.colorize(fileConfiguration.getString("bid-menu.background.name")));
        fileConfiguration.getStringList("bid-menu.background.lore").forEach(string -> itemBuilder6.addLoreLine(Utils.colorize(string)));
        bid_menu_background = itemBuilder6.toItemStack();
        bid_menu_background_slots = fileConfiguration.getIntegerList("bid-menu.background.slots");
        ItemBuilder itemBuilder7 = new ItemBuilder(XMaterial.valueOf(fileConfiguration.getString("bid-menu.bid-skipped.material")));
        if (fileConfiguration.getBoolean("bid-menu.bid-skipped.glowing")) {
            itemBuilder7.setGlowing();
        }
        itemBuilder7.setName(Utils.colorize(fileConfiguration.getString("bid-menu.bid-skipped.name")));
        fileConfiguration.getStringList("bid-menu.bid-skipped.lore").forEach(string -> itemBuilder7.addLoreLine(Utils.colorize(string)));
        bid_menu_bid_skipped = itemBuilder7.toItemStack();
        bid_menu_timer_slot = fileConfiguration.getInt("bid-menu.timer.slot");
        bid_menu_display_item_slot = fileConfiguration.getInt("bid-menu.display-item.slot");
        joining_menu_title = fileConfiguration.getString("joining-menu.title");
        joining_menu_rows = fileConfiguration.getInt("joining-menu.rows");
        joining_menu_join_item_slot = fileConfiguration.getInt("joining-menu.join-item-slot");
        joining_menu_background_slots = fileConfiguration.getIntegerList("joining-menu.background.slots");
        joining_menu_close_slot = fileConfiguration.getInt("joining-menu.close.slot");
        joining_menu_information_slot = fileConfiguration.getInt("joining-menu.information.slot");
    }

    public void updateConfig() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Object[] objectArray;
        Integer[] integerArray;
        FileConfiguration fileConfiguration = Auctioneer.getInstance().getConfig();
        if (config_version == 1.1) {
            fileConfiguration.set("config-version", (Object)1.2);
            fileConfiguration.set("display-menu-enabled", (Object)true);
            fileConfiguration.set("participants-invisible", (Object)false);
            fileConfiguration.set("reward-menu.title", (Object)"Collect your rewards!");
            fileConfiguration.set("reward-menu.rows", (Object)6);
            fileConfiguration.set("reward-menu.background.material", (Object)"BLACK_STAINED_GLASS_PANE");
            fileConfiguration.set("reward-menu.background.glowing", (Object)false);
            fileConfiguration.set("reward-menu.background.name", (Object)"&7");
            fileConfiguration.set("reward-menu.background.lore", new ArrayList());
            integerArray = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 50, 51, 52, 53};
            fileConfiguration.set("reward-menu.background.slots", Arrays.asList(integerArray));
            fileConfiguration.set("reward-menu.close.material", (Object)"BARRIER");
            fileConfiguration.set("reward-menu.close.glowing", (Object)false);
            fileConfiguration.set("reward-menu.close.name", (Object)"&cClose Menu");
            fileConfiguration.set("reward-menu.close.lore", new ArrayList());
            fileConfiguration.set("reward-menu.close.slot", (Object)49);
            objectArray = new String[]{"&8-----------------", "&bClick to claim reward!"};
            fileConfiguration.set("reward-menu.collect-item.lore-addon", Arrays.asList(objectArray));
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.1 to 1.2!");
            config_version = 1.2;
        }
        if (config_version == 1.2) {
            fileConfiguration.set("config-version", (Object)1.3);
            fileConfiguration.set("reward-claimed", (Object)"&b[Auctioneer] &bYou claimed your %item%&r &breward!");
            fileConfiguration.set("reward-menu.claim-all.material", (Object)"CAULDRON");
            fileConfiguration.set("reward-menu.claim-all.glowing", (Object)false);
            fileConfiguration.set("reward-menu.claim-all.name", (Object)"&3Claim all rewards!");
            fileConfiguration.set("reward-menu.claim-all.lore", new ArrayList());
            fileConfiguration.set("reward-menu.claim-all.slot", (Object)48);
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.2 to 1.3!");
            config_version = 1.3;
        }
        if (config_version == 1.3) {
            fileConfiguration.set("config-version", (Object)1.4);
            fileConfiguration.set("bidding-type", (Object)"MENU");
            fileConfiguration.set("auction-instructions-enabled", (Object)false);
            fileConfiguration.set("bid-menu.title", (Object)"Auction");
            fileConfiguration.set("bid-menu.rows", (Object)6);
            integerArray = new Integer[]{0, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 35, 34, 33, 32, 31, 30, 29, 28, 27, 36, 45, 46, 47, 48, 49, 50, 51, 52, 53};
            fileConfiguration.set("bid-menu.bid-slots", Arrays.asList(integerArray));
            fileConfiguration.set("bid-menu.background.material", (Object)"BLACK_STAINED_GLASS_PANE");
            fileConfiguration.set("bid-menu.background.glowing", (Object)false);
            fileConfiguration.set("bid-menu.background.name", (Object)"&7");
            fileConfiguration.set("bid-menu.background.lore", new ArrayList());
            objectArray = new Integer[]{1, 2, 3, 6, 7, 8, 18, 19, 20, 21, 22, 23, 24, 25, 37, 38, 39, 40, 41, 42, 43, 44};
            fileConfiguration.set("bid-menu.background.slots", Arrays.asList(objectArray));
            fileConfiguration.set("bid-menu.place-bid.material", (Object)"GOLD_INGOT");
            fileConfiguration.set("bid-menu.place-bid.glowing", (Object)false);
            fileConfiguration.set("bid-menu.place-bid.name", (Object)"&6Bid %amount% Coins");
            stringArray3 = new String[]{"&bClick to place bid!"};
            fileConfiguration.set("bid-menu.place-bid.lore", Arrays.asList(stringArray3));
            fileConfiguration.set("bid-menu.bid-placed.material", (Object)"PLAYER_HEAD");
            fileConfiguration.set("bid-menu.bid-placed.use-bidders-head", (Object)true);
            fileConfiguration.set("bid-menu.bid-placed.glowing", (Object)false);
            fileConfiguration.set("bid-menu.bid-placed.name", (Object)"&6Bid Placed by %player_display%");
            stringArray2 = new String[]{"&b%player_display% &bplaced a", "&bbid of &6%amount% Coins!"};
            fileConfiguration.set("bid-menu.bid-placed.lore", Arrays.asList(stringArray2));
            fileConfiguration.set("bid-menu.bid-skipped.material", (Object)"BARRIER");
            fileConfiguration.set("bid-menu.bid-skipped.glowing", (Object)false);
            fileConfiguration.set("bid-menu.bid-skipped.name", (Object)"&cBid Skipped");
            stringArray = new String[]{"&cThis bid amount has been skipped."};
            fileConfiguration.set("bid-menu.bid-skipped.lore", Arrays.asList(stringArray));
            fileConfiguration.set("bid-menu.timer.material", (Object)"CLOCK");
            fileConfiguration.set("bid-menu.timer.glowing", (Object)false);
            fileConfiguration.set("bid-menu.timer.name", (Object)"&f&lTime Remaining:&r &b%end%");
            fileConfiguration.set("bid-menu.timer.lore", new ArrayList());
            fileConfiguration.set("bid-menu.timer.slot", (Object)5);
            fileConfiguration.set("bid-menu.display-item.slot", (Object)4);
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.3 to 1.4!");
            config_version = 1.4;
        }
        if (config_version == 1.4) {
            fileConfiguration.set("npc.look-nearby", (Object)true);
            fileConfiguration.set("animations.disco-ball-enabled", (Object)true);
            fileConfiguration.set("animations.fireworks-enabled", (Object)true);
            fileConfiguration.set("config-version", (Object)1.5);
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.4 to 1.5!");
            config_version = 1.5;
        }
        if (config_version == 1.5) {
            fileConfiguration.set("joining-type", (Object)"MENU");
            fileConfiguration.set("joining-menu.title", (Object)"Auctioneer");
            fileConfiguration.set("joining-menu.rows", (Object)4);
            fileConfiguration.set("joining-menu.join-item-slot", (Object)15);
            fileConfiguration.set("joining-menu.background.material", (Object)"BLACK_STAINED_GLASS_PANE");
            fileConfiguration.set("joining-menu.background.glowing", (Object)false);
            fileConfiguration.set("joining-menu.background.name", (Object)"&7");
            fileConfiguration.set("joining-menu.background.lore", new ArrayList());
            integerArray = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 28, 29, 30, 32, 33, 34, 35};
            fileConfiguration.set("joining-menu.background.slots", Arrays.asList(integerArray));
            fileConfiguration.set("joining-menu.close.material", (Object)"BARRIER");
            fileConfiguration.set("joining-menu.close.glowing", (Object)false);
            fileConfiguration.set("joining-menu.close.name", (Object)"&cClose Menu");
            fileConfiguration.set("joining-menu.close.lore", new ArrayList());
            fileConfiguration.set("joining-menu.close.slot", (Object)31);
            fileConfiguration.set("joining-menu.information.material", (Object)"BOOK");
            fileConfiguration.set("joining-menu.information.glowing", (Object)false);
            fileConfiguration.set("joining-menu.information.name", (Object)"&f&lAuction Information");
            objectArray = new String[]{"&7Players can purchase exclusive items", "&7from the auction, however, they will", "&7only open every few hours.", "", "&fStarting in: &b%timer%", "&fEntry Cost: &6%entry_cost% Coins", ""};
            fileConfiguration.set("joining-menu.information.lore", Arrays.asList(objectArray));
            fileConfiguration.set("joining-menu.information.slot", (Object)11);
            fileConfiguration.set("joining-menu.no-active-auction.material", (Object)"BEDROCK");
            fileConfiguration.set("joining-menu.no-active-auction.glowing", (Object)false);
            fileConfiguration.set("joining-menu.no-active-auction.name", (Object)"&c&lNo Active Auction");
            stringArray3 = new String[]{"&7The auction isn't open at the moment,", "&7check back in &b%timer%&7!"};
            fileConfiguration.set("joining-menu.no-active-auction.lore", Arrays.asList(stringArray3));
            fileConfiguration.set("joining-menu.no-join-permission.material", (Object)"BARRIER");
            fileConfiguration.set("joining-menu.no-join-permission.glowing", (Object)false);
            fileConfiguration.set("joining-menu.no-join-permission.name", (Object)"&c&lLocked");
            stringArray2 = new String[]{"&7You need the &6MVP Rank &7in order", "&7to join the auction!", "", "&fBuy &6MVP &f@ &bstore.example.com"};
            fileConfiguration.set("joining-menu.no-join-permission.lore", Arrays.asList(stringArray2));
            fileConfiguration.set("joining-menu.already-at-auction.material", (Object)"COAL");
            fileConfiguration.set("joining-menu.already-at-auction.glowing", (Object)false);
            fileConfiguration.set("joining-menu.already-at-auction.name", (Object)"&c&lAlready at the Auction");
            stringArray = new String[]{"&7You are already at the auction!"};
            fileConfiguration.set("joining-menu.already-at-auction.lore", Arrays.asList(stringArray));
            fileConfiguration.set("joining-menu.not-enough-money.material", (Object)"GOLD_NUGGET");
            fileConfiguration.set("joining-menu.not-enough-money.glowing", (Object)false);
            fileConfiguration.set("joining-menu.not-enough-money.name", (Object)"&c&lNot Enough Coins");
            String[] stringArray4 = new String[]{"&cYou don't have enough coins in", "&corder to join the auction!", "", "&fRequired Coins: &6%entry_cost% Coins"};
            fileConfiguration.set("joining-menu.not-enough-money.lore", Arrays.asList(stringArray4));
            fileConfiguration.set("joining-menu.join-auction.material", (Object)"EMERALD");
            fileConfiguration.set("joining-menu.join-auction.glowing", (Object)true);
            fileConfiguration.set("joining-menu.join-auction.name", (Object)"&bJoin Auction");
            String[] stringArray5 = new String[]{"&bClick to join the auction!"};
            fileConfiguration.set("joining-menu.join-auction.lore", Arrays.asList(stringArray5));
            fileConfiguration.set("config-version", (Object)1.6);
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.5 to 1.6!");
            config_version = 1.6;
        }
        if (config_version == 1.6) {
            fileConfiguration.set("exponential-increment-enabled", (Object)false);
            fileConfiguration.set("default-exponential-increment", (Object)30);
            fileConfiguration.set("exponential-increments.50", (Object)500000);
            fileConfiguration.set("exponential-increments.100", (Object)1000000);
            fileConfiguration.set("exponential-increments.150", (Object)15000000);
            fileConfiguration.set("config-version", (Object)1.7);
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.6 to 1.7!");
            config_version = 1.7;
        }
        if (config_version == 1.7) {
            fileConfiguration.set("distribute-enabled", (Object)false);
            fileConfiguration.set("distribute-fee", (Object)30);
            fileConfiguration.set("distribute-message", (Object)"&3&lDISTRIBUTED! &bA total of &6%total% Auctioneer Coins &bwere distributed between %participants% Participants. You received &^%coins% Coins&b!");
            fileConfiguration.set("config-version", (Object)1.8);
            Auctioneer.getInstance().saveConfig();
            Auctioneer.getInstance().reloadConfig();
            Auctioneer.getInstance().getLogger().log(Level.INFO, "The config has been updated from version 1.7 to 1.8!");
            config_version = 1.8;
        }
    }
}

