/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.api.BossShopAddon;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSCustomActions;
import org.black_ixx.bossshop.core.BSCustomLink;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShopHolder;
import org.black_ixx.bossshop.core.BSShops;
import org.black_ixx.bossshop.core.conditions.BSConditionType;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.BSConfigShop;
import org.black_ixx.bossshop.managers.item.ItemDataPart;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BossShopAPI {
    private BossShop plugin;
    private List<BossShopAddon> enabled_addons;

    public BossShopAPI(BossShop plugin) {
        this.plugin = plugin;
    }

    public BossShopAddon getAddon(String addonname) {
        if (this.enabled_addons != null) {
            for (BossShopAddon addon : this.enabled_addons) {
                if (!addon.getAddonName().equalsIgnoreCase(addonname)) continue;
                return addon;
            }
        }
        return null;
    }

    public boolean isValidShop(InventoryView v) {
        if (v != null && v.getTopInventory() != null) {
            return this.isValidShop(v.getTopInventory());
        }
        return false;
    }

    public boolean isValidShop(Inventory i) {
        if (i == null) {
            return false;
        }
        return i.getHolder() instanceof BSShopHolder;
    }

    public BSShop getShop(String name) {
        if (this.plugin.getClassManager() == null) {
            return null;
        }
        if (this.plugin.getClassManager().getShops() == null) {
            return null;
        }
        return this.plugin.getClassManager().getShops().getShop(name.toLowerCase());
    }

    public void openShop(Player p, String name) {
        BSShop shop = this.getShop(name);
        if (shop == null) {
            BossShop.log("[API] Error: Tried to open Shop " + name + " but it was not found...");
            return;
        }
        this.openShop(p, shop);
    }

    public void openShop(Player p, BSShop shop) {
        this.plugin.getClassManager().getShops().openShop(p, shop);
    }

    public void updateInventory(Player p) {
        this.updateInventory(p, false);
    }

    public void updateInventory(Player p, boolean force_new_creation) {
        if (this.isValidShop(p.getOpenInventory())) {
            BSShopHolder holder = (BSShopHolder)p.getOpenInventory().getTopInventory().getHolder();
            if (force_new_creation) {
                holder.getShop().openInventory(p, holder.getPage(), false);
            } else {
                holder.getShop().updateInventory(p.getOpenInventory().getTopInventory(), holder, p, ClassManager.manager, holder.getPage(), holder.getHighestPage(), false);
            }
        }
    }

    public BSShops getShopHandler() {
        return this.plugin.getClassManager().getShops();
    }

    public void addShop(BSShop shop) {
        this.getShopHandler().addShop(shop);
    }

    public int createNextShopId() {
        return this.getShopHandler().createId();
    }

    public void addItemToShop(ItemStack menu_item, BSBuy shop_item, BSShop shop) {
        shop.addShopItem(shop_item, menu_item, ClassManager.manager);
    }

    public void finishedAddingItemsToShop(BSShop shop) {
        shop.finishedAddingItems();
    }

    public void registerConditionType(BSConditionType type) {
        type.register();
    }

    public void registerPriceType(BSPriceType type) {
        type.register();
    }

    public void registerRewardType(BSRewardType type) {
        type.register();
    }

    public void registerItemDataPart(ItemDataPart part) {
        part.register();
    }

    public BSBuy createBSBuy(String name, BSRewardType reward_type, BSPriceType price_type, Object reward, Object price, String msg, int location, String permission) {
        return new BSBuy(reward_type, price_type, reward, price, msg, location, permission, name);
    }

    public BSBuy createBSBuyCustom(String name, BSRewardType reward_type, BSPriceType price_type, BSCustomLink reward, Object price, String msg, int location, String permission) {
        return new BSBuy(reward_type, price_type, reward, price, msg, location, permission, name);
    }

    public BSBuy createBSBuy(BSRewardType reward_type, BSPriceType price_type, Object reward, Object price, String msg, int location, String permission) {
        return new BSBuy(reward_type, price_type, reward, price, msg, location, permission, "");
    }

    public BSBuy createBSBuyCustom(BSRewardType reward_type, BSPriceType price_type, BSCustomLink reward, Object price, String msg, int location, String permission) {
        return new BSBuy(reward_type, price_type, reward, price, msg, location, permission, "");
    }

    public BSCustomLink createBSCustomLink(BSCustomActions actions, int action_id) {
        return new BSCustomLink(action_id, actions);
    }

    public HashMap<BSShop, List<BSBuy>> getAllShopItems() {
        HashMap<BSShop, List<BSBuy>> all = new HashMap<BSShop, List<BSBuy>>();
        for (int i : this.plugin.getClassManager().getShops().getShops().keySet()) {
            BSShop shop = this.plugin.getClassManager().getShops().getShop(i);
            if (shop == null) continue;
            ArrayList<BSBuy> items = new ArrayList<BSBuy>();
            for (BSBuy buy : shop.getItems()) {
                if (buy == null || buy.getItem() == null) continue;
                items.add(buy);
            }
            all.put(shop, items);
        }
        return all;
    }

    public HashMap<BSConfigShop, List<BSBuy>> getAllShopItems(String config_option) {
        HashMap<BSConfigShop, List<BSBuy>> all = new HashMap<BSConfigShop, List<BSBuy>>();
        for (int i : this.plugin.getClassManager().getShops().getShops().keySet()) {
            BSShop shop = this.plugin.getClassManager().getShops().getShop(i);
            if (shop == null | !(shop instanceof BSConfigShop)) continue;
            BSConfigShop sho = (BSConfigShop)shop;
            ArrayList<BSBuy> items = new ArrayList<BSBuy>();
            for (BSBuy buy : shop.getItems()) {
                if (buy == null || buy.getItem() == null || !buy.getConfigurationSection(sho).getBoolean(config_option) && buy.getConfigurationSection(sho).getInt(config_option) == 0) continue;
                items.add(buy);
            }
            all.put(sho, items);
        }
        return all;
    }

    protected void addEnabledAddon(BossShopAddon addon) {
        Plugin addonplugin = Bukkit.getPluginManager().getPlugin(addon.getAddonName());
        if (addonplugin == null) {
            return;
        }
        if (this.enabled_addons == null) {
            this.enabled_addons = new ArrayList<BossShopAddon>();
        }
        if (this.enabled_addons.contains((Object)addon)) {
            return;
        }
        this.enabled_addons.add(addon);
    }

    public List<BossShopAddon> getEnabledAddons() {
        return this.enabled_addons;
    }
}

