/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.api;

import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.api.BSAddonConfig;
import org.black_ixx.bossshop.api.BSAddonStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BossShopAddon
extends JavaPlugin {
    private BossShop bs;
    private boolean b = false;

    public void onEnable() {
        double ao_worth;
        this.b = false;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("BossShopPro");
        if (plugin == null) {
            this.printSevere("BossShopPro was not found... you need it in order to run " + this.getAddonName() + "! Get it here: https://www.spigotmc.org/resources/25699/. Version v" + this.getRequiredBossShopVersion() + " or newer is required!");
            this.printInfo("Disabling Addon...");
            this.b = true;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.bs = (BossShop)plugin;
        double bs_worth = this.getWorth(this.bs.getDescription().getVersion());
        if (bs_worth < (ao_worth = this.getWorth(this.getRequiredBossShopVersion()))) {
            this.printSevere("BossShopPro was found but it seems to be outdated... you need v" + this.getRequiredBossShopVersion() + " or newer in order to run " + this.getAddonName() + "! Get it here: https://www.spigotmc.org/resources/25699/");
            this.printInfo("Disabling Addon...");
            this.b = true;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.bs.getAPI().addEnabledAddon(this);
        BossShop.log("Enabling Addon " + this.getAddonName());
        this.enable();
    }

    public void onDisable() {
        if (this.b) {
            return;
        }
        BossShop.log("Disabling Addon " + this.getAddonName());
        this.disable();
    }

    protected void enable() {
        this.enableAddon();
    }

    protected void disable() {
        this.disableAddon();
    }

    public void reload(CommandSender sender) {
        this.bossShopReloaded(sender);
        sender.sendMessage(ChatColor.YELLOW + "Reloaded " + "BossShopPro" + " Addon " + ChatColor.GOLD + this.getAddonName());
    }

    public void printSevere(String msg) {
        Bukkit.getLogger().severe("[" + this.getAddonName() + "] " + msg);
    }

    public void printWarning(String msg) {
        Bukkit.getLogger().warning("[" + this.getAddonName() + "] " + msg);
    }

    public void printInfo(String msg) {
        Bukkit.getLogger().info("[" + this.getAddonName() + "] " + msg);
    }

    public final BossShop getBossShop() {
        return this.bs;
    }

    protected double getWorth(String s) {
        try {
            if (s == null || s.isBlank()) {
                return 0.0;
            }
            s = s.replace("-SNAPSHOT", "");
            double x = 0.0;
            String[] parts = s.replace(".", ":").split(":");
            x += (double)Integer.parseInt(parts[0].trim());
            if (parts.length == 2) {
                x += 0.1 * (double)Integer.parseInt(parts[1].trim());
            }
            if (parts.length == 3) {
                x += 0.1 * (double)Integer.parseInt(parts[1].trim());
                x += 0.01 * (double)Integer.parseInt(parts[2].trim());
            }
            return x;
        }
        catch (Exception e) {
            this.printWarning("Was not able to get the version of " + s);
            return 1.0;
        }
    }

    public BSAddonStorage createStorage(Plugin plugin, String name) {
        return new BSAddonConfig(plugin, name);
    }

    public abstract String getAddonName();

    public abstract String getRequiredBossShopVersion();

    public abstract void enableAddon();

    public abstract void bossShopFinishedLoading();

    public abstract void disableAddon();

    public abstract void bossShopReloaded(CommandSender var1);
}

